// ***********************************************************************
// PCX.HPP
// ***********************************************************************
//
// Written by Michael T. Duffy
//
// Object to handle compression and decompression of PCX format data.
//
// ***********************************************************************

#ifndef PCX_HPP
#define PCX_HPP

#include "bitmap.hpp"

// ***********************************************************************
//  Class Definition
// ***********************************************************************

class PcxPainter : public BitmapPainter
  {

  private:
    USHORT         usBytesPerLine;

    // private, internal functions

    VOID UnpackBuffer
      (
      VOID
      );

    VOID ReadPcxLine8
      (
      PBYTE             pbyLine,
      USHORT            usCanvasWidth
      );

    VOID ReadPcxLine1
      (
      PBYTE             pbyLine,
      USHORT            usCanvasWidth
      );

    ERRORSTATUS PackPcxFile
      (
      VOID
      );

    ERRORSTATUS WritePcxLine8
      (
      PBYTE             pbyLine,
      USHORT            usLineWidth
      );

  public:

    // Constructors
    PcxPainter (VOID);

    PcxPainter (PBYTE  pbyPcxIn,
                ULONG  ulBufferSizeIn);
    PcxPainter (PBYTE  pbyPcxIn,
                ULONG  ulBufferSizeIn,
                PCANVAS  pcnvCanvasIn);


    // Destructor

    ~PcxPainter ();

    // Member functions

    // functions required by BitmapPainter
    ERRORSTATUS AssociateBuffer
      (
      PBYTE            pbyBufferIn,
      ULONG            ulBufferSizeIn
      );

    ERRORSTATUS PaintCanvas
      (
      VOID
      );

    ERRORSTATUS EncodeCanvas
      (
      PBYTE            pbyPalette,
      PBYTE *          ppbyBufferOut,
      PULONG           pulBufferSizeOut
      );

    ERRORSTATUS QueryBitmapStats
      (
      PBITMAPSTATS     pbmsStatsOut
      );
  };

#endif // PCX_HPP
