/*****************************************************************************
 * BT_GET2.CMD  -  OS/2 BitTorrent Commandline Launcher                      *
 * (This script requires Python/2 to be configured in CONFIG.SYS)            *
 *****************************************************************************/

/* ------------------------------------------------------------------------- *
 * DIRECTORY CONSTANTS - EDIT AS APPROPRIATE FOR YOUR SYSTEM                 *
 * ------------------------------------------------------------------------- */

/* Directory where BitTorrent files are installed */
btdir   = 'e:\network\bittorrent'

/* Directory where downloaded files will be placed */
savedir = 'f:\tmp'


/* ------------------------------------------------------------------------- *
 * BITTORRENT CONSTANTS - EDIT AS APPROPRIATE FOR YOUR SYSTEM                *
 * ------------------------------------------------------------------------- */

/* Maximum upload speed when sending to peers */
uploadspeed = 25


/* ------------------------------------------------------------------------- *
 * CHANGES BELOW THIS POINT ARE NOT GENERALLY NECESSARY                      *
 * ------------------------------------------------------------------------- */

/* Check the torrent filename */
PARSE ARG torrent
torrent = STRIP( torrent )
torrent = STRIP( torrent, 'B', '"')
IF torrent = '' THEN DO
    SAY 'Torrent file not specified.'
    RETURN
END

/* Determine the name of the actual file to download (for saving to) */
savename = TargetFileName( torrent )
IF savename \= '' THEN
    saveas = '--saveas "'savedir'\'savename'"'
ELSE
    saveas = ''

/* Print some notices */
SAY 'BitTorrent files:' btdir
SAY 'Save directory:  ' savedir
SAY


/* Launch the command-line BitTorrent downloader */
od = DIRECTORY( btdir )
ADDRESS CMD 'python btdownloadcurses.py --max_upload_rate' uploadspeed saveas '"'torrent'"'
CALL DIRECTORY odir

RETURN


/*****************************************************************************
 * TargetFileName()                                                          *
 *                                                                           *
 * Does a quick-and-dirty parse of the .torrent file to determine the        *
 * recommended save filename.                                                *
 *                                                                           *
 * INPUT:  filename of the .torrent file                                     *
 * OUTPUT: save filename parsed from .torrent, or '' if a problem occurred   *
 *****************************************************************************/
TargetFileName: PROCEDURE
    PARSE ARG torrent
    IF torrent = '' THEN RETURN ''

    CALL LINEIN torrent, 1, 0
    DO WHILE LINES( torrent ) > 0
        in = LINEIN( torrent )
        PARSE VAR in . '4:name' size ':' data
        IF ( size \= '') & ( data \= '') THEN
            fndata = SUBSTR( data, 1, size )
        ELSE
            fndata = ''
        IF fndata \= '' THEN LEAVE
    END
    CALL STREAM torrent, 'C', 'CLOSE'

RETURN fndata

