#define INCL_WIN
#include <os2.h>

#include "hellorc.h"

#define CLS_CLIENT               "WatcomHello"

HAB     hab;

MRESULT EXPENTRY ClientWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    switch (msg) {
        case WM_PAINT: {
            RECTL     rcl;
            POINTL    ptl;
            HPS       hps;

            hps = WinBeginPaint(hwnd, NULLHANDLE, &rcl);
            WinFillRect(hps, &rcl, SYSCLR_WINDOW);
            WinQueryWindowRect(hwnd, &rcl);
            WinDrawText(hps, -1, "Watcom 11.0c says Hi!", &rcl,
                        CLR_BLACK, 0, DT_CENTER | DT_VCENTER);
            WinEndPaint(hps);
        }
        break;

        case WM_COMMAND: {
            switch (SHORT1FROMMP(mp1)) {
                case IDM_ABOUT:
                    WinDlgBox(HWND_DESKTOP, NULLHANDLE, WinDefDlgProc,
                          NULLHANDLE, IDD_ABOUT, NULL);
                    break;

                case IDM_EXIT:
                    WinPostMsg(hwnd, WM_CLOSE, 0, 0);
                    break;
            }
        }
        break;

        default:
            return WinDefWindowProc(hwnd, msg, mp1, mp2);
    }
    return MRFROMSHORT(FALSE);
}

void main(void)
{
    HMQ    hmq;
    ULONG  flCreate;
    HWND   hwndFrame;
    HWND   hwndClient;
    QMSG   qmsg;

    hab = WinInitialize(0);
    hmq = WinCreateMsgQueue(hab, 0);

    WinRegisterClass(hab, CLS_CLIENT, ClientWndProc, CS_SIZEREDRAW, 0);

    flCreate = FCF_SYSMENU | FCF_TITLEBAR | FCF_MINBUTTON | FCF_SIZEBORDER |
               FCF_SHELLPOSITION | FCF_TASKLIST | FCF_ICON | FCF_MENU;

    hwndFrame = WinCreateStdWindow(HWND_DESKTOP, WS_VISIBLE, &flCreate,
                                   CLS_CLIENT, "Hello from Watcom C",
                                   CS_SIZEREDRAW, NULLHANDLE,
                                   RES_CLIENT, &hwndClient);

    if (hwndFrame != NULLHANDLE) {
        while (WinGetMsg(hab, &qmsg, NULLHANDLE, 0, 0))
            WinDispatchMsg(hab, &qmsg);

        WinDestroyWindow(hwndFrame);
    }

    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);
}
