/*
 * Bogofilter training script: non-spam.
 *
 * (C) 2003-04 Yuri Dario <mc6530@mclink.it>
 *
 * 1.0 initial work
 * 1.1 use bogofilter -b switch
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse arg BaseDir

'@echo off'

/* Find msg files */
say 'Scanning for message files...'
call SysFileTree BaseDir || '\*.MSG', 'file', 'FSO'
say 'Found ' || file.0 || ' message files.'

dot = file.0 / 100
percent = 0

say 'Building message list...'
n = 0;

'if exist train.$$$ del train.$$$'

parse value SysCurPos() with row col
do i=1 to file.0
  if n>=dot then do
    call SysCurPos row, col
    say 'Done ' || percent || '%'
    n = 0
    percent = percent + 1
  end
  n = n + 1
  rc = lineout( "train.$$$", file.i)
end

/* close file */
rc = lineout( "train.$$$")

call SysCurPos row, 0
say 'Done 100%'
call SysCurPos row, 0

say 'Creating wordlist (will take a while)...'
'bogofilter -v -n -b < train.$$$'
'del train.$$$'

say 'Done.'
