var gl_iItemsLoaded  = 0;
var gl_iCheckedItems = 0;

function LoadItems(fMore=true)
{
  const elDomain = document.getElementById( "filter-form__domain" );
  const elType = document.getElementById( "filter-form__type" );
  const strType = elType ? elType.options[elType.selectedIndex].value : "s";
  const strText = document.getElementById( "filter-form__text" ).value;
  const elList = document.getElementById( "list" );
  const elLoadPrev = document.getElementById( "load-prev" );
  const elLoadMore = document.getElementById( "load-more" );
  const elListCBAll = document.getElementById( "list__cb-all" );
  const elFrom = document.getElementById( "filter-form__from" );
  var iFrom = parseInt( elFrom.value );
  const fUserLevelAdmin = document.getElementById( "menu__user-level" ).value == "admin";

  if ( isNaN( iFrom ) )
    iFrom = 0;

  var strReq = "ajax_domains_list?";

  if ( elDomain )
    strReq += "d=" + elDomain.value + "&";

  strReq += "t=" + strType + "&s=" + encodeURIComponent( strText ) + "&f=";
  if ( fMore )
    strReq += (iFrom + gl_iItemsLoaded);
  else
    strReq += "-" + iFrom;

  const elFirstRow = elList.firstChild;

  utilAJAX( strReq,
    function(xmlRoot) {
      const xmlList = xmlRoot.firstChild;
      const iReplyFrom = parseInt( xmlList.getAttribute( "from" ) );

      if ( gl_iItemsLoaded == 0 )
      {
        if ( !xmlList.firstChild )
        {
          document.getElementById( "search-empty" ).classList.remove( "pe_hidden" );
          elListCBAll.disabled = true;
          return;
        }
        elListCBAll.disabled = false;
      }

      if ( !fMore )
      {
        elFrom.value = iReplyFrom;
        iFrom = iReplyFrom;
      }

      if ( iFrom != 0 )
        elLoadPrev.classList.remove( "pe_hidden" );
      else
        elLoadPrev.classList.add( "pe_hidden" );

      if ( fMore )
      {
        if ( xmlList.getAttribute( "more" ) == "1" )
          elLoadMore.classList.remove( "pe_hidden" );
        else
          elLoadMore.classList.add( "pe_hidden" );
      }

      for(xmlItem of xmlList.childNodes) {
        if ( xmlItem.nodeType != 1 || xmlItem.nodeName != "item" )
          continue;

        const iLimit = parseInt(xmlItem.getAttribute( "storage-limit" ));
        const iUsed = parseInt(xmlItem.getAttribute( "storage-used" ));
        const strFlags = xmlItem.getAttribute( "flags" );
        const strItem = utilGetNodeText( xmlItem );

        const elRow = document.createElement( "div" );
        elRow.classList.add( "pe__row" );
        elRow.classList.add( "pe__row_ctl" );
        if ( fMore )
          elList.appendChild( elRow );
        else
          elList.insertBefore( elRow, elFirstRow );

        const elCaption = document.createElement( "div" );
        elCaption.classList.add( "peRowCtl__caption" );
        elRow.appendChild( elCaption );

        var el = document.createElement( "input" );
        el.type = "checkbox";
        el.dataset.item = strItem;
        el.addEventListener( "change", function(e) {
          gl_iCheckedItems += (e.target.checked ? 1 : -1);
          document.getElementById( "list__del-btn" ).disabled =
            gl_iCheckedItems == 0;
        }, true );
        elCaption.appendChild( el );

        if ( !fUserLevelAdmin && strFlags && strFlags.indexOf( "ADMIN" ) != -1 )
        {
          el.disabled = true;
          el = document.createTextNode( strItem );
        }
        else
        {
          el = document.createElement( "a" );
          var strLink = "?f=" + iReplyFrom + "&";
          if ( elDomain )
            strLink += "d=" + encodeURIComponent( elDomain.value ) + "&n=" +
                       encodeURIComponent( strItem );
          else
            strLink += "n=" + encodeURIComponent( strItem );
          el.href = strLink;
          el.appendChild( document.createTextNode( strItem ) );
        }
        elCaption.appendChild( el );

        const elCtl = document.createElement( "div" );
        elCtl.classList.add( "peRowCtl__ctl" );
        elRow.appendChild( elCtl );

        if ( !isNaN( iLimit ) && iLimit != 0 && !isNaN( iUsed ) )
        {
          elCtl.appendChild( document.createTextNode(
            (iUsed * 100 / iLimit).toFixed(1) + "%" ) );
        }

        gl_iItemsLoaded++;
      }  // for(xmlItem ...
    }  // function(xmlRoot)
  );  // utilAJAX()
}  // LoadItems()

function DeleteItems()
{
  var aCB = document.querySelectorAll( "input:checked" );
  var elDomain = document.getElementById( "filter-form__domain" );
  var strItem = "", strBody;

  strBody = elDomain ? ( "domain=" + elDomain.value + "&" ) : "";
  strBody += "names=";

  // Make POST request body (application/x-www-form-urlencoded)
  for(var iIdx = 0; iIdx < aCB.length; iIdx++)
  {
    var elCB = aCB[iIdx];
    if ( elCB.dataset.item == undefined )
      continue;

    if ( strItem == "" )
      strItem = elCB.dataset.item;
    else
      strItem = " " + elCB.dataset.item;

    strBody += encodeURIComponent( strItem );
  }

  utilAJAXPost( "ajax_domains_delete", false, strBody,
    function(xmlRoot) {
      // The server returns a list of removed items.
      var xmlList = xmlRoot.firstChild;

      for(xmlItem of xmlList.childNodes) {
        if ( xmlItem.nodeType != 1 || xmlItem.nodeName != "item" )
          continue;

        const strItem = utilGetNodeText( xmlItem );
        const el = document.querySelector( "input[data-item='" + strItem + "']" );

        if ( el )
        {
          utilRemoveNode( el.parentElement.parentElement );
          gl_iItemsLoaded--;
        }
      }

      const aCB = document.querySelectorAll( "input[data-item]" );
      gl_iCheckedItems = 0;
      for(var iIdx = 0; iIdx < aCB.length; iIdx++)
      {
        if ( aCB[iIdx].checked )
          gl_iCheckedItems++;
      }
      document.getElementById( "list__del-btn" ).disabled = gl_iCheckedItems == 0;

    }
  );
}

window.addEventListener( "load", function() {
  document.getElementById( "load-prev__btn" ).addEventListener( "click",
    function() { LoadItems( false ); }, true );
  document.getElementById( "load-more__btn" ).addEventListener( "click",
    function() { LoadItems( true ); }, true );

  document.getElementById( "list__cb-all" ).addEventListener( "change", function(e) {
    var aCB = document.querySelectorAll( "input[data-item]" );

    gl_iCheckedItems = 0;
    for(var iIdx = 0; iIdx < aCB.length; iIdx++)
    {
      if ( aCB[iIdx].disabled )
        continue;

      aCB[iIdx].checked = e.target.checked;
      if ( e.target.checked )
        gl_iCheckedItems++;
    }
    document.getElementById( "list__del-btn" ).disabled = gl_iCheckedItems == 0;
  } );

  document.getElementById( "list__del-btn" ).addEventListener( "click", function(e) {
    confirmation( null, DeleteItems );
  }, true );

  document.getElementById( "filter-form__cross" ).addEventListener( "click", function(e) {
    document.getElementById( "filter-form__text" ).value = "";
    document.getElementById( "filter-form" ).submit();
    e.preventDefault();
    return false;
  }, true );

  document.getElementById( "filter-form__loupe" ).addEventListener( "click", function(e) {
    document.getElementById( "filter-form" ).submit();
    e.preventDefault();
    return false;
  }, true );

  document.getElementById( "filter-form__text" ).focus();
  LoadItems();

}, true );
