divert(-1)
#
# Copyright (c) 1998, 1999 Sendmail, Inc. and its suppliers.
#	All rights reserved.
# Copyright (c) 1983 Eric P. Allman.  All rights reserved.
# Copyright (c) 1988, 1993
#	The Regents of the University of California.  All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
#

divert(0)dnl
VERSIONID(`$Id: cs-os2.mc, Exp $')
OSTYPE(`os2')dnl
DOMAIN(generic.os2)

dnl define(`MAIL_HUB', `test.os2')dnl
define(`SMART_HOST', `smtp.apex.dp.ua')dnl
define(`DATABASE_MAP_TYPE', `hash')dnl

FEATURE(`mailertable', `DATABASE_MAP_TYPE MAIL_SETTINGS_DIR`'mailertable')dnl
FEATURE(`domaintable', `DATABASE_MAP_TYPE MAIL_SETTINGS_DIR`'domaintable')dnl
FEATURE(`genericstable', `DATABASE_MAP_TYPE MAIL_SETTINGS_DIR`'genericstable')dnl
FEATURE(`uucpdomain', `DATABASE_MAP_TYPE MAIL_SETTINGS_DIR`'uucpdomain')dnl
FEATURE(`virtusertable', `DATABASE_MAP_TYPE MAIL_SETTINGS_DIR`'virtusertable')dnl
FEATURE(`access_db', `DATABASE_MAP_TYPE -T<TMPF> MAIL_SETTINGS_DIR`'access')dnl
FEATURE(`authinfo', `DATABASE_MAP_TYPE MAIL_SETTINGS_DIR`'authinfo')dnl
FEATURE(`dnsbl', `bl.spamcop.net', `"Spam blocked see: http://spamcop.net/bl.shtml?" $&{client_addr}')dnl 
FEATURE(`enhdnsbl', `relays.ordb.org', `"571 ACCESS DENIED to <"$&f"> thru VERIFIED OPEN MAIL RELAY "$&{client_name}" (http://www.ordb.org/lookup/index.php?host="$&{client_addr}" + http://mail-abuse.org/tsi/ar-fix.html)"', `t', `127.0.0.2.')dnl
FEATURE(`enhdnsbl', `dynablock.wirehub.net', `"571 5.7.1 ACCESS DENIED to "$&{client_name}" by Wirehub! Internet DynaBlock (http://doema.wirehub.nl/error/errors.html)"', `t', `127.0.0.2.')dnl
FEATURE(`enhdnsbl', `blackholes.wirehub.net', `"571 ACCESS DENIED to <"$&f"> thru "$&{client_name}" by Wirehub! Internet DNSBL (http://doema.wirehub.nl/error/errors.html)"', `t', `127.0.0.2.')dnl

define(`confINPUT_MAIL_FILTERS', `DrWeb-Filter, Perlustrator')
MAIL_FILTER(`DrWeb-Filter', `S=inet:3001@localhost, F=T, T=C:10m;S:30m;R:30m;E:1h')
MAIL_FILTER(`Perlustrator', `S=inet:3333@localhost, F=T, T=C:10m;S:30m;R:30m;E:1h')


FEATURE(`use_cw_file')dnl
FEATURE(`nouucp', `reject')dnl
FEATURE(`always_add_domain')dnl
FEATURE(`allmasquerade')dnl
FEATURE(`limited_masquerade')dnl
FEATURE(`masquerade_entire_domain')dnl
FEATURE(`local_no_masquerade')dnl
FEATURE(`generics_entire_domain')dnl
FEATURE(`virtuser_entire_domain')dnl
FEATURE(`relay_based_on_MX')dnl
FEATURE(`blacklist_recipients')dnl
dnl FEATURE(`delay_checks',`hater')dnl
FEATURE(`lookupdotdomain')dnl

MASQUERADE_AS(`agro2.dp.ua')dnl
MASQUERADE_DOMAIN(`agrosoyuz.ua')dnl
MASQUERADE_DOMAIN(`agrosoyuz.com.ua')dnl

MAILER(local)dnl
MAILER(smtp)dnl
MAILER(uucp)dnl

dnl QUEUE_GROUP(`mqueue', `P='`QUEUE_DIR`', R=5, r=15, F=f')dnl



LOCAL_RULESETS
#########################################################################
#
# w32.sircam.worm@mm
#
# There are serveral patterns that appear common ONLY to SirCam worm and
# not to Outlook Express, which claims to have sent the worm.  There are
# four headers that always appear together and in this order:
#
#  X-MIMEOLE: Produced By Microsoft MimeOLE V5.50.4133.2400
#  X-Mailer: Microsoft Outlook Express 5.50.4133.2400
#  Content-Type: multipart/mixed; boundary="----27AA9124_Outlook_Express_message_boundary"
#  Content-Disposition: Multipart message
#
# Empirical study of the worm message headers vs. true Outlook Express
# (5.50.4133.2400 & 5.50.4522.1200) messages with multipart/mixed attachments
# shows Outlook Express does:
#
#  a) NOT supply a Content-Disposition header for multipart/mixed messages.
#  b) NOT specify the header X-MimeOLE header name in all-caps
#  c) NOT specify boundary tag with the expression "_Outlook_Express_message_boundary"
#
# The solution below catches any one of this three issues. This is not an ideal
# solution, but a temporary measure. A correct solution would be to check for
# the presence of ALL three header attributes. Also the solution is incomplete
# since Outlook Express 5.0 and 4.0 were not compared.
#
# NOTE regex keys are first dequoted and spaces removed before matching.
# This caused me no end of grief.
#
#########################################################################

KSirCamWormMarker regex -f -aSUSPECT multipart/mixed;boundary=----.+_Outlook_Express_message_boundary
HContent-Type:		$>CheckContentType

SCheckContentType
R$+			$: $(SirCamWormMarker $1 $)
RSUSPECT		$#error $: "553 Possible virus, see http://www.symantec.com/avcenter/venc/data/w32.sircam.worm@mm.html"

HContent-Disposition:	$>CheckContentDisposition

SCheckContentDisposition
R$-			$@ OK
R$- ; $+		$@ OK
R$*			$#error $: "553 Illegal Content-Disposition"
