IMPLEMENTATION MODULE RSAKeys;

        (********************************************************)
        (*                                                      *)
        (*              Defining the RSA key type               *)
        (*                                                      *)
        (*  Programmer:         P. Moylan                       *)
        (*  Last edited:        6 May 2018                      *)
        (*  Status:             Work in progress                *)
        (*                                                      *)
        (*      In case you're wondering what RSA stands for,   *)
        (*      it's Rivest-Shamir-Adleman, after the           *)
        (*      inventors of the algorithm.                     *)
        (*                                                      *)
        (********************************************************)


IMPORT BigNum;

FROM BigNum IMPORT (*type*) BN;

(************************************************************************)

PROCEDURE DiscardKey (k: RSAKeyType);

    (* Discards the key data.  *)

    BEGIN
        BigNum.Discard (k.n);
        BigNum.Discard (k.public);
        BigNum.Discard (k.private);
        BigNum.Discard (k.p);
        BigNum.Discard (k.q);
        BigNum.Discard (k.dp);
        BigNum.Discard (k.dq);
        BigNum.Discard (k.qinv);
    END DiscardKey;

(************************************************************************)

END RSAKeys.

