#ifndef _FREESWAN_H
/*
 * header file for FreeS/WAN library functions
 * Copyright (C) 1998, 1999  Henry Spencer.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/lgpl.txt>.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * RCSID $Id: freeswan.h,v 1.1 2000/11/18 00:30:18 bj Exp $
 */
/*
 * changed by dev@fx.dk (port to OS/2) 24/07/1999
 * changed by dev@fx.dk 09/10/99
 * changed by dev@fx.dk 29/10/1999 (new snapshot)
 */

#define	_FREESWAN_H	/* seen it, no need to see it again */

/*
 * FreeS/WAN library routines
 */



/*
 * We've just got to have some datatypes defined...  And annoyingly, just
 * where we get them depends on whether we're in userland or not.
 */
/* #include <linux/version.h> */
#ifndef KERNEL_VERSION
#  define KERNEL_VERSION(x,y,z) (((x)<<16)+((y)<<8)+(z))
#endif
#ifdef __KERNEL__
#  include <linux/types.h>
#  include <linux/in.h>
#  if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
#    include <linux/bios32.h>
     /* simulate spin locks */
     typedef struct {
       volatile char lock;
     } spinlock_t;

#    define spin_lock_init(x) { (x)->lock = 0;}
#    define spin_lock_irqsave(x,flags) { while ((x)->lock) barrier();\
                                        (x)->lock=1; save_flags(flags);\
                                        cli();}
#    define spin_unlock_irqrestore(x,flags) { (x)->lock=0; restore_flags(flags);}
#  endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0) */
#else
#include <sys/types.h>
#include <stdio.h>
#include <netinet/in.h>
#endif

/*
 * And a synonym for a type we should try to treat as opaque.
 */
typedef struct in_addr ip_address;



/*
 * ASCII/binary conversions
 */

/* unsigned long */
const char *			/* NULL for success, else string literal */
atoul(
	const char *src,
	size_t srclen,		/* 0 means strlen(src) */
	int base,		/* 0 means figure it out */
	unsigned long *resultp
);
size_t				/* space needed for full conversion */
ultoa(
	unsigned long n,
	int base,
	char *dst,
	size_t dstlen
);
#define	ULTOA_BUF	21	/* just large enough for largest result, */
				/* assuming 64-bit unsigned long! */

/* Internet addresses */
const char *			/* NULL for success, else string literal */
atoaddr(
	const char *src,
	size_t srclen,		/* 0 means strlen(src) */
	ip_address *addr
);
size_t				/* space needed for full conversion */
addrtoa(
	ip_address addr,
	int format,		/* character; 0 means default */
	char *dst,
	size_t dstlen
);
#define	ADDRTOA_BUF	16	/* just large enough for largest result */

/* subnets */
const char *			/* NULL for success, else string literal */
atosubnet(
	const char *src,
	size_t srclen,		/* 0 means strlen(src) */
	ip_address *addr,
	ip_address *mask
);
size_t				/* space needed for full conversion */
subnettoa(
	ip_address addr,
	ip_address mask,
	int format,		/* character; 0 means default */
	char *dst,
	size_t dstlen
);
#define	SUBNETTOA_BUF	32	/* large enough for worst case result */

/* ranges */
const char *			/* NULL for success, else string literal */
atoasr(
	const char *src,
	size_t srclen,		/* 0 means strlen(src) */
	char *type,		/* 'a', 's', 'r' */
	ip_address *addrs	/* two-element array */
);
size_t				/* space needed for full conversion */
rangetoa(
	ip_address *addrs,	/* two-element array */
	int format,		/* character; 0 means default */
	char *dst,
	size_t dstlen
);
#define	RANGETOA_BUF	34	/* large enough for worst case result */

/* data types for SA conversion functions */
#ifdef __KERNEL__
typedef __u32 ipsec_spi_t;
#else
typedef u_int32_t ipsec_spi_t;
#endif
struct sa_id {			/* to identify an SA, we need: */
        ip_address dst;		/* A. destination host */
        ipsec_spi_t spi;	/* B. 32-bit SPI, assigned by dest. host */
	int proto;		/* C. protocol */
#		define	SA_ESP	50	/* IPPROTO_ESP */
#		define	SA_AH	51	/* IPPROTO_AH */
#		define	SA_IPIP	4	/* IPPROTO_IPIP */
};

/* SAs */
const char *			/* NULL for success, else string literal */
atosa(
	const char *src,
	size_t srclen,		/* 0 means strlen(src) */
	struct sa_id *sa
);
size_t				/* space needed for full conversion */
satoa(
	struct sa_id sa,
	int format,		/* character; 0 means default */
	char *dst,
	size_t dstlen
);
#define	SATOA_BUF	(3+ULTOA_BUF+ADDRTOA_BUF)

/* generic data, e.g. keys */
size_t				/* 0 failure, else true size */
atodata(
	const char *src,
	size_t srclen,		/* 0 means strlen(src) */
	char *dst,
	size_t dstlen
);
size_t				/* 0 failure, else true size */
datatoa(
	const char *src,
	size_t srclen,
	int format,		/* character; 0 means default */
	char *dst,
	size_t dstlen
);



/*
 * misc. network-address stuff
 */

/* part extraction and special addresses */
ip_address
subnetof(
	ip_address addr,
	ip_address mask
);
ip_address
hostof(
	ip_address addr,
	ip_address mask
);
ip_address
broadcastof(
	ip_address addr,
	ip_address mask
);

/* mask handling */
int
goodmask(
	ip_address mask
);
int
masktobits(
	ip_address mask
);
ip_address
bitstomask(
	int n
);


/*
 * general utilities
 */

#ifndef __KERNEL__
/* option pickup from files (userland only because of use of FILE) */
const char *			/* NULL for success, else string literal */
optionsfrom(
	const char *filename,
	int *argcp,		/* pointers to argc and argv */
	char ***argvp,
	int optind,		/* next argument */
	FILE *errorreport	/* if non-NULL, complain there and die */
);
#endif



#endif /* _FREESWAN_H */
