struct connection *find_fake_connection(void) {
  return connections;
}

struct connection *find_host_connection(struct in_addr me, struct in_addr him,
                                        chunk_t *his_id, int his_idtype) {
  struct connection *d;
  struct connection *found = NULL;
  int best_match = 0;

  for (d = connections; d != NULL; d = d->next) {
    bool ips_match, ids_match, roadwarrior;
    int goodness = 0;

    if (d->this.host.s_addr != me.s_addr
        && d->that.host.s_addr != me.s_addr)
      continue;
    if (!oriented(*d))
      (void)orient(d, FALSE);

    if (no_klips && d->this.host_port != pluto_port)
      continue;
    if (d->this.host.s_addr != me.s_addr)
      continue;

    ips_match = (d->that.host.s_addr == him.s_addr);
    roadwarrior = (d->that.host.s_addr == mask0.sin_addr.s_addr);
    if (!ips_match && !roadwarrior)
      continue;
    ids_match = (d->that.id_type == his_idtype  &&  his_id != NULL
                 && chunksequal(d->that.id, *his_id));

    if (ips_match && ids_match)
      goodness = 60;
    else if (roadwarrior && ids_match)
      goodness = 50;
    else if (ips_match && d->that.id_type == -1)
      goodness = 40;
    else if (ips_match && his_id == NULL)
      goodness = 30;
    else if (roadwarrior && d->that.id_type == -1)
      goodness = 20;
    else if (roadwarrior && his_id == NULL)
      goodness = 10;

    if (goodness > best_match) {
      found = d;
      best_match = goodness;
    }
  }

  if (found  &&  found->that.host.s_addr == mask0.sin_addr.s_addr)
    found = rw_connection(found, him, NULL, NULL);

  return found;
}


/* given a connection suitable for ISAKMP (i.e. the hosts match)
 * find a one suitable for IPSEC (i.e. with matching clients).
 */

#include "connos2.inc"
/*
struct connection *
find_client_connection(
    struct connection *c,
    int peer_idtype, chunk_t peeridentity,
    struct in_addr our_net, struct in_addr our_mask,
    struct in_addr peer_net, struct in_addr peer_mask)
{
    struct connection
    *d,
    *found = NULL;
    struct in_addr peer_addr = c->that.host;
    int best_match = 0;

#if 0 // TRH: I don't see why we should give priority to the
   // current connection.
   //
    // give priority to current connection
     // but even greater priority to a routed connection
     //

    if (c->this.client_net.s_addr == our_net.s_addr
    && c->this.client_mask.s_addr == our_mask.s_addr
    && c->that.client_net.s_addr == peer_net.s_addr
    && c->that.client_mask.s_addr == peer_mask.s_addr)
    {
      passert(oriented(*c));
      if (c->routed)
        return c;
      found = c;
    }
#endif

    for (d = connections; d != NULL; d = d->next)
    {
       bool ips_match, ids_match, roadwarrior;
       bool peerclient_match, roadwarrior_client;
       int goodness = 0;

       if (d->this.host.s_addr != c->this.host.s_addr
           && d->that.host.s_addr != c->this.host.s_addr)
         continue;

       if (!oriented(*d))
         (void)orient(d, FALSE);

       if (d->this.client_net.s_addr != our_net.s_addr)
         continue;
       if (d->this.client_mask.s_addr != our_mask.s_addr)
        continue;
       if (d->this.host.s_addr != c->this.host.s_addr)
        continue;
       if (no_klips  &&  d->this.host_port != pluto_port)
         continue;

       ips_match = (d->that.host.s_addr == c->that.host.s_addr);
       roadwarrior = (d->that.host.s_addr == mask0.sin_addr.s_addr);
       peerclient_match =
         (d->that.client_net.s_addr == peer_net.s_addr
          && d->that.client_mask.s_addr == peer_mask.s_addr);
       roadwarrior_client =
         (d->that.client_net.s_addr == mask0.sin_addr.s_addr
         && d->that.client_mask.s_addr == mask32.sin_addr.s_addr
         && peer_net.s_addr == peer_addr.s_addr
         && peer_mask.s_addr == mask32.sin_addr.s_addr);

      if (!ips_match && !roadwarrior)
        continue;
      if (!peerclient_match && !roadwarrior_client)
        continue;

      ids_match = (d->that.id_type == peer_idtype
         && chunksequal(d->that.id, peeridentity));
      if (!ids_match && d->that.id_type != -1)
        continue;

      if (ips_match && ids_match && peerclient_match)
        goodness = 120;
      else if (ips_match && ids_match && roadwarrior_client)
        goodness = 110;
      else if (roadwarrior && ids_match && peerclient_match)
        goodness = 100;
      else if (roadwarrior && ids_match && roadwarrior_client)
        goodness = 90;
      else if (ips_match && d->that.id_type == -1 && peerclient_match)
        goodness = 80;
      else if (ips_match && d->that.id_type == -1 && roadwarrior_client)
        goodness = 70;
      else if (roadwarrior && d->that.id_type == -1 && peerclient_match)
        goodness = 50;
      else if (roadwarrior && d->that.id_type == -1
        && roadwarrior_client)
        goodness = 40;

      if (d->routed)
        goodness += 5;
      if (goodness > best_match)
      {
        found = d;
        best_match = goodness;
      }
   }

   if (found
       && (found->that.host.s_addr == mask0.sin_addr.s_addr
       || (found->that.client_net.s_addr == mask0.sin_addr.s_addr
       && found->that.client_mask.s_addr == mask32.sin_addr.s_addr)))
     found = rw_connection(found, peer_addr, &peer_net, &peer_mask);

   return found;
}
*/