/* get-next-event loop
 * Copyright (C) 1998, 1999  D. Hugh Redelmeier.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * RCSID $Id: server.h,v 1.1 2000/11/18 00:30:22 bj Exp $
 */
/*
 * changed by dev@fx.dk 18/11/1999 (adding aggressive mode) 
 */

#ifdef __WIN32__
extern struct sockaddr ctl_addr;	/* address of control (whack) socket */
#else
extern struct sockaddr_un ctl_addr;	/* address of control (whack) socket */
#endif
extern void delete_ctl_socket(void);

extern bool listening;	/* should we pay attention to IKE messages? */

/* aggr-patch */
/* For Road Warrior Identity, we allow an IP address to be
 * specified in Aggressive Mode initiator ID payload.
 */
extern bool use_identity_addr;
extern struct in_addr identity_addr;   /* network order */
//

/* IP interface (eg. ipsec0/eth0) */
struct iface {
    char *vname;	/* virtual device name */
    char *rname;	/* real device name */
    struct in_addr addr;	/* interface IP address (network order) */
    int fd;	/* file descriptor of socket for IKE UDP messages */
    struct iface *next;
};

extern struct iface *interfaces;	/* public interfaces */

extern void find_ifaces(unsigned long dyn_ip);
extern void free_ifaces(void);
extern void call_server(void);
