/* * changed by dev@fx.dk 01/12/1999 (adding des support) */

static struct db_attr ot1536des3md5[] = {
	{ OAKLEY_ENCRYPTION_ALGORITHM, OAKLEY_3DES_CBC },
	{ OAKLEY_HASH_ALGORITHM, OAKLEY_MD5 },
	{ OAKLEY_AUTHENTICATION_METHOD, OAKLEY_PRESHARED_KEY },
	{ OAKLEY_GROUP_DESCRIPTION, OAKLEY_GROUP_MODP1536 },
	};

static struct db_attr ot1536des3sha[] = {
  { OAKLEY_ENCRYPTION_ALGORITHM, OAKLEY_3DES_CBC },
  { OAKLEY_HASH_ALGORITHM, OAKLEY_SHA },
  { OAKLEY_AUTHENTICATION_METHOD, OAKLEY_PRESHARED_KEY },
  { OAKLEY_GROUP_DESCRIPTION, OAKLEY_GROUP_MODP1536 },
  };


// 1des
static struct db_attr ot1536desmd5[] = {
	{ OAKLEY_ENCRYPTION_ALGORITHM, OAKLEY_DES_CBC },
	{ OAKLEY_HASH_ALGORITHM, OAKLEY_MD5 },
	{ OAKLEY_AUTHENTICATION_METHOD, OAKLEY_PRESHARED_KEY },
	{ OAKLEY_GROUP_DESCRIPTION, OAKLEY_GROUP_MODP1536 },
	};

static struct db_attr ot1536dessha[] = {
  { OAKLEY_ENCRYPTION_ALGORITHM, OAKLEY_DES_CBC },
  { OAKLEY_HASH_ALGORITHM, OAKLEY_SHA },
  { OAKLEY_AUTHENTICATION_METHOD, OAKLEY_PRESHARED_KEY },
  { OAKLEY_GROUP_DESCRIPTION, OAKLEY_GROUP_MODP1536 },
  };
//

/* Initialize st_oakley field of state for use when initiating in
 * aggressive mode.
 *
 * This should probably get more of its parameters, like what group to use,
 * from the connection specification, but it's not there yet.
 * 
 */
int
init_st_oakley(struct state *st)
{
    struct oakley_trans_attrs ta;

    /* When this SA expires (seconds) */
    ta.life_seconds = st->st_connection->sa_ike_life_seconds;
    ta.life_kilobytes = 1000000;

    ta.encrypt = OAKLEY_DES_CBC;
    ta.encrypter = &oakley_encrypter[OAKLEY_DES_CBC];
//    ta.encrypt = OAKLEY_3DES_CBC;
//    ta.encrypter = &oakley_encrypter[OAKLEY_3DES_CBC];
    ta.hash = OAKLEY_SHA;
    ta.hasher = &oakley_hasher[OAKLEY_SHA];
//    ta.hash = OAKLEY_MD5;
//    ta.hasher = &oakley_hasher[OAKLEY_MD5];
    ta.auth = OAKLEY_PRESHARED_KEY;
//    ta.group = lookup_group(OAKLEY_GROUP_MODP1024);
    ta.group = lookup_group(OAKLEY_GROUP_MODP768);

    st->st_oakley = ta;

    return 0;
}
