/* Structure of messages from whack to Pluto proper.
 * Copyright (C) 1998, 1999  D. Hugh Redelmeier.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * RCSID $Id: whack.h,v 1.1 2000/11/18 00:30:23 bj Exp $
 */
/*
 * changed by dev@fx.dk 18/11/1999 (adding aggressive mode)
 */

/*
 * Since the message remains on one host, native representation is used.
 * Think of this as horizontal microcode: all selected operations are
 * to be done (in the order declared here).
 *
 * MAGIC is used to help detect verion mismatches between whack and Pluto.
 * Whenever the interface (i.e. this struct) changes in form or
 * meaning, change this value (probably by changing the last number).
 */
#define WHACK_MAGIC (('w' << 24) + ('h' << 16) + ('k' << 8) + 8)

/* aggr-patch */
/* Kludge around the fact that the id member of struct end is a chunk_t,
 * which contains a pointer, and you thus cannot send it directly over
 * the connection to Pluto.
 */
struct whack_end {
  struct end end;
  char id[HOST_NAME_LIMIT];
  int id_len;
};
//
struct whack_message {
    unsigned int magic;

    /* name is used in connection and initiate */
    char name[CONNECTION_NAME_LIMIT];

    /* for WHACK_OPTIONS: */

    bool whack_options;

    unsigned int debugging;

    /* for WHACK_CONNECTION */

    bool whack_connection;
    bool whack_async;

// dev@fx.dk
    int trans_order; // transform preference order
    lset_t policy;
    time_t sa_ike_life_seconds;
    time_t sa_ipsec_life_seconds;
    time_t sa_rekey_margin;
    unsigned long sa_rekey_fuzz;
    unsigned long sa_keying_tries;

/* aggr-patch */
    struct whack_end left;
    struct whack_end right;
//    struct end left;
//    struct end right;

    /* for WHACK_ROUTE: */

    bool whack_route;

    /* for WHACK_UNROUTE: */

    bool whack_unroute;

    /* for WHACK_INITIATE: */

    bool whack_initiate;

    /* for WHACK_TERMINATE: */

    bool whack_terminate;

    /* for WHACK_DELETE: */

    bool whack_delete;

    /* for WHACK_LISTEN: */

    bool whack_listen;

/* aggr-patch */
    /* for Road Warrior */
    bool use_identity_addr;
    struct in_addr identity_addr; /* network order */
//
    /* for WHACK_STATUS: */

    bool whack_status;

    /* for WHACK_SHUTDOWN */

    bool whack_shutdown;

    bool whack_password;

    u_int8_t reserved[1012];	/* dev@fx.dk */

};


/* Codes for status messages returned to whack.
 * These are 3 digit decimal numerals.  The structure
 * is inspired by section 4.2 of RFC959 (FTP).
 * Since these will end up as the exit status of whack, they
 * must be less than 256.
 * NOTE: ipsec_auto(8) knows about some of these numbers -- change carefully.
 */
enum rc_type {
    RC_COMMENT,   /* non-commital utterance (does not affect exit status) */
    RC_WHACK_PROBLEM, /* whack-detected problem */
    RC_LOG,   /* message aimed at log (does not affect exit status) */
    RC_SUCCESS,   /* success (exit status 0) */

    /* failure, but not definitive */

    RC_RETRANSMISSION = 10,

    /* improper request */

    RC_DUPNAME = 20,  /* attempt to reuse a connection name */
    RC_UNKNOWN_NAME,  /* connection name unknown */
    RC_ORIENT,  /* cannot orient connection: neither end is us */
    RC_DEAF,  /* need --listen before --initiate */
    RC_ROUTE, /* cannot route */
    RC_RTBUSY,  /* cannot unroute: route busy */

    /* permanent failure */

    RC_BADWHACKMESSAGE = 30,
    RC_NORETRANSMISSION,
    RC_INTERNALERR,

    /* progress: start of range for successful state transition.
     * Actual value is RC_NEW_STATE plus the new state code.
     */
    RC_NEW_STATE = 100,

    /* start of range for notification.
     * Actual value is RC_NOTIFICATION plus code for notification
     * that should be generated by this Pluto.
     */
    RC_NOTIFICATION = 200 /* as per IKE notification messages */
};
