// #define _MEMDEBUG  1
#ifdef _MEMDEBUG

void   memdebug_setpoint(const char *file, int line);
void * memdebug_check_alloc(void *p);
void * memdebug_check_free(void *p);
void * memdebug_check_free0(void *p);
void   memdebug_free(void *p, const char *file, int line);

char * xstrdup_real(const char *s);

void   memdebug_declevel(void);
// extern int memdebug_level;

#define _MEMDEBUG_FILE  __FILE__
#ifndef malloc
  #define malloc(n)     (memdebug_setpoint(_MEMDEBUG_FILE, __LINE__), memdebug_check_alloc(malloc(n)))
#endif
#define strdup(s)     (memdebug_setpoint(_MEMDEBUG_FILE, __LINE__), memdebug_check_alloc(strdup(s)))
// #define xstrdup(s)    (memdebug_setpoint(_MEMDEBUG_FILE, __LINE__), memdebug_check_alloc(xstrdup_real(s)))
// #define free(p)       (memdebug_setpoint(_MEMDEBUG_FILE, __LINE__), free(memdebug_check_free(p)), memdebug_declevel())
#define free(p)       memdebug_free(p, _MEMDEBUG_FILE, __LINE__)
#if	!defined(MALLOCDEBUG) /* in this case, oops' xfree() == free() */
  #define xfree(p)       memdebug_free(p, _MEMDEBUG_FILE, __LINE__)
#endif
#define realloc(p, n) (memdebug_setpoint(_MEMDEBUG_FILE, __LINE__), memdebug_check_alloc(realloc(memdebug_check_free0(p), n)))
#define calloc(a, n)  (memdebug_setpoint(_MEMDEBUG_FILE, __LINE__), memdebug_check_alloc(calloc(a, n)))

// #undef  zfree
// #define zfree(p) (memdebug_setpoint(_MEMDEBUG_FILE, __LINE__), memdebug_check_free0(p), z_zfree(&(p)), memdebug_declevel())

#endif
