#!/usr/bin/rexx
/*-- OREXX -------------------------------------------------------------------*/
/*                                                                            */
/* Module:      make_mod_rexx.rex                                             */
/*                                                                            */
/* Author:      W. David Ashley                                               */
/*                                                                            */
/* Description: REXX program which will make a Mod_Rexx binary based on your  */
/*              operating system and REXX interpreter.                        */
/*                                                                            */
/* Notes: This script assumes the the user has write access to the current    */
/*        directory so that files can be created and removed from the current */
/*        directory.                                                          */
/*                                                                            */
/*        OS/2 users will need to remove the first line of this file and then */
/*        rename it to something like make_mod_rexx.cmd before this script    */
/*        can be executed by OS/2 REXX.                                       */
/*                                                                            */
/* Copyright (C) W. David Ashley 2004. All Rights Reserved.                   */
/*                                                                            */
/* This software is subject to the terms of the Commom Public License. You    */
/* must accept the terms of this license to use this software. Refer to       */
/* the file CPLv1.0.htm included in this package for more information.        */
/*                                                                            */
/* The program is provided "as is" without any warranty express or implied,   */
/* including the warranty of non-infringement and the implied warranties of   */
/* merchantibility and fitness for a particular purpose.                      */
/*                                                                            */
/*----------------------------------------------------------------------------*/


/* find out the operating system */
parse source source_str
parse var source_str os .
if substr(os, 1, 7) = 'Windows' then os = 'WINDOWS'
if os = 'WIN32' then os = 'WINDOWS' /* for Regina */
if os = 'UNIX' then os = 'LINUX'    /* for Regina */
select 
   when os = 'OS/2' then nop
   when os = 'LINUX' then nop
   when os = 'AIX' then nop
   when os = 'WINDOWS' then nop
   otherwise do
      say 'Error: Unknown operating system.'
      return 12
      end
   end

/* get any command line arguments */
parse arg arguments
parse upper var arguments rexx_interpreter .
if rexx_interpreter = '' then rexx_interpreter = 'HELP'
select 
   when rexx_interpreter = 'HELP' then do 
      call helpmsg
      return 0
      end
   when rexx_interpreter = 'OREXX' then nop
   when rexx_interpreter = 'REGINA' then nop
   when rexx_interpreter = 'REXXTRANS' then nop
   otherwise do
      say 'Error: Invalid REXX interpreter argument found.'
      return 8
      end
   end
if os = 'OS/2' & rexx_interpreter = 'REGINA' then do
   say 'Error: Regina is not supported in the OS/2 environment.'
   return 8
   end
if os = 'OS/2' & rexx_interpreter = 'REXXTRANS' then do
   say 'Error: Rexx/Trans is not supported in the OS/2 environment.'
   return 8
   end
if os = 'AIX' & rexx_interpreter = 'REGINA' then do
   say 'Error: Regina is not supported in the AIX environment.'
   return 8
   end

/* now call the appropriate functions for making Mod_Rexx */
select
   when os = 'OS/2' then do
      'copy makefile.os2 makefile'
      'nmake'
      'copy mod_rexx.dll .\bin'
      'nmake cleanall'
      'del makefile'
      end
   when os = 'LINUX' then do
      'cp ./makefile.linux ./makefile'
      if rexx_interpreter = 'OREXX' then do
         'make REXXINT='rexx_interpreter
         'cp mod_rexx.so ./bin'
         'make cleanall'
         end
      else if rexx_interpreter = 'REGINA' then do
         'make REXXINT='rexx_interpreter
         'cp mod_rexx.so ./bin'
         'make cleanall'
         end
      else if rexx_interpreter = 'REXXTRANS' then do
         'make REXXINT='rexx_interpreter
         'cp mod_rexx.so ./bin'
         'make cleanall'
         end
      else nop
      'rm ./makefile'
      end
   when os = 'AIX' then do
      'cp ./makefile.aix ./makefile'
      if rexx_interpreter = 'OREXX' then do
         'make -DREXXINT='rexx_interpreter
         'cp mod_rexx.so ./bin'
         'make cleanall'
         end
      else nop
      'rm ./makefile'
      end
   when os = 'WINDOWS' then do
      'copy makefile.nt makefile'
      if rexx_interpreter = 'OREXX' then do
         'nmake REXXINT='rexx_interpreter 
         'copy mod_rexx.dll .\bin'
         'nmake cleanall'
         end
      else if rexx_interpreter = 'REGINA' then do
         'nmake REXXINT='rexx_interpreter 
         'copy mod_rexx.dll .\bin'
         'nmake cleanall'
         end
      else if rexx_interpreter = 'REXXTRANS' then do
         'nmake REXXINT='rexx_interpreter 
         'copy mod_rexx.dll .\bin'
         'nmake cleanall'
         end
      else nop
      'del makefile'
      end
   otherwise nop
   end

return 0


helpmsg:
say
if os = 'OS/2' then do
   say 'Syntax: make_mod_rexx help|orexx'
   say 
   say 'The help argument will give you this message.'
   say 'The orexx argument will cause Mod_Rexx to be built & bound to Object'
   say 'or Classic REXX.' 
   say 
   say 'Note: OS/2 is now unsupported by Mod_Rexx. All the OS/2 support code'
   say 'still exists in Mod_Rexx but do not expect any support from the'
   say 'Mod_Rexx team. You are on your own.'
   end
else if os = 'AIX' then do
   say 'Syntax: make_mod_rexx help|orexx'
   say 
   say 'The help argument will give you this message.'
   say 'The orexx argument will cause Mod_Rexx to be built & bound to Object REXX.'
   end
else do
   say 'Syntax: rexx make_mod_rexx.rex help|orexx|regina|rexxtrans'
   say 
   say 'The help argument will give you this message.'
   say 'The orexx argument will cause Mod_Rexx to be built & bound to Object REXX.'
   say 'The regina argument will cause Mod_Rexx to be built & bound to Regina REXX.'
   say 'The rexxtrans argument will cause Mod_Rexx to be built & bound to RexxTrans.'
   end
say
return

