/* MAKEICON.CMD -- make a program reference object (Icon) for GoServe  */
/* ------------------------------------------------------------------- */
/* This makes a GoServe program reference object on the desktop.       */
/* It should be called from the GoServe program/working directory.     */
/* ------------------------------------------------------------------- */
/* Call as:  MAKEICON HTTP    /* For a Web server object */            */
/*   or as:  MAKEICON GOPHER  /* For a Gopher server object */         */
/* ------------------------------------------------------------------- */
/* This program use the REXXUTIL library, part of OS/2 Rexx.           */

arg protocol .
select
  when protocol='HTTP' then do
    type='Web';    parm='HTTP'
    end
  when protocol='GOPHER' then do
    type='Gopher'; parm='Gopher'
    end
  otherwise
    say 'MAKEICON.CMD must be called with the name of the protocol for which'
    say 'you want a GoServe reference object created.  This must be either'
    say '"HTTP" for a Web server or "GOPHER" for a Gopher server.  For example:'
    say
    say '  makeicon http'
    say
    exit 1
  end /* select */

exe    ='GoServe.exe'
dir    =directory()
exefull=dir'\'exe
title  ="GoServe -" type

/* Sanity check */
if stream(exe, 'c', 'query exists')='' then do
  say '"'exe'" does not seem to be in the directory that MAKEICON.CMD'
  say 'was called from ['dir'].'
  say 'Please correct and try again.'
  exit 2; end

/* Now [try and] create the object, on the Desktop */
call load /* load functions if necessary */
call SysCreateObject "WPProgram", title, "<WP_DESKTOP>",,
  "EXENAME="exefull";PARAMETERS="parm";PROGTYPE=PM;STARTUPDIR="dir";", "F"
if result<>1 then do
  say 'Sorry, for some reason the "'title'" object could not be created on'
  say 'the Desktop.  Perhaps it already exists?'
  exit result; end

/* OK, it worked */
say 'The "'title'" object has been created on the Desktop.'
say 'To have it started automatically when OS/2 is booted, make a shadow of the'
say 'object in the Startup folder (hold down Ctrl+Shift while dragging it to'
say 'the Startup Folder and dropping it there).'
exit 0


/* --- Load the function library, if necessary --- */
load:
if \RxFuncQuery("SysLoadFuncs") then return  /* already there */
call RxFuncAdd "SysLoadFuncs","REXXUTIL","SysLoadFuncs"
call SysLoadFuncs
return

