/*EXAMPLE REXXHOOK SCRIPT ____________________________________________________
  DESCRIPTION ________________________________________________________________
  This script let you limit the number for sessions to one FTPd service from
  one specific host.

  CONFIGURATION ______________________________________________________________
  You need to set "LimitSameHost=#" in the correct FTP section of your config
  file. This script will default to 2 connections if that variable is not set.
   
  RETURN VALUE _______________________________________________________________
  This script should return a full FTP response line to reject the login.
  The response line should be according to FTP standards defined.
  ____________________________________________________________________________*/
PARSE ARG Session Arguments;

PARSE VALUE ipsVAR(Session, "%(remoteip)|%(sessions.ip)|%(configfile)|%(configsection)|"), 
  WITH remoteip"|"sessions_ip"|"configfile"|"configsection"|";

PARSE VALUE ipsCFG(Session, configfile, configsection, "LimitSameHost"),
  WITH LimitSameHost;

IF (LimitSameHost <= 0) THEN 
  LimitSameHost = 2;

IF (sessions_ip > LimitSameHost) THEN 
  RETURN "421 No more connections accepted from "remoteip", try again later.";
/*____________________________________________________________________________*/