/* Pre-response component of the the CHECK_404 SREhttp/2 plugin. */

chk_pre:

/******** User changeable parameters  ******/

/* a selector, or url, to redirect "bad requests" to. Or set =''
   to use generic response */
REDIRECT_RESPONSE='/system/CHK_RED.CMD'

/* if redirect_response='', then use MESSAGE_404 as a short message in response. */
MESSAGE_404='Resource not available.'

/******** End of User changeable parameters  ******/

parse arg source,request,host_stuff,socket,ownid

parse var source myaddr port transaction who whoport . /* Often useful */
parse var request verb uri protocol .        /* split up the request line */
parse var host_stuff servername ',' host_nickname ',' datadir

if redirect_response<>'' then do
   if abbrev(uri,redirect_response)=1 then do
      parse var uri a1 '?' a2
      if a1=redirect_response then return 1  /* let the "redirect_response" go through */
   end 
end 

/* see if anything on this client */
aa=sre_cache('CHK_404','READ',who,,,ownid)
if aa='' | abbrev(translate(aa),'ERROR')=1 then return 1          /* no entries, he's innocent */

/* hmm, under a cloud. See how many he's got */
ngot=words(aa)

/* what's the max */
amax=sre_value('CHK_404_MAX404',,'SRE')
if pos('=',aa)=0 then do  /* a shortcut */
   if ngot<=amax then return 1     /* not innocent, but not guilty, let him go */
end


/* Possibly guilty, check times */
nowtime=sreh2_current_second()

duration=sre_value('CHK_404_DURATION',,'SRE')
if datatype(duration)<>'NUM' then duration=5 /* should never happen */

/* time of most recent 404 is first word */
stillbad=''
nbad=0
do until aa=''
   parse var aa atime aa
   parse var atime atime '=' nmult
   if datatype(nmult)<>'NUM' then nmult=1
   if datatype(atime)<>'NUM' then iterate   /* odd error, ignore */
   atime=strip(atime)
   if (nowtime-atime)>duration then do  /* expired */
      aa=sre_cache('CHK_404','WRITE',who,stillbad,,0)   /* drop expired 404s */
      return 1          /* client has redeemed himself */ 
   end
   stillbad=atime||' '||stillbad
   nbad=nbad+max(1,nmult)
   if nbad>amax then leave      /* still verboten. Deny! */
end 

if nbad<=amax then return 1      /* might get here in odd cases */

/* Send a response */
if redirect_response='' then do
  resp='HTTP/1.1 404 Not Found'||'0d0a'x
  resp=resp||'Date: '||sre_datestamp()||'0d0a'x
  resp=resp||'Server: '||sre_server('n')||'0d0a'x
  resp=resp||'Connection: close'||'0d0a'x
  resp=resp||'0d0a'x
  resp=resp||message_404
  return resp
end

/* else, redirect... */

redirect_response=strip(redirect_response)
if abbrev(translate(redirect_response),'HTTP://')=0 then
   auri2='http://'||servername||'/'||strip(redirect_response,'l','/')
else
   auri2=redirect_response
auri2=auri2||'?'||strip(sre_packur_make(uri,1))||'&'||strip(who)
resp='HTTP/1.1 302 Moved Temporarily'||'0d0a'x
resp=resp||'Location:' auri2||'0d0a'x
resp=resp||'Date: '||sre_datestamp()||'0d0a'x
resp=resp||'Server: '||sre_server('n')||'0d0a'x
resp=resp||'Connection: close'||'0d0a'x
resp=resp||'0d0a'x

return resp


