/***************************************************************************
JCOUNT.CMD == return count of file (just like XCOUNT), but as text.
Meant for the #EXEC httpd server side includ
 **************************************************************************/
env = "OS2ENVIRONMENT"
minLen = 7;           /* minimum number of digits in bitmap */
isHigh = 1;           /* if 1, digits are 16 pixels high, to allow room for border */
isInverse = 1;        /* if 1, digits are white on black */
totalreads = 0;       /* number of total reads */
bytes = '';
bytecount = 0;
AccessFile = 'access.cnt'
Incr = 1		/* default is to auto-increment  */


PathTranslated = translate(value( 'PATH_TRANSLATED',, env), '\', '/')
if (right(PathTranslated,1) \= '\') then PathTranslated = PathTranslated'\'
if (PathTranslated \= '\') then value( 'COUNT_FILENAME', PathTranslated || AccessFile, env)

parse arg ArgTxt
ArgTxt = translate(ArgTxt, ' ', '+')	/* older server versions sometimes forget to do this... */
parse var ArgTxt URI I L CLIENTADDR .
if (I \= '') then isInverse = I
if (L \= '') then minLen = L
if (CLIENTADDR == '') then CLIENTADDR = value( REMOTE_ADDR,, env)


/* get counter from file and increment it */
totalreads = Count( URI, Incr, CLIENTADDR)
SAY TOTALREADS

Exit (0)


Count: procedure
/* COUNT.RXX   - a function to track access counts of a given URL. */
/*	Original work by V. Phaniraj,  phaniraj@plains.nodak.edu		*/
/*	Heavily modified by D.L. Meyer,   meyer@larch.ag.uiuc.edu	*/

  env = 'OS2ENVIRONMENT'
  crlf = '0d0a'x
  open_mode = 'OPEN'
  number = 1
  count. = ''

  count.fn = value( 'COUNT_FILENAME',, env)
  if (count.fn == '') then count.fn='access.cnt'  /* ASCII file that contains the counts */

  count.exclude_ips = value( 'COUNT_EXCLUDE_IPS',, env)

  parse arg URI, count.Incr, CLIENTADDR
  if (count.Incr == '') | (count.Incr == 0) 
    then count.Incr = 0
    else count.Incr = 1

  if (CLIENTADDR == '') then CLIENTADDR = '#'

  URL=translate( URI)

  if (pos(CLIENTADDR, count.exclude_ips) > 0) then count.Incl = 0
  if (count.Incl == 0) then open_mode = 'OPEN READ'

/* read the access file into result and close the file  */

  rc = ''
  result = ''
  rest = ''
  do until (rc == 'READY:')
    rc=stream(count.fn, 'C', 'OPEN')
  end
  result=charin(count.fn,,chars(count.fn))

/* look for the URL in the  string, and find the
   number of accesses stored in the file. Try not to
   use linein to avoid keeping the file open too long.
*/

  locate = pos(URL,result)

  if (locate \= 0) then do
     locate = locate+length(URL)+2
     number=substr(result,locate)
     parse var number 'Accesses:' number 'here' (crlf) rest

/* This is the IP exclusion part... */
     if (count.Incr) then do
  
/* increment the number of accesses */

        number=number+1

/*  This is the updating of the file, if URL is found */

        rc=stream(count.fn, 'C', 'SEEK ='||(locate))
        rc=charout(count.fn, 'Accesses: ' number ' here'crlf || rest)
     end
  end

  else if (count.Incr) then do
/*  This is the updating of the file, if URL is not found 
    A new entry is created in the file */

     rc=stream(count.fn, 'C', 'SEEK +0')
     rc=lineout(count.fn,URL)
     rc=charout(count.fn, 'Accesses:  1  here'crlf || rest)
  end /* end of locate if */

  rc=stream(count.fn, 'C', 'CLOSE')
  number = strip(number)

return number


