/* Specify a content-negotiated procedure  */


make_cneg:

parse arg list,servername,verb,tempfile,,
          prog_file,reqnum,verbose,client_ip,privset,,
          uri,host_nickname,id_info,aiter,attribs

call sec_check
res1=result
if res1<>0 then return res1


parse var uri thisaddon '?' .

if list='' then do
   call showintro
   return rcode
end 

if strip(translate(list))='STEP1' then do
   call dostep1
   return rcode
end 

vars.=''
do until list=''
   parse var list a1 '&' list
   parse var a1 a1a '='a1b
   ee='!'||translate(strip(a1a))
   vv=sre_packur(translate(a1b,' ','+'))
   if ee='!REMOVE' | ee='!ADD' then
      vars.ee=vars.ee||' '||strip(vv)
   else
      vars.ee=strip(vv)
   if wordpos(ee,vars.0)=0 then vars.0=vars.0||' '||ee
end
vars.!mode=strip(translate(vars.!Mode))

if vars.!MODE='2' then do
   call dostep2
   return rcode
end 

if vars.!MODE='3' then do
   call dostep3
   return rcode
end 

if vars.!MODE='4' then do
   call dostep4
   return rcode
end 

if vars.!MODE='VU' then do
   call vu_vlist
   return rcode
end 

if vars.!MODE='VUCFG' then do
   call viewit   return rcode
end 


if vars.!MODE='ATTR_NOTES' then do
   call attr_notes
   return rcode
end 

if vars.!MODE='WILD_NOTES' then do
   call wild_notes
   return rcode
end 

return 'String no such makecneg option '




/******************/
/*  step 4 -- save the variant list */
dostep4:
if vars.!HOST='' | vars.!sel='' | vars.!realm=''  then do
 rcode='String Error, host, realm, or selector were not specified'
 return 1
end

call lineout tempfile,'<html><head><title>SREhttp/2: Specify a content-negotiated resource</title> </head><body>'
call lineout tempfile,'<font size=-1><a href="/sre2k/srehttp2/demos/configs.htm">Configurator</a> ||'
call lineout tempfile,'<a href="/sre2k/srehttp2/negotiat.htm">Long description</a> || '
call lineout tempfile,'<a target="NOTES" href="'||thisaddon||'?">Short description</a> || '
call lineout tempfile,'<a href="'||thisaddon||'?step1">Define another cn resource</a> '

call lineout tempfile,'</font>'
call lineout tempfile,'<h3 align="center">Specifying a content-negotiated resource</h3>'

call lineout tempfile,'<em>...for the variant list identified by the resource at:</em><ul>'

call lineout tempfile,'<li><b>Host-nickname:</b> '||vars.!host
call lineout tempfile,'<li><b>Selector:</b> '||vars.!sel||'<p>'

fsel=vars.!sel
fname=sreh2_auto_fig_file_name(vars.!sel,vars.!host,,idinfo)
iast=pos('*',fname)
if iast>0 then do
   islash=lastpos('\',fname,iast)
   if islash=0 then do
         call sre_pmprintf(" ERROR IN MAKECNEG ---- bad asterisk ")
         islash=1
   end
   tname=left(fname,islash)||'VntList.???'
   tname=sre_tempfile('VntList.???',,left(fname,islash))

   if tname='' then do          /* TOO many vntlist files! */
     call lineout tempfile,'</ul><p><table><tr><td bgcolor="yellow">ERROR!</td>'
     call lineout tempfile,'<td bgcolor="lightyellow"><dl><dt><em>Unable to generate name for this variant list  file: <tt>'fname'</tt>'
     call lineout tempfile,'<dd> You may have to remove some of the older 'tname' files from the server.'
     call lineout tempfile,'</dl>'
     call lineout tempfile,'<a href="javascript:history.go(-1)">Back</a>'
     call lineout tempfile,'</td></table>'
     signal gibs
   end

   fname=tname
   call lineout tempfile,'<li>A <b>variant-list file</b> will be created using a <em>randomly generated name</em> [<tt>'||fname||'</tt>]<p>'
   iast2=lastpos('*',vars.!sel)
   islash2=lastpos('/',vars.!sel,iast)
   if islash2=0 then
       fsel='/'
   else
       fsel=left(vars.!sel,islash2)
   fsel=fsel||filespec('n',tname)
end
else do
   call lineout tempfile,'<li>A <b>variant-list file</b> will be created using '||vars.!sel||' [<tt>'||fname||'</tt>]<p>'
end

/*backup fname */
if stream(fname,'c','query exists')<>'' then do
  tdir=strip(sre_value('H2_CFG_DIR',,'SRE'),,'\')
  tname=filespec('n',fname)
  parse var tname tname '.' .
  tname=tname||'.??'
  tname=sre_tempfile(tname,'?',strip(tdir,,'\')||'\OLD')
  docopy=doscopy(fname,tname,'R')
  if docopy<>0 then 
        call lineout tempfile,'<li><b>Caution:</b> unable to backup old variant file <br>"\'
  else
        call lineout tempfile,'<li><b>Note:</b> old variant file backed up to 'tname||'<br>'
end

vntlist.0=0
stuff=''
/* get old variant list, if it exists */
if vars.!OLD_LIST<>'' then do
 parse var vars.!OLD_LIST negsel ',' negselfile
 select 
   when negselfile<>'' then do
     stuff=sre_read_file(negselfile,2,5,1)
   end 
   when negsel<>'' then do
     tname=sreh2_auto_fig_file_name(negsel,vars.!host,,idinfo)
     stuff=sre_read_file(tname,2,5,1)
   end
   otherwise do
      nop
   end
 end
end

/* delete old version */
if stream(fname,'c','query exists')<>'' then do
  foo=sysfiledelete(fname)
  if foo<>0 then do
     call lineout tempfile,'</ul><p><table><tr><td bgcolor="yellow">ERROR!</td>'
     call lineout tempfile,'<td bgcolor="lightyellow"><dl><dt><em>Unable to delete old variant-list file: <tt>'fname'</tt>'
     call lineout tempfile,'<dd> You may have to reboot the server.'
     call lineout tempfile,'</dl>'
     call lineout tempfile,'<a href="javascript:history.go(-1)">Back</a>'
     call lineout tempfile,'</td></table>'
     signal gibs
  end 
end

/* write top of fname */
call lineout fname,'; variant list created '||date('n')||' '||time('n')
call lineout fname,' '
if pos('*',vars.!sel)>0 then do
     call lineout fname,'Pattern: '||vars.!sel
     call lineout fname,' '
end
else do
     call lineout fname,'URI: '||vars.!sel
     call lineout fname,' '
end

if stuff<>'' then do
  call write_stuff  /* write old variants */
end

/* now write new items */
/* text/html ; charset=iso-8859-1 ; qs=1 */
do jj=1 to words(vars.!add)
   auri=strip(word(vars.!add,jj))
   t1='!CTYPE_'||jj  ; atype=vars.t1
   t1='!CCHAR_'||jj  ; achar=vars.t1
   t1='!CQS_'||jj   ; aqs=vars.t1
   t1='!CLANG_'||jj   ; alang=vars.t1
   t1='!CENC_'||jj   ; aenc=vars.t1
   t1='!CLEN_'||jj   ; alen=vars.t1
   t1='!CDESC_'||jj   ; adesc=vars.t1

/* Actually, no attributes variant is the default 
   if atype='' & achar='' & aqs='' & alang='' & aenc='' & alen='' then iterate */

   call lineout fname,' '
   call lineout fname,'URI: '||auri

   v1=''
   if aqs<>'' then do
     if datatype(aqs)<>'NUM' then aqs=1
     aqs=min(1,max(0,aqs))
   end
   if aqs<>'' & achar<>'' & atype='' then atype='text/html'
   v1=atype
   if achar<>'' then v1=v1||' ; charset='||achar
   if aqs<>'' then v1=v1||' ; qs='||aqs
   if v1<>'' then call lineout fname,'content-type: '||v1

   if alang<>'' then do
      alang=translate(strip(space(alang,1)),',',' ')
      call lineout fname,'content-language: '||alang
   end 
   if aenc<>'' then do
      aenc=translate(strip(space(aenc,1)),',',' ')
      call lineout fname,'content-encoding: '||aenc
   end
   if alen<>'' then do
       if datatype(alen)='NUM' then call lineout fname,'Content-length: '||alen
   end
   if adesc<>'' then call lineout fname,'Description: '||strip(adesc)
end

call lineout fname 

if iast=0 then do
  call lineout tempfile,'<p><li>Variant-list file [<tt>'||fname||'</tt>] for '
  call lineout tempfile,'<a href="'||thisaddon||'?Mode=VU&sel='||vars.!SEL||'&host='||vars.!HOST'">'||vars.!sel||'</a>'
  call lineout tempfile,' has been succesfully created!'
end
else do
  call lineout tempfile,'<p><li>Variant-list file (for <tt>'||vars.!sel||'</tt>, using <tt>'||fsel||'</tt>)'
  call lineout tempfile,'<a href="'||thisaddon||'?Mode=VU&sel='||fSEL||'&host='||vars.!HOST'">'
  call lineout tempfile,' has been succesfully created</a>!'
end
call lineout tempfile,'</ul>'


/* now modify attribs.cfg */

/* =============== if here, got some changes, so save them */

/* get current attribute file */
anick=vars.!HOST

stuff=sreh2_cfg_backup('ATTRIB',anick)
if abbrev(stuff,1)=0 then do
   call lineout tempfile,'<p><B>Error</b>: failure to backup prior ATTRIBS.CFG file. This negotiated resource will <b>not</b> be recognized.'
   signal gibs
end
parse var stuff istat thfileuse hfileuse aaback ',' stuff

/* now modify the appropriate entry (use REALM) */
didit=0
nowrealm=''
dorealm=strip(translate(vars.!REALM))
if vars.!DONEWREALM1=1 & vars.!DONEWREALM2<>'' then dorealm=strip(vars.!DONEWREALM2)

do until stuff=''
   parse var stuff aline '0d0a'x stuff ; 
   aline=strip(aline)

   if  vars.!DONEWREALM1=1 then do    /* adding new entry */
      call lineout thfileuse,aline
      iterate
   end

   if aline='' | abbrev(strip(aline),';')=1 then do
      call lineout thfileuse,aline
      iterate
   end 
   parse var aline avar ':' aval
   avar=strip(translate(avar))
   if avar='REALM' then do
      nowrealm=strip(translate(aval))
      call lineout thfileuse,aline
      iterate
   end 
   if nowrealm<>dorealm then do
      call lineout thfileuse,aline
      iterate
   end

/* if here, in the appropriate realm definition 
    add the redirect: negotiate after the RULE entry */
   if avar='RULE' then do
     call lineout thfileuse,aline
     if didit=0 then  call lineout thfileuse,'Redirect: negotiate='||fsel
       didit=1
     iterate
   end
   if wordpos(avar,'REDIRECT INTERNAL ALIAS NOTIFY MOVE TEMP PERM LITERAL NEGOTIATE DIR VIRTUAL')>0 then iterate 
   call lineout thfileuse,aline    /* add any other entry */
end
if vars.!DONEWREALM1=1  then do  
   call lineout thfileuse,' '
   call lineout thfileuse,'Realm: '||dorealm
   call lineout thfileuse,'Desc: content-negotiation entry added on '||date('n')||' '||time('n')
   do jj=1 to words(vars.!sel)
       arule=strip(word(vars.!sel,jj))
       call lineout thfileuse,'Rule: '||vars.!sel
   end
   call lineout thfileuse,'Redirect: negotiate='||fsel
   call lineout thfileuse,' '
end 


call lineout thfileuse
foo=sreh2_cfg_backup(,thfileuse,hfileuse)
if abbrev(foo,0)=1 then do
   call lineout tempfile,'<p><B>Error</b>: problem writing new version of ATTRIBS.CFG file. This negotiated resource may <b>not</b> be recognized.'
   signal gibs
end

call sre_syssleep(0.05)  /* give chance to settle down */
afoo=sreh2_reset(idinfo,1)              


call lineout tempfile,'<ul><li>Realm <tt>'||dorealm||'</tt>, with a '
call lineout tempfile,'<tt>Redirect: negotiate='||fsel||'</tt>'
call lineout tempfile,'<a href="'||thisaddon||'?mode=VUCFG&host='||vars.!host||'">entry has been created</a></ul>'

gibs:
call lineout tempfile,'<body> </html>'
call lineout tempfile
rcode=sre_command('FILE ETAG_AUTO EXPIRES 30s NOCACHE NOIF ERASE TYPE text/html NAME 'tempfile,,idinfo)


return ''

/******************/
/* view a variant list */
vu_vlist:

tname=sreh2_auto_fig_file_name(vars.!sel,vars.!host,,idinfo)

rcode=sre_command('FILE ETAG_AUTO EXPIRES 30s NOCACHE NOIF TYPE text/plain NAME 'tname,,idinfo)
return rcode



/***********/
write_stuff:

lastout=0
darecord=''; dauri='02'x ; justuri=1

removed=''; retained=''
toremove=strip(translate(vars.!remove))

do forever
  parse var stuff aline '0d0a'x stuff
  aline=strip(aline)
  if abbrev(aline,';')=1 & darecord='' then do
       if abbrev(aline,'; variant list')=1 then do 
          iterate  /* skip old date stamp */
       end
       call lineout fname,aline
       lastout=0
       iterate
  end
  if aline=''  then do         /* perhaps end of record? */
     if darecord<>'' then do   /* write current record */
         if wordpos(dauri,toremove)>0 then do
             removed=removed||" "||dauri
             darecord='' ; dauri='02'x ; justuri=0
             if stuff='' then leave
             iterate        /* do not write this record */
         end
         if lastout<>''  then do
              call lineout fname,' '
              lastout=''
              iterate
         end
         if retained='' & justuri=1 then do
            darecord='' ; dauri='02'x ; justuri=0
            if stuff='' then leave
            iterate               /* don't write out "first, single line uri */
         end 
         else do
           retained=retained||' '||dauri
           call lineout fname,darecord
           call lineout fname,' '
           if stuff='' then leave
           lastout=''
         end
         darecord='' ; dauri='02'x ; justuri=0
         if stuff='' then leave
         iterate
     end 
     else do         /* ignore blank lines */ 
          if lastout<>'' then do 
              call lineout fname,' '
              lastout=''
          end 
          if stuff='' then leave
     end 
     iterate
  end 

/* begin new record, or add to current */
   if darecord='' then
      darecord=aline
   else
      darecord=darecord||'0d0a'x||aline
   parse var aline a1 ':' a2
   a1=strip(translate(a1))
   if a1='URI' then
         dauri=strip(translate(a2))
   else
        justuri=0

end                     /* END OF writing old variant list */
return 1


/******************/
/*  third option -- specify details for each variant */
dostep3:

call lineout tempfile,'<html><head><title>SREhttp/2: Specify a content-negotiated resource</title> </head><body>'
call lineout tempfile,'<font size=-1><a href="/sre2k/srehttp2/demos/configs.htm">Configurator</a> ||'
call lineout tempfile,'<a href="/sre2k/srehttp2/negotiat.htm">Long description</a> || '
call lineout tempfile,'<a target="NOTES" href="'||thisaddon||'?">Short description</a> '
call lineout tempfile,'</font>'
call lineout tempfile,'<h3 align="center">Specifying a content-negotiated resource</h3>'

call lineout tempfile,'<em>...for the variant list identified by the resource at:</em><ul>'
call lineout tempfile,'<li><b>Host-nickname:</b> '||vars.!host
call lineout tempfile,'<li><b>Selector:</b> '||vars.!sel||'<p>'

fname=sreh2_auto_fig_file_name(vars.!sel,vars.!host,,idinfo)

iast=pos('*',fname)
if iast>0 then do
   islash=lastpos('\',fname,iast)
   if islash=0 then do
         call sre_pmprintf(" ERROR IN MAKECNEG --- bad asterisk ")
         islash=1
   end
   call lineout tempfile,'<li><b>Variant-list to create:</b> <em>a randomly generated name will be used</em><p>'
end
else do
   call lineout tempfile,'<li><b>Variant-list to create:</b> '||vars.!sel||' [<tt>'||fname||'</tt>]<p>'
end

call lineout tempfile,'</ul>'

call lineout tempfile,''

call lineout tempfile,'<form name="goo2" action="'||thisaddon||'" method="POST">'

vntlist.0=0
/* get old variant list, if it exists */
if vars.!OLD_LIST<>'' then do
    parse var vars.!OLD_LIST negsel ',' negselfile
 select 
  when negselfile<>'' then do
     stuff=sre_read_file(negselfile,2,5,1)
  end 
  when negsel<>'' then do
    tname=sreh2_auto_fig_file_name(negsel,vars.!host,,idinfo)
    stuff=sre_read_file(tname,2,5,1)
  end
  otherwise do
    tname=sreh2_auto_fig_file_name(vars.!sel,vars.!host,,idinfo)
    stuff=sre_read_file(tname,2,5,1)
    if stuff<>'' then do
       negsel=vars.!sel
       old_list=negsel||','
    end
  end
 end
 call parse_variant_list(stuff)
 call lineout tempfile,'There are '||vntlist.0||' variants defined by an existing variant list '
 call lineout tempfile,'(<tt>'||negsel||'</tt>); '
 if vars.!REMOVE<>'' then
   call lineout tempfile,words(vars.!REMOVE)||' of these will be removed.'
 else
   call lineout tempfile,' all of which will be retained.'
end

if vars.!ADD<>'' then do
  if vntlist.0=0 then
     call lineout tempfile,'<p>Please specify the <a target="NOTES" href="'||thisaddon||'?mode=ATTR_NOTES">attributes</a>  of '||words(vars.!ADD)||' variants.'
  else
     call lineout tempfile,'<p>Please specify the <a target="NOTES" href="'||thisaddon||'?mode=ATTR_NOTES">attributes</a> of '||words(vars.!ADD)||' new variants.'
  call lineout tempfile,'<table border=1>'
  ismid=max(trunc(words(vars.!add)/2),1)
  do jj=1 to words(vars.!add)
     a1=strip(word(vars.!add,jj))
     call lineout tempfile,'<tr><td bgcolor="lightgrey"><tt> '||a1||'</tt></td>'
     call lineout tempfile,'<td><table>'
     call lineout tempfile,'<tr><td><tt>Type,<br> Charset &amp; Quality:</tt></td>'
     call lineout tempfile,'<td><input type="text" value="text/html" size=40 name="CTYPE_'||jj||'">'
     call lineout tempfile,'<br><tt>Charset:</tt> <input type="text" size=20 name="CCHAR_'||jj||'"> '
     call lineout tempfile,' <tt> &amp; quality:</tt><input type="text" size=5 value="1.0" name="CQS_'||jj||'"> </td>'

     call lineout tempfile,'<tr><td><tt>Language(s):</tt></td>'
     call lineout tempfile,'<td><input type="text" size=50 name="CLANG_'||jj||'"> </td>'

     call lineout tempfile,'<tr><td><tt>Encoding(s):</tt></td>'
     call lineout tempfile,'<td><input type="text" size=50 name="CENC_'||jj||'"> </td>'
       
     call lineout tempfile,'<tr><td><tt>Length:</tt></td>'
     call lineout tempfile,'<td><input type="text" size=50 name="CLEN_'||jj||'"> </td>'

     call lineout tempfile,'<tr><td><tt>Description:</tt></td>'
     call lineout tempfile,'<td><input type="text" size=50 name="CDESC_'||jj||'"> </td>'

     call lineout tempfile,'</table></td>'
     if jj=ismid then 
         call lineout tempfile,'<td><input  type="Submit" value="Create the variant list"></td>'

  end
end 

/*content-type (type/subtype, charset, qs)
, content-language
  content-encoding
  content-length
  description
*/
call lineout tempfile,'</table>'

darealm=vars.!realm

call lineout tempfile,'<input name="REALM" type="hidden" value="'||strip(darealm)||'">'
call lineout tempfile,'<input name="mode" type="hidden" value="4">'
call lineout tempfile,'<input name="sel" type="hidden" value="'||vars.!sel||'">'
call lineout tempfile,'<input name="host" type="hidden" value="'||vars.!host||'">'
if vars.!REMOVE<>"" then
  call lineout tempfile,'<input name="REMOVE" type="hidden" value="'||vars.!remove||'">'

  call lineout tempfile,'<input name="ADD" type="hidden" value="'||vars.!add||'">'

call lineout tempfile,'<input name="old_list" type="hidden" value="'||vars.!old_list||'">'

call lineout tempfile,'<input name="donewrealm1" type="hidden" value="'||vars.!donewrealm1||'">'
call lineout tempfile,'<input name="donewrealm2" type="hidden" value="'||vars.!donewrealm2||'">'

call lineout tempfile,'<input  type="Submit" value="Create the variant list">'

call lineout tempfile,'</form>'

call lineout tempfile,'<body> </html>'
call lineout tempfile

rcode=sre_command('FILE ETAG_AUTO EXPIRES 30s NOCACHE NOIF ERASE TYPE text/html NAME 'tempfile,,idinfo)

return rcode


/******************/
/* notes on attributes on wildcards */
wild_notes:
call lineout tempfile,'<html><head><title>SREhttp/2: Specify a content-negotiated resource -- notes on attributes</title> </head><body>'
call lineout tempfile,'<a name="catt">&nbsp;</a><h3>Notes on wildcarded selectors</h3>'

call lineout tempfile,'<b>Wildcarded</b> selectors (that contain <tt>*</tt> characters),'
call lineout tempfile,'when combined with <b>wildcarded</b> <em>definitions of variants</em>'
call lineout tempfile,'offer a convenient way of specifying many different sets of variants,'
call lineout tempfile,'where each set has the same attributes.'
call lineout tempfile,'<p>'

call lineout tempfile,'The basic idea is:'
call lineout tempfile,'<ol type="i">'
call lineout tempfile,'<li>When <em>identifying a negotiated resource</em>, include a <tt>*</tt> in the selector '
call lineout tempfile,'<br>&nbsp;&nbsp;&nbsp;<em>Example:</em> <tt>/book/c*.htm</tt>'
call lineout tempfile,'<li>When defining a variant''s <u>URI</u>, include a <tt>*</tt>'
call lineout tempfile,'<br>&nbsp;&nbsp;&nbsp;<em>Example:</em> <tt>en/c*.htm</tt>'
call lineout tempfile,'<li>If the <em>best</em> variant has a <tt>*</tt> in it''s <u>URI</u>, then'
call lineout tempfile,'<br><menu>'
call lineout tempfile,'<li>The portion of the client''s actual request, that matches the <tt>*</tt>'
call lineout tempfile,'in the selector used to <em>identify the negotiated resource</em>, is extracted'
call lineout tempfile,'<br>&nbsp;&nbsp;&nbsp;<em>Example:</em> if the client requests <tt>/book/chap8.htm</tt>, then <tt>hap8</tt> is extracted'
call lineout tempfile,'<li>This portion will replace the <tt>*</tt> in the <em>best</em> variant''s <U>URI</u>'
call lineout tempfile,'<br>&nbsp;&nbsp;&nbsp;<em>Example:</em> given an <tt>Accept-language: en</tt> request header, '
call lineout tempfile,' and  a <tt>language</tt> attribue equal to <tt>en</tt> '
call lineout tempfile,'<li>The result is used as a relative URI'
call lineout tempfile,'<br>&nbsp;&nbsp;&nbsp;<em>Example:</em> <tt>/book/en/chap8.htm</tt>'
call lineout tempfile,'<br>&nbsp;&nbsp;&nbsp;<em>Similarly</em> a later request for <tt>/docs/chap13</tt> would yield <tt>/book/en/chap13.htm</tt>'
call lineout tempfile,'</menu>'
call lineout tempfile,'</ol>'
call lineout tempfile,'<a href="/sre2k/srehttp2/negotiat.htm#wildcarded2">More details?</a>'
call lineout tempfile,'<body> </html>'
call lineout tempfile

rcode=sre_command('FILE ETAG_AUTO EXPIRES 30s NOCACHE NOIF ERASE TYPE text/html NAME 'tempfile,,idinfo)
return rcode


/******************/
/* notes on attributes of variants */
attr_notes:
call lineout tempfile,'<html><head><title>SREhttp/2: Specify a content-negotiated resource -- notes on attributes</title> </head><body>'
call lineout tempfile,'<a name="catt">&nbsp;</a><h3>Notes on attributes of variants</h3>'

call lineout tempfile,'The <em>attributes</em> of the variants are used'
call lineout tempfile,'in combination with preferences provided in the client''s request headers,'
call lineout tempfile,' to choose the <b>best</b> variant. For several attribute (such as <tt>type</tt> and <tt>language</tt>)'
call lineout tempfile,'the client can provide <em>quality</em> information that indicates strength of preference.'
call lineout tempfile,'<table border=1>'
call lineout tempfile,'<tr><th>Type, charset,<br> and quality</th>'
call lineout tempfile,'<td><ul><li><tt>Type</tt> refers to the mimetype of this variant.'
call lineout tempfile,'<br><em>Examples: </em> <tt>text/html</tt>, <tt>text/plain</tt>, <tt>image/gif</tt>, and <tt>image/jpeg</tt>'
call lineout tempfile,'<li><tt>Charset</tt> refers to the character encoding. If you leave this blank, the standard (ISO-8859-1) is assumed.'
call lineout tempfile,'<li><tt>quality</tt> is a 0.0 to 1.0 value that weights the quality of this variant, with higher'
call lineout tempfile,'values (1.0) signifying better variants. That is, all else held equal, the variant'
call lineout tempfile,'with the highest quality will be used. By default, a quality of 1.0 is used.</ul></td>'
call lineout tempfile,''
call lineout tempfile,''
call lineout tempfile,'<tr><th>Language</th>'
call lineout tempfile,'<td>One, or several, <a target="NOTES" href="http://www.loc.gov/standards/iso639-2/langcodes.html">2- character language codes</a>.<br>'
call lineout tempfile,'<em>You can specify several codes in a space delimited list.</em>'
call lineout tempfile,'<br><em>Examples: </em> <tt>en</tt>, <tt>sp</tt>, <tt>ru</tt>, and <tt>de</tt><br></td>'

call lineout tempfile,'<tr><th>Encoding</th>'
call lineout tempfile,'<td>One, or several, content-encodings.'
call lineout tempfile,'<em>You can specify several codes in a space delimited list.</em>'
call lineout tempfile,'<br><em>Examples: </em> <tt>identity</tt>, <tt>gzip</tt>, and <tt>compress</tt>.'
call lineout tempfile,'<br>Content-encodings are often used to save bandwidth and increase throughput, without changing the underlying contents.</td>'
call lineout tempfile,''
call lineout tempfile,''
call lineout tempfile,'<tr><th>Length</th>'
call lineout tempfile,'<td>An estimate of the size (in bytes) of the resource'
call lineout tempfile,'<br>All else held equal, smaller variants are better.'
call lineout tempfile,'By default, a value of <tt>0</tt> is used (always acceptable)'
call lineout tempfile,'</td>'

call lineout tempfile,'<tr><th>Description</th>'
call lineout tempfile,'<td>Strictly optional -- a description of this variant.</td>'

call lineout tempfile,'</table>'

call lineout tempfile,'<p>SREhttp/2 uses these attributes in a sequential fashion, eliminating variants until a single <em>best</em> variant remains.'
call lineout tempfile,'<ul><li>First, the <tt>Accept:</tt> request header is used, along with'
call lineout tempfile,'each variants <tt>type</tt> to see if there is a single most-preferred type'
call lineout tempfile,'<li>If not, the <tt>Accept-language:</tt> request header and the <tt>language</tt> are used.'
call lineout tempfile,'<li>If there still is no single best variant, <tt>encoding</tt>, <tt>charset</tt>, and then the <tt>length</tt> are used in a similar <eM>elimination</em> fashion'
call lineout tempfile,'<li>If there still is no single best variant, choose the first one  listed (of those remaining)'
call lineout tempfile,'<li>If <b>no</b> variants survived this elimination, use the default variant.'
call lineout tempfile,'<br><em>To specify a default variant</em>, leave all the attributes empty!'

call lineout tempfile,'</ul>'
call lineout tempfile,'If you do not specify a particular attribute for a given variant (say, you did not specify language)'
call lineout tempfile,'the variant may still be used even. Basically, in the steps listed above, a variant is assigned a '
call lineout tempfile,'very low rank (i.e.; 0.0001) if the attribute being checked is not specified. Variants that do specify this attribute,'
call lineout tempfile,'are either rated higher (i.e.; given a rating of 1.0), or are eliminated (given a rating of 0.0).'
call lineout tempfile,'<body> </html>'
call lineout tempfile

rcode=sre_command('FILE ETAG_AUTO EXPIRES 30s NOCACHE NOIF ERASE TYPE text/html NAME 'tempfile,,idinfo)

return rcode


/******************/
/*  second option -- see if variant list exists */
dostep2:

call lineout tempfile,'<html><head><title>SREhttp/2: Specify a content-negotiated resource</title> </head><body>'
call lineout tempfile,'<font size=-1><a href="/sre2k/srehttp2/demos/configs.htm">Configurator</a> ||'
call lineout tempfile,'<a href="/sre2k/srehttp2/negotiat.htm">Long description</a> || '
call lineout tempfile,'<a target="NOTES" href="'||thisaddon||'?">Short description</a> '
call lineout tempfile,'</font>'
call lineout tempfile,'<h3 align="center">Specifying a content-negotiated resource</h3>'

call lineout tempfile,'<em>...for the variant list identified  by the resource at:</em><ul>'
call lineout tempfile,'<li><b>Host-nickname:</b> '||vars.!host
call lineout tempfile,'<li><b>Selector:</b> '||vars.!sel

/* check for bad * in sel */
if pos('*',vars.!sel)>0 then do
   parse var vars.!sel . '*' t2
   if pos('/',t2)>0 then do
     call lineout tempfile,'</uL><table><tr><td bgcolor="yellow">ERROR!</td>'
     call lineout tempfile,'<td bgcolor="lightyellow"><dl><dt><em>A non-existent directory has been specified.</em>'
     call lineout tempfile,'<dd> The wildcarded selector (<tt>'||vars.!SEL||'</tt>) can not have a / after the wildcard. '
     call lineout tempfile,'</dl>'
     call lineout tempfile,'<a href="javascript:history.go(-1)">Please choose a different selector!</a>'
     call lineout tempfile,'</td></table>'
     signal eeks
   end
end

attribs=sreh2_get_attributes(vars.!host,vars.!sel,,idinfo)
parse var attribs ,
  darealm   '01'x   ,     
  darule    '01'x   ,     
  redirect '01'x  ,     
  options '01'x    ,    
  failure_file '01'x ,   
  permissions  '01'x ,  
  requires   

negsel='' ; negselfile='' ;redtype=''
if redirect<>'' then do
   parse var redirect redtype t2 ; redtype=strip(translate(redtype))
   if redtype='NEGOTIATE' then parse var t2 negsel negselfile
end 

call lineout tempfile,'<li>'
goober=translate(sreh2_get_realmlist(vars.!HOST,1))

athisone=words(goober)+1
do jj=1 to words(goober)
   a1=' NEGOTIATE_'||jj||':'
   if  pos(a1,goober)>0 then iterate
   athisone=jj
   leave
end 
tt='NEGOTIATE_'||athisone
ttlen=length(tt)+5

call lineout tempfile,'<form name="goo2" action="'||thisaddon||'" method="POST">'

if darealm='' then do            /* no matching rule */
  
/*  thisone=sreh2_current_second()
  thisone=translate(thisone,'_','.') */

  call lineout tempfile,'<input type="hidden" name="DONEWREALM1" value=1>'
  call lineout tempfile,'The resource is currently <b>not</b> a negotiated resource.'
  call lineout tempfile,'<br> To identify this as a content-negotiated resource, '
  call lineout tempfile,'a <a target="NOTES" href="/sre2k/srehttp2/attribs.htm#attribs">realm</a> will be added, using  '
  call lineout tempfile,'a realm name of '
  call lineout tempfile,'<input type="text" name="REALM" value="'||tt||'" size='||ttlen||'>.'
  call lineout tempfile,'<br>If you would rather, you can '
  call lineout tempfile,'<a target="cfgattr" href="/system/cfg_attr?">define a new realm</a> for this resource.'
  call lineout tempfile,'<input name="RULE" type="hidden" value="'||strip(vars.!SEL)||'">'
end
else do
  call lineout tempfile,'<input name="REALM" type="hidden" value="'||strip(darealm)||'">'
  call lineout tempfile,'<p>The resource has <em>selector specific attributes</em>'
  call lineout tempfile,'set under the <tt>'||darealm||'</tt> '
  call lineout tempfile,'<a target="NOTES" href="/sre2k/srehttp2/attribs.htm#attribs">realm</a>'
  call lineout tempfile,'(using the rule: <tt>'darule'</tt>) '
  call lineout tempfile,'<br>You can '
  call lineout tempfile,'<ul><li>Modify the <tt>'||darealm||'</tt> realm'
  if pos('*',darule)>0 then call lineout tempfile,'[<em><b>not</b> recommended</b></em>]' 
  call lineout tempfile,'<li><a target="cfgattr" href="/system/cfg_attr?">define &amp; modify a realm</a>  (allowing you to set lots of other options).'
  if pos('*',darule)>0 then do
    call lineout tempfile,'<li><input checked type="checkbox" name="donewrealm1" value=1 '
    grog="'"||tt||"'"
    call lineout tempfile,'onClick="'
    blank="''"
    call lineout tempfile,' if (this.form.donewrealm2.value == '||blank||')'
    call lineout tempfile,'   {this.form.donewrealm2.value='||grog||'}'
    call lineout tempfile,' else '
    call lineout tempfile,'   {this.form.donewrealm2.value='||blank||'}'
    call lineout tempfile,' ; return true; '
    call lineout tempfile,'">'
    call lineout tempfile,'Create a new realm -- '
    call lineout tempfile,'<input type="text" size='||ttlen
    call lineout tempfile,' name="donewrealm2" value="'||tt||'" > -- '
    call lineout tempfile,'just for this selector [<em><b>recommended!</b></em>]'
  end
  call lineout tempfile,'</ul>'
end


if redirect<>'' then do
  if  redtype<>'NEGOTIATE' then do
   call lineout tempfile,'<li>This resource is  currently <b>not</b> a <u>negotiated resource</u>.<br>'
   call lineout tempfile,'It does have <u>redirection</u> of:<tt>'||redirect||'</tt>'
 end
 else do
   call lineout tempfile,'<li>Currently, this is a <u>content-negotiated resource</u>.'
   if negsel<>'' then call lineout tempfile,'<br>&nbsp;&nbsp;which uses the variant-list<tt>: '||negsel||'</tt>'
   if negselfile<>'' then call lineout tempfile,'<br>&nbsp;&nbsp;which is explicitily associated with: <tt>'||negselfile||'</tt>'
 end
end 

/* can a variant list  file be created */


fname=sreh2_auto_fig_file_name(vars.!sel,vars.!host,,idinfo)

arf=strip(filespec('d',fname)||filespec('p',fname),'t','\')
if right(arf,1)=':' then arf=arf||'\'

arf2=dosisdir(arf)
if arf2=0 then do
   call lineout tempfile,'</uL><table><tr><td bgcolor="yellow">ERROR!</td>'
   call lineout tempfile,'<td bgcolor="lightyellow"><dl><dt><em>A non-existent directory has been specified.</em>'
   call lineout tempfile,'<dd> The specified selector (<tt>'||vars.!SEL||'</tt>) maps '
   call lineout tempfile,'to a  directory [<tt>'||arf||'</tt>] that does <b>not</b> exist!</dl>'
   call lineout tempfile,'<a href="javascript:history.go(-1)">Please choose a different selector!</a>'
   call lineout tempfile,'</td></table>'
   signal eeks
end 

iast=pos('*',fname) 
if iast>0 then do
   islash=lastpos('\',fname,iast)
   if islash=0 then do
         call sre_pmprintf(" ERROR IN MAKECNEG -- bad asterisk ")
         islash=1
   end
   call lineout tempfile,'<li>The <u>variant list</u> file will be: <tt> randomly generated</tt>'
   call lineout tempfile,'<em>(since you''re using a '
   call lineout tempfile,' <a target="NOTES" href="'||thisaddon||'?mode=WILD_NOTES">wildcarded selector</a>,'
   call lineout tempfile,' the actual selector can not be used)</em>'
end
else do
      call lineout tempfile,'<li>The <u>variant list</u> file will be: <tt>'||fname||'</tt>'
end
arf3=stream(fname,'c','query exists')
if arf3<>'' then do
      call lineout tempfile,'<br>(a file with that name currently exists, and will be renamed)'
end


call lineout tempfile,'</ul>'

/* get old variant list, if it exists */
stuff=''
select 
  when negselfile<>'' then do
     stuff=sre_read_file(negselfile,2,5,1)
  end 
  when negsel<>'' then do
    tname=sreh2_auto_fig_file_name(negsel,vars.!host,,idinfo)
    stuff=sre_read_file(tname,2,5,1)
  end
  otherwise do
    if redtype='NEGOTIATE' then do
      tname=sreh2_auto_fig_file_name(vars.!sel,vars.!host,,idinfo)
      stuff=sre_read_file(tname,2,5,1)
      if stuff<>'' then   negsel=vars.!sel
    end    
  end
end

/* now parse out old variant list. Results stored in Variants. */
call parse_variant_list(stuff)
if vntlist.0>0 then do
   call lineout tempfile,'<table ><tr><td><td bgcolor="lightgrey">'

   call lineout tempfile,'Currently defined variant list '
   call lineout tempfile,'<br>(as read from <tt>'||negsel||'</tt>)'   
   call lineout tempfile,'<br><em>check the box to <b>remove</b><br> a variant</em></td>'
  
   call lineout tempfile,'<td><table border=1>'
   do mm=1 to vntlist.0
      call lineout tempfile,'<tr><td>&nbsp;<input type="checkbox"  name="REMOVE" value="'||strip(vntlist.mm.!URI)||'">&nbsp;</td>'
      call lineout tempfile,'<td><tt>'||vntlist.mm.!URI||'</tt></td>'
   end
   call lineout tempfile,'</table>'
   call lineout tempfile,'</table>'
end 
if redtype='NEGOTIATE'  & vntlist.0=0 then do
   ttaa=negsel
   if ttaa='' then ttaa=vars.!sel
   call lineout tempfile,'<b>Note:</b> The currently defined variant list (<tt>'||ttaa||'</tt>)'
   call lineout tempfile,'was either empty or non-existent.'
end

/* note on wildcarded form */

call lineout tempfile,'<table><tr><td bgcolor="cyan" colspan=2>'
call lineout tempfile,'Add up to 10 variants.'
ii=lastpos('/',vars.!Sel)
if ii=0 then
   seldir='/'
else
   seldir=left(vars.!sel,ii)

call lineout tempfile,'Each variant is assumed to be relative to:<tt>'||seldir||'</tt>'
call lineout tempfile,'</td>'
call lineout tempfile,'<tr><td bgcolor="cyan" >&nbsp;</td> <td bgcolor="lightgrey">'

call lineout tempfile,'<ol>'
do mm=1 to 10
  call lineout tempfile,'<li><input type="text" size=50 name="ADD">'
end
call lineout tempfile,'</ol></td>'
call lineout tempfile,'<td><input  type="Submit" value="Specify attributes for these variants">'

call lineout tempfile,'</td></table>'


call lineout tempfile,'<input name="mode" type="hidden" value="3">'
call lineout tempfile,'<input name="sel" type="hidden" value="'||vars.!sel||'">'
call lineout tempfile,'<input name="host" type="hidden" value="'||vars.!host||'">'
if vntlist.0>0 then 
   call lineout tempfile,'<input type="hidden" name="old_list" value="'||negsel||','||negselfile||'">'

call lineout tempfile,'<input  type="Submit" value="Specify attributes for these variants">'



call lineout tempfile,'</form>'

call lineout tempfile,'<table><tr><th>Notes:</th><td><ul>'
call lineout tempfile,'<li>For each variant, enter a relative URI (it will be relative to <tt>'seldir'</tt>) pointing to a resource '
call lineout tempfile,'<li>These URIs must <b>not</b> contain embedded spaces  -- use URL encoding (%20) if  a space is needed'
call lineout tempfile,'<li> To add more variants, you can re-run this utility'
call lineout tempfile,' (after finishing the specification of these  new variants)'
if iast>0 then do
  call lineout tempfile,'<li>Hint: since you''ve specified a <a target="NOTES" href="'||thisaddon||'?mode=WILD_NOTES">wildcarded selector</a>, you '
  call lineout tempfile,'can use <tt>*</tt> in the variant''s URI -- if such a variant is chosen, the actual resource used'
  call lineout tempfile,'will depend on the precise value of  <em>what the client requests</em>.'
end
call lineout tempfile,'</ul></td></table>'

eeks:
call lineout tempfile,'<body> </html>'
call lineout tempfile
rcode=sre_command('FILE ETAG_AUTO EXPIRES 30s NOCACHE NOIF ERASE TYPE text/html NAME 'tempfile,,idinfo)

return rcode

/******************/
/* parse a variant list */
parse_variant_list:
parse arg astuff

vntlist.=''
vntlist.0=0
nuris=0

tmps.=''
goturi=0
do forever 
  parse var astuff aline '0d0a'x astuff
  aline=strip(aline)
  if abbrev(aline,';')=1 then iterate
  if aline='' then do           /* possibly end of record */
     if goturi=0 then do         /* no URI: specified, ignore */
       if astuff='' then leave
       tmps.=''
       iterate
     end
/* first URI, if no body, is ignored (it's informational) */
     if nuris=0 & tmps.!stuff='' then do
        tmps.=''
        goturi=0
        if astuff='' then leave
        iterate
     end
     nuris=nuris+1              /* nuris is "the next free slot */
     vntlist.nuris.!URI=tmps.!URI
     vntlist.nuris.!STUFF=tmps.!STUFF
     tmps.=''
     goturi=0
     vntlist.0=nuris
     if astuff='' then leave
  end 
  else do               /* not a blank or comment */
     parse var aline atype ':' aval ; atype=strip(translate(atype))
     if atype='URI' then  do
        goturi=1
        tmps.!URI=aval
     end
     else do
        if tmps.!STUFF='' then
          tmps.!STUFF=aline
        else
           tmps.!STUFF=tmps.!STUFF||'0d0a'x||aline
     end 
  end
end

return 1


/******************/
/*  first options */
dostep1:
call lineout tempfile,'<html><head><title>SREhttp/2: Specify a content-negotiated resource</title> </head><body>'
call lineout tempfile,'<font size=-1><a href="/sre2k/srehttp2/demos/configs.htm">Configurator</a> ||'
call lineout tempfile,'<a href="/sre2k/srehttp2/negotiat.htm">Long description</a> || '
call lineout tempfile,'<a target="NOTES" href="'||thisaddon||'?">Short description</a> '
call lineout tempfile,'</font>'
call lineout tempfile,'<h3 align="center">Specifying a content-negotiated resource</h3>'
goo=sre_hostinfo('!LIST_NICK')
nw=words(Goo)

call lineout tempfile,'Identify a <tt>variant list</tt>.'
call lineout tempfile,'Variant lists are identified by a <u>host-nickname</u> and a <u>selector.</u> '
call lineout tempfile,'<form  action="'||thisaddon||'" method="GET">'

call lineout tempfile,'<dl><dt>Note that you can include <a target="NOTES" href="/sre2k/srehttp2/negotiat.htm#wildcarded">* (wildcards) in the selector</a>'
call lineout tempfile,'<dd>'
call lineout tempfile,'<table bgcolor="lightgrey"><tr><td>Select a<br>Host-nickname</td>'
call lineout tempfile,'<td><select size='||min(5,nw+1)||' name="host">'
call lineout tempfile,'<Option selected value="DEFAULT">'||DEFAULT

do mm=1 to nw
   parse var goo agoo  goo
   agoo=strip(translate(agoo))

   call lineout tempfile,'<Option value="'||agoo||'">'||agoo
end
call lineout tempfile,'</select></td>'
call lineout tempfile,'<tr><td>Specify a <a target="NOTES" href="/sre2k/sre2003.htm#appendix7">selector</a>:</td>'
call lineout tempfile,'<td><input type="text" name="sel" size=50></td>'


call lineout tempfile,'<tr><td colspan=2>'

call lineout tempfile,'<input type="hidden" name="mode" value="2">'

call lineout tempfile,'<input type="submit" value="Identify a negotiated resource"></td>'

call lineout tempfile,'</table></dL>'
call lineout tempfile,'</form>'

call lineout tempfile,'<body> </html>'
call lineout tempfile
rcode=sre_command('FILE ETAG_AUTO EXPIRES 30s NOCACHE NOIF ERASE TYPE text/html NAME 'tempfile,,idinfo)
return rcode




/******************/
/* describe  */
showintro:
/* which host/selector to limit */
select_resource:
call lineout tempfile,'<html><head><title>SREhttp/2: Intro to specifying a content-negotiated resource</title> </head><body>'
call lineout tempfile,'<font size=-1><a href="/sre2k/srehttp2/demos/configs.htm">Configurator</a> ||'

call lineout tempfile,'<a href="/sre2k/srehttp2/negotiat.htm">Description</a> || '
call lineout tempfile,'<a href="'||thisaddon||'?step1">Specify</a> '
call lineout tempfile,'</font><br>'

call lineout tempfile,'<h3 align="center">Introduction to specifying a content-negotiated resource</h3>'

call lineout tempfile,'Content negotiation refers to the choosing of a best representation of a web resource from several alternatives.'
call lineout tempfile,'<b>Resource</b> means <em>content available from you web site</em>. Typically, this means'
call lineout tempfile,'files, possibly HTML files with server-side includes. <b>Best representation</b> means '
call lineout tempfile,'a version of this content that is best suited to the client, given what information you can'
call lineout tempfile,'glean about the client''s preferences and capabilities. Examples of this information include what language (say, English, German, etc.)'
call lineout tempfile,'he speaks, and what graphics type his browser prefers (say, GIF or JPEG).<p>'
call lineout tempfile,' Specifying a negotiable resource (a web resource with several possible variants) requires 3 steps:'
call lineout tempfile,'<ol>'
call lineout tempfile,'<li> Create several <tt>variants</tt> of a resource. For example, create several translations of a document, each saved in its own file.'
call lineout tempfile,'<li> Create a file, containing a <tt>variant list</tt>'
call lineout tempfile,'<li> Tell SREhttp/2 that this <tt>variant list</tt> should be used for content-negotiation'
call lineout tempfile,'</ol>'

call lineout tempfile,'<table border=1><Tr><th>Step 1</th><td> Step 1 is up to you (see below for some <a href="#hints1">hints</a>).</td>'
call lineout tempfile,'<tr><th>Step 2</th>'
call lineout tempfile,'<td>The major feature of this utility is guiding  the creation of <tt>variant lists</tt>.'
call lineout tempfile,'The <tt>variant list</tt>'
call lineout tempfile,'<menu><li> at the heart of SREhttp/2''s implementation of content negotiation. '
call lineout tempfile,'<li>is a simple (text) file containing several records; with each record' 
call lineout tempfile,'specifying where to find a <tt>variant</tt>, and when it should be used.'
call lineout tempfile,'<li> is accessed via a GET (or HEAD) request from a client.'
call lineout tempfile,'<tr><th>Step 3</th>'
call lineout tempfile,'<td>After you''ve specified the <tt>variant list</tt>, this utility will identify the <tt>variant list file</tt>; '
call lineout tempfile,'using a <a href="/sre2k/srehttp2/attribs.htm#appendix3_negotiation">Negotiate redirection</a> '
call lineout tempfile,'<em>selector specific attribute</em>.'
call lineout tempfile,'</table>'


call lineout tempfile,'<br>Are you ready to <a href="'||thisaddon||'?step1">specify a negotiated resource</a> <br>'
call lineout tempfile,'<hr>'

call lineout tempfile,'<a name="hints1">&nbsp;</a>'
call lineout tempfile,'<table><tr><th>Hint on <br>creating<br>variants of<br>a resource</th>'
call lineout tempfile,'<td>Basically, a variant is any server resource. This includes documents, images, and even cgi-bin scripts and SREhttp/2 addons. '
call lineout tempfile,'The notion is that variants all represent variations of the same information. '
call lineout tempfile,'For example, you may have several translations of the same document (say, an English, Finnish' 
call lineout tempfile,'and Korean version) which you would like to automatically send to the appropropriate clients.'
call lineout tempfile,'<p>Hence, there is nothing special about <tt>variants</tt> -- they are just like'
call lineout tempfile,'any other file (or addon) you might place on your web server. '
call lineout tempfile,'However, there are a few rules about where you place them that must be followed.'
call lineout tempfile,'<ul>'
call lineout tempfile,'<li>variants must be on the same server as the <tt>variant list</tt>'
call lineout tempfile,'<li><u>More precisely</u>, they must all be in, or under, the directory containing the <tt>variant list</tt>'
call lineout tempfile,'<br>For example ...<menu>'
call lineout tempfile,'<li><b>if</b> your <tt>variant</tt> list is created as <tt>/mydocs/chapter1.vlist</tt>'
call lineout tempfile,'<li><b>then</b> all your <tt>variants</tt> <b>must</b> by in or under <tt>/mydocs/</tt>'
call lineout tempfile,'</menu>'
call lineout tempfile,'<li> variants must be retrievable via GET requests. '
call lineout tempfile,'     That is, each variant should be accessible with a standard URL;'
call lineout tempfile,'    this means that content negotiation will not work with POST requests. '
call lineout tempfile,'</ul>'
call lineout tempfile,'Note that the actual directory corresponding to <tt>/mydocs/</tt> is subject'

call lineout tempfile,'to the usual SREhttp/2 <a href="/sre2k/sre2003.htm#cfgdatadir">default data directory</a> and '
call lineout tempfile,'<a href="/sre2k/srehttp2/attribs.htm#appendix3_virtual">virtual directory</a> rules. For example, if your default data directory'

call lineout tempfile,'is <tt>D:\WWW</tt>, and you have not defined any virtual directories, then <tt>/MYDOCS</tt>'
call lineout tempfile,'points to <tt>D:\WWW\MYDOCS</tt>'
call lineout tempfile,''
call lineout tempfile,''
call lineout tempfile,'</td></table>'

call lineout tempfile,'<body> </html>'
call lineout tempfile
rcode=sre_command('FILE ETAG_AUTO EXPIRES 30s NOCACHE NOIF ERASE TYPE text/html NAME 'tempfile,,idinfo)

return rcode



/******************/
/* access allowed? */
sec_check:
ss=sre_value('SECURITY_LEVEL',,'SRESYS')
if ss=0 then do
  foo=sre_command('String Sorry. Remote access to configuration utilities not permitted.',,idinfo)
  return foo
end

if ss=1 then do
    myaddr=sre_extract("clientaddr",idinfo)
    moreaddr=sre_value('SERVERADDR_INHOUSE',,'SRESYS')
    who=sre_extract("serveraddr",idinfo)||' '||moreaddr
    if wordpos(myaddr,who)=0 then do
      sfoo=sre_command('String External access to configuration utilities is not permitted' ,,idinfo)
      return sfoo
   end
end
/* else, normal superuser checking */
crlf='0d0a'x
parse upper var uri action '?' .
if wordpos('SUPERUSER',privset)=0 then do
  if aiter='' then return 'PRIVS_CHECK SUPERUSER , 'action' addon requires superuser privileges '
  return 'AUTH 'action'  addon requires that you have superuser privileges '
end 
return 0



/****************************/
/* display current attribute file */
viewit:

ahost=strip(translate(vars.!host))

cfgs=sre_value('H2_ATTRIB_FILES',,'SRELARGE')
hfileuse=''
do until cfgs=''
  parse var cfgs aset ',' cfgs           /* get a host-specific attributes file */
  if aset='' then iterate
  parse var aset hname . hfile hstamp  /* extract info about it */
  hname=strip(translate(hname))
  if hname<>ahost then iterate
  hfileuse=hfile
  leave
end

if hfileuse='' | hfileuse='.' then do
   rcode=sre_command('String No attribute file exists for host-nickname: 'ahost)
   return rcode
end 

stuff=sre_read_file(hfileuse,3,2)
if stuff='' then do
    rcode=sre_command('STRING Unable to read attribute file ('hfileuse')',,idinfo)
    return rcode
end
rcode=sre_command('var type text/plain nocache ',stuff,idinfo)
return rcode


