/*  TESTDYN.CMD: An SREhttp/2 addon.

   TESTDYN.CMD demonstrates the dynamic passwords facility of SREhttp/2.

   It will return a file, using the standard SREhttp/2 selector-to-file
   resolution rules, but only if the client has a proper "shared-secret".
   
   Usage:
      on the location line of your web browser, enter:
           http://yoursite.net/TESTDYN?a_selector
      where:
          yoursite.net : the domain name (or ip address) of your web site
          a_selector: the "selector" pointing to the resource you want to retrieve
          
      The server will ask you to provide a "shared-secret". When you enter
      your shared secret, a_selector will then be returned.  

      Note that if a_selector is an HTML file, server side includes will
      NOT be attempted.


   Requirement:
      Make sure that TESTDYN.RSP is in the SREHTTP2\PROCS directory

   Specifying shared-secrets:
      To define shared secrets for individual users, you need to create entries
      in the USERS.CFG file. These should contain "secret-privileges".
      For example:
          JOE pwd_joe   ?TESTDYN:a_secret_priv
      where "a_secret_priv" should be JOE's "shared-secret" for the TESTDYN addon.

      After providing a standard username and password, the client will then
      be asked for the secret privilege.  In the above example, JOE should
      use "a_secret_priv" (without the " quotes).

      Note that SREhttp/2 "dynamic password" facility uses cookies. Thus,
      should the client ask for the same resource later in his session
      (or for a resource that requires the same secret privlege), he will
      not have to re-enter his secret privilege. Conversely, if cookies are
      disabled, then he will not be granted access (even if he has an appropriate
      secret privilege).



*/

test_dynamic_pwd:
parse arg list,servername,verb,tempfile,,
          prog_file,reqnum,verbose,who,privset,,
          uri,host_nickname,id_info,aiter


/* ACCESS_OK use SREH2_DYNAMIC_PWD to check that client has a proper "shared-secret" */

call access_ok           

ares=result

if ares<>'' then return ares        /* access was denied */

/* list should contain the selector to return. If empty, use /
   In general, TESTDYN should be used with files that are otherwise
   unavailable (say, that have SUPERUSER required privileges).
*/

if list='' then do
   list='/'
end 
else do
    list='/'||strip(list,'l','/')
end 


/* lookup file name, possibly using virtual directory information */
nname=sreh2_fig_file_name(host_nickname,,list,,1,'HTML',1)

/* could not resolve */
if nname='' then do
  foo=sre_command('String Unable to resolve selector: 'list,,id_info)
  return foo
end

/* does such a file actually exists? */
fname=sreh2_queryfile(,nname)
if fname='' then do
  foo=sre_command('STring Requested file does not exist for: 'list,,id_info)
  return foo
end

/* got it --- let SREhttp/2 return the file */

return 'FILE name 'fname                /* let srehttp/2 further process it */

   

/*************************************/
/* check for the appropriate secret privilege */
access_ok:

/* SREhttp/2 did not provide privileges? 
  Perhaps they weren't needed. If so, tell SREhttp/2 to look'em up.
  If you already did that, then ask client to provide username/password 
*/

if privset='' then do
    if aiter=''  then do     /* Is this AFTER a 'PRIVS' elucidated  re-call of this addon */
          return 'PRIVS You need to provide a Usename with an appropriate secret privilege for this resource'
     end

/* if here, got username, but has no privs */
      rcode=sre_auth_response('Get Secret Privilege',servername,, ,
                 'You need to provide a Username with an appropriate secret privilege for this resource', ,
                  id_info)
      return rcode

end 

/* Divide client privilegs into normal and secret privileges.
   The secret privileges are used as "shared secrets".
   More precisely, if there is  shared secret of the form:
          ?appname:a_secret
   and
           appname matches the appname argument in the call to SREH2_DYNAMIC_PWD
   then
           a_secret is the "shared secret" granted to this client for this addon
*/
 
parse var privset privsetn ',' privsets



/* SREH2_DYNAMIC_PWD will either return '', which means "success".
   Otherwise, SREH2_DYNAMIC_PWD will use the response file to ask for
   a new shared-secret, and returns the response-code.
*/


authh=sre_reqfield('Authorization')
username=sre_extract_username(authh)
aa=sreh2_dynamic_pwd('TESTDYN',,privsets,,'testdyn.rsp',,list,id_info,,,username)

/* parse  arg appname,newlocation,privset2,duration,respfile,who,aamessage,id_info,this_flag,servername,username */
/* aa=sreh2_dynamic_pwd('TESTDYN',,privsets,,'testdyn.rsp',,list,) */

return aa





