/* Installation script for WFT.                    */
/* Author:      Peter Moylan, peter@pmoylan.org    */
/* Last edited: 5 Dec 2007                         */

CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs

srcdir = directory()
OurDrive = TRANSLATE(LEFT(srcdir, 1))
SAY 'Installation of Web Family Tree'
SAY 'Directory where the program should be installed?'
SAY '  (Leave this blank to use the current directory)'
PARSE PULL wftdir
wftdir = TRANSLATE(wftdir, '\', '/')
wftdir = STRIP(wftdir, 'Trailing', '\')
IF wftdir = '' THEN wftdir = srcdir

SAY 'Installing to 'wftdir
IF wftdir \= srcdir THEN DO
    CALL MakeDirectory wftdir
    'copy wft.exe' wftdir
    'copy sampleheader' wftdir
    'copy samplefooter' wftdir
    'copy GedSort.exe' wftdir
    'copy Lint.exe' wftdir
    'copy Subset.exe' wftdir
    'copy Tidy.exe' wftdir
    'copy FixGen.exe' wftdir
    'copy Fixup.cmd' wftdir
    'copy Ged2HTML.exe' wftdir
    'copy wft.inf' wftdir
    'copy changes.doc' wftdir
    'copy wft.*.lng' wftdir
END
datadir = wftdir||'\data'
IF SysMkDir(datadir) = 0 THEN
    SAY 'Created directory 'datadir

SAY ''
SAY 'For this next step, you need to specify the directory that your'
SAY 'web server uses for holding CGI scripts.  It usually has a name'
SAY 'that ends with \cgi-bin.  If that directory does not yet exist,'
SAY 'type CTRL/C and the <Enter> key now, and re-run this installation'
SAY 'script after setting up the web server.'

SAY ''
SAY 'Directory where the CGI scripts live?'
PARSE PULL cgidir
DO WHILE cgidir = ''
    SAY 'You must specify a directory name.'
    PARSE PULL cgidir
END
cgidir = TRANSLATE(cgidir, '\', '/')
cgidir = STRIP(cgidir, 'Trailing', '\')
CALL MakeDirectory cgidir

/* Create the CGI script. */

CALL MakeCommandFile wftdir, cgidir, OurDrive

/* Create the 'remove' script. */

outfile = wftdir||'\Remove.cmd'
IF stream(outfile, 'C', 'query exists') \= '' THEN
    '@del 'outfile
CALL stream outfile, 'C', 'open write'

CALL LineOut outfile, '/* Run this script to uninstall WFT */'
CALL LineOut outfile, ''
CALL LineOut outfile, '"del '||cgidir||'\wft.cmd"'
CALL LineOut outfile, 'ourdir = directory()'
CALL LineOut outfile, 'CALL directory "'wftdir||'"'
CALL LineOut outfile, '"del wft.exe"'
CALL LineOut outfile, '"del wft.inf"'
CALL LineOut outfile, '"del changes.doc"'
CALL LineOut outfile, '"del wft.*.lng"'
CALL LineOut outfile, '"del sampleheader"'
CALL LineOut outfile, '"del samplefooter"'
CALL LineOut outfile, '"del gedsort.exe"'
CALL LineOut outfile, '"del lint.exe"'
CALL LineOut outfile, '"del subset.exe"'
CALL LineOut outfile, '"del tidy.exe"'
CALL LineOut outfile, '"del fixgen.exe"'
CALL LineOut outfile, '"del fixup.cmd"'
CALL LineOut outfile, '"del ged2html.exe"'
CALL LineOut outfile, '"del README"'
CALL LineOut outfile, '"del links.doc"'
CALL LineOut outfile, '"del Remove.cmd"'
CALL LineOut outfile, 'CALL directory ourdir'
CALL stream outfile, 'C', 'close'

SAY ''
SAY 'A script Remove.cmd has been created in the installation directory,'
SAY 'and you can run this to uninstall WFT.  Note, however, that it will'
SAY 'not delete your data directory, since that probably contains files'
SAY 'you want to keep.'

EXIT

/************************************************************************/
/* Creating the command file that has to go in the cgi-bin directory.   */
/************************************************************************/

MakeCommandFile: PROCEDURE
    parse arg wftdir, cgidir, OurDrive

    outfile = cgidir||'\wft.cmd'
    IF stream(outfile, 'C', 'query exists') \= '' THEN
        '@del 'outfile
    CALL stream outfile, 'C', 'open write'

    /* Separate out the drive letters from wftdir and cgidir. */

    IF SUBSTR(wftdir, 2, 1) = ":" THEN
        DO
            wftdrive = TRANSLATE(LEFT(wftdir, 1))
            wftdir = RIGHT(wftdir, LENGTH(wftdir)-2)
        END
    ELSE wftdrive = OurDrive

    IF SUBSTR(cgidir, 2, 1) = ":" THEN cgidrive = TRANSLATE(LEFT(cgidir, 1))
    ELSE cgidrive = OurDrive

    /* For the most part, the following code just copies a fixed        */
    /* script.  The variable part, where we have to be very careful     */
    /* about where we put our quotation marks, is where we have to      */
    /* change directory from the cgi-bin directory to the directory     */
    /* containing wft.exe.  An extra complication is that the script    */
    /* we need is slightly different depending on whether those two     */
    /* directories are on the same drive.                               */

    SQ = "'"          /* These two variables make the */
    DQ = '"'          /* code more readable, I hope   */

    CALL LINEOUT outfile, "/* Redirection to the web.exe script in the Web Family Tree     */"
    CALL LINEOUT outfile, "/* directory.  We redirect so that the cgi-bin directory does   */"
    CALL LINEOUT outfile, "/* not become clogged with scripts and data for too many        */"
    CALL LINEOUT outfile, "/* unrelated applications.                                      */"
    CALL LINEOUT outfile, "/*     Author: Peter Moylan, peter@pmoylan.org                  */"
    CALL LINEOUT outfile, ""
    CALL LINEOUT outfile, "wftdir = "DQ||wftdir||DQ
    CALL LINEOUT outfile, ""
    IF wftdrive <> cgidrive THEN
        CALL LINEOUT outfile, "INTERPRET "DQ||SQ||"@"wftdrive||":"SQ||DQ
    CALL LINEOUT outfile, "INTERPRET "DQ||SQ"@cd "SQ"wftdir"SQ" >nul"||SQ||DQ
    CALL LINEOUT outfile, "INTERPRET "DQ||SQ"@WFT.EXE"SQ||DQ
    CALL LINEOUT outfile, "EXIT"

    CALL stream outfile, 'C', 'close'
    RETURN

/************************************************************************/
/* Procedure to make a new directory. This is more complicated than it  */
/* seems because we might have to use recursion to make parent dirs.    */
/************************************************************************/

MakeDirectory: PROCEDURE
    PARSE ARG newdir
    newdir = TRANSLATE(newdir, '\', '/')
    code = SysMkDir(newdir)
    IF code = 0 THEN
        SAY 'Created directory 'newdir
    ELSE IF code = 3 THEN
        DO
            pos = LASTPOS('\', newdir)
            IF pos > 4 THEN DO
                code = MakeDirectory(LEFT(newdir, pos-1))
                IF code = 0 THEN code = MakeDirectory(newdir)
            END
        END
    ELSE IF code = 5 THEN
        DO
            /*SAY 'Directory 'newdir' exists'*/
            code = 0
        END
    IF code <> 0 THEN SAY 'Could not create directory 'newdir', error code 'code
    RETURN code

/************************************************************************/

