/* GRADD.c - Video Frame Buffer to Write-Combining for P6K7MTRR.sys, ver.0.08b
     Copyright 1999-2001 Takayuki 'January June' Suwa

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#pragma strings(readonly)
#define INCL_BASE
#define INCL_PM
#define INCL_ERRORS
#include <os2.h>
#include <gradd.h>
#include "SMPUTIL.h"
#include "VFBWC.h"

/* queries main memory page count (GRADD) */
BOOL QueryVFBAPagesGRADD(PULONG pulPageBase,
                         PULONG pulPageCount)
{
    BOOL bResult = (BOOL)FALSE;
    PSZ pszEnvVar;
    HMODULE hmodVMAN;
    ULONG (* EXPENTRY pfnVMIEntry)(GID,
                                   ULONG,
                                   PVOID,
                                   PVOID);
    VMIQCI xQueryChainInfo;
    if(DosScanEnv((PSZ)"GRADD_CHAINS",
                  &pszEnvVar) == NO_ERROR &&
       IsPMActive() != (BOOL)FALSE &&
       DosLoadModule((PSZ)NULL,
                     (ULONG)0,
                     (PSZ)"VMAN",
                     &hmodVMAN) == NO_ERROR)
    {
        (VOID)DosQueryProcAddr(hmodVMAN,
                               (ULONG)0,
                               (PSZ)"VMIEntry",
                               (PFN*)&pfnVMIEntry);
        if(pfnVMIEntry((GID)0,
                       VMI_CMD_QUERYCHAININFO,
                       (PVOID)NULL,
                       (PVOID)&xQueryChainInfo) == RC_SUCCESS &&
           xQueryChainInfo.pciHead != (PCHAININFO)NULL &&
           xQueryChainInfo.pciHead->pGraddList != (PGRADDINFO)NULL &&
           xQueryChainInfo.pciHead->pGraddList->cModes != (ULONG)0)
        {
            *pulPageBase = (ULONG)xQueryChainInfo.pciHead->pGraddList->pModeInfo[0].pbVRAMPhys >> 12;
            *pulPageCount = ((xQueryChainInfo.pciHead->pGraddList->pModeInfo[0].ulTotalVRAMSize < xQueryChainInfo.pciHead->pGraddList->pModeInfo[0].ulApertureSize ? xQueryChainInfo.pciHead->pGraddList->pModeInfo[0].ulTotalVRAMSize
                                                                                                                                                                   : xQueryChainInfo.pciHead->pGraddList->pModeInfo[0].ulApertureSize) + (ULONG)4095) >> 12;
            bResult = (BOOL)TRUE;
        }
        (VOID)DosFreeModule(hmodVMAN);
    }
    return bResult;
}

