{$I+}
program cscinfo;

uses
  CardServ,
  Manf_ID,
  Strings,
  VpUtils;

const
  wichtige_tupel:array [1..2{+2}{+3}] of byte=(CISTPL_FUNCID,CISTPL_VERS_1
     { PCCard:,CISTPL_CONFIG,CISTPL_CFTABLE_ENTRY}
     { CardBus: ,CISTPL_CONFIG_CB,CISTPL_CFTABLE_ENTRY_CB,CISTPL_BAR});

type
  p_word                =^smallword;

var
  GetCardServicesInfo   :TGetCardServicesInfo;
  RegisterClient        :TRegisterClient;
  GetConfigurationInfo  :TGetConfigurationInfo;
  GetTuple              :TGetTuple;
  GetTupleData          :TGetTupleData;
  DeregisterClient      :TDeregisterClient;
  clienthandle          :smallword;
  i,l                   :word;
  rc                    :longint;
  ti                    :byte;
  socket_pos            :word;
  ww,ii                 :word;
  found_manufacturer    :boolean;
  basesocketnumber      :word;
  vendorstring          :array[0..1024] of char;

function copypchar(p:PChar;l,i:word):string;
  var
    res:string;
  begin
    res:='';
    repeat
      if l=0 then break;
      case p^ of
        #$00:
          begin
            Dec(i);
            if i=0 then
              begin
                copypchar:=res;
                Exit;
              end;
            res:='';
          end;

        #$01..#$1f,#$ff:
          res:=res+'('+Int2Hex(Ord(p^),2)+')';
      else
        res:=res+p^;
      end;

      Inc(p);
      Dec(l);
    until (l<=0);

    if i=1 then
      copypchar:=res
    else
      copypchar:='';
  end;

function voltage(vn:string;v:byte):string;
  begin
    voltage:=vn+'='+Int2Str(v div 10)+'.'+Int2Str(v mod 10)+' V'
  end;

procedure tupel_anzeigen(const t:byte);
  begin

    with GetTuple do
      begin
        FillChar(GetTuple,SizeOf(GetTuple),0);
        IOCtlHeader.Handle:=clienthandle;
        wGTAttributes:=1;
        wGTSocket:=socket_pos;
        bGTDesiredTuple:=t;
        rc:=CS_GetFirstTuple(GetTuple);
      end;

    while rc=0 do
      begin

        with GetTupleData do
          begin
            FillChar(GetTupleData,SizeOf(GetTupleData),0);
            IOCtlHeader.Handle:=clienthandle;
            wGTDSocket:=socket_pos;
            wGTDAttributes:=GetTuple.wGTAttributes;
            bGTDDesiredTuple:=t;
            wGTDFlags:=0;// not include type and link byte //GetTuple.wGTFlags;
            dGTDLinkOffset:=GetTuple.dGTLinkOffset;
            dGTDCISOffset:=GetTuple.dGTCISOffset;
            wGTDTupleDataMax  :=SizeOf(bGTDTupleData);
            rc:=CS_GetTupleData(GetTupleData);
            if (rc<>0) or (wGTDTupleDataLen<=0) then
              Break; // while rc=0 do

            case t of
              CISTPL_VERS_1:
                begin
                  WriteLn('  Manufacturer : "',copypchar(@bGTDTupleData[2],wGTDTupleDataLen-2,1),'"');
                  WriteLn('  Device       : "',copypchar(@bGTDTupleData[2],wGTDTupleDataLen-2,2),'"');
                  for i:=3 to 4 do
                    WriteLn('                 "',copypchar(@bGTDTupleData[2],wGTDTupleDataLen-2,i),'"');
                end;

              CISTPL_FUNCID:
                begin
                  Write  ('  Card type    : ',Int2Hex(bGTDTupleData[1] {and $0f},2),' ');
                  case (bGTDTupleData[1] and $0f) of // mft.exe
                    0:WriteLn('Input/Output');
                    1:WriteLn('Masked ROM');
                    2:WriteLn('One-time programmable ROM');
                    3:WriteLn('UV EPROM');
                    4:WriteLn('EEPROM');
                    5:WriteLn('Flash EPROM');
                    6:WriteLn('Static RAM');
                    7:WriteLn('Dynamic RAM');
                   13:WriteLn('Function Specific');
                   14:WriteLn('Extended');
                  else
                      WriteLn('Reserved');
                  end;

                  Write  ('  Function     : ',Int2Hex(bGTDTupleData[0],2),' ');
                  l:=2;
                  case bGTDTupleData[0] of // pccardstandard.tt
                    0:Write('Multi-Function');
                    1:Write('Memory');
                    2:Write('Serial Port');
                    3:Write('Parallel Port');
                    4:Write('Fixed Disk');
                    5:Write('Video Adapter');
                    6:Write('Network Adapter');
                    7:Write('Auto Incrementing Mass Storage');
                    8:Write('SCSI');
                    9:Write('Security');
                    $a..$fd:Write('Reserved'{<',Int2Hex(bGTDTupleData[0],2),'>'});
                    $fe:Write('Vendor-Specific');
                    $ff:Write('Do Not Use');
                  end;
                  WriteLn;
                  if l<=wGTDTupleDataLen-1 then
                    begin
                      Write('                 ');
                      for i:=l to wGTDTupleDataLen-1 do
                        Write(' ',Int2Hex(bGTDTupleData[i],2));
                      WriteLn;
                    end;
                end;


            else
              Write('  Tuple ',Int2Hex(t,2),'     : ');
              for i:=0 to wGTDTupleDataLen-1 do
                Write(Int2Hex(bGTDTupleData[i],2),' ');
              WriteLn;
              Write('                 ');
              for i:=0 to wGTDTupleDataLen-1 do
                if bGTDTupleData[i]<$20 then
                  Write('.')
                else
                  Write(Chr(bGTDTupleData[i]));
              WriteLn;
            end;

          end;

        {with GetTuple do
          begin
            IOCtlHeader.Handle:=clienthandle;
            rc:=CS_GetNextTuple(GetTuple);
          end;}
        rc:=-1;

      end; // getfirsttuple successful

  end; (* tupel_anzeigen *)


begin
  rc:=CS_Open;
  if rc<>0 then
    begin
      WriteLn('Can not open PCMCIA.SYS.');
      Halt(rc);
    end;


  with GetCardServicesInfo do
    begin
      FillChar(GetCardServicesInfo,SizeOf(GetCardServicesInfo),0);
      rc:=CS_GetCardServicesInfo(GetCardServicesInfo);
      if rc<>0 then
        begin
          WriteLn('Can not get Card Service Informations (',cs_errortext(rc),')');
          Halt(99);
        end;

      WriteLn('Card Service Level is ',Int2Hex(wCSCSLevel shr 8,1),'.',Int2Hex(Lo(wCSCSLevel),2));
      StrLCopy(vendorstring,PChar(@sCSVendorString),Min(SizeOf(vendorstring)-1,wCSVStrLen));
      if Abs(StrLen(vendorstring)-wCSVStrLen)>5 then
        WriteLn('Error: no vendor string (garbage)')
      else
        begin
          if StrPos(vendorstring,#13#10'All Right')<>nil then
            StrPos(vendorstring,#13#10'All Right')^:=^@;
          WriteLn('"',vendorstring,'"');
        end;

      if wCSCSLevel=$0200 then
        basesocketnumber:=1
      else
        basesocketnumber:=0;

    end;

  with RegisterClient do
    begin
      FillChar(RegisterClient,SizeOf(RegisterClient),0);
      wRCAttributes:=ATR_IOCDD;
      wRCVersion:=$500; // $200/$210/$500/$800
      CS_RegisterClient(RegisterClient);
      clienthandle:=IOCtlHeader.Handle;
    end;

  for socket_pos:=basesocketnumber+0 to basesocketnumber+GetCardServicesInfo.wCSCount-1 do
    begin
      Write('Socket ',socket_pos:2,' : ');
      with GetConfigurationInfo do
        begin
          FillChar(GetConfigurationInfo,SizeOf(GetConfigurationInfo),0);
          IOCtlHeader.Handle:=clienthandle;
          Socket:=socket_pos;
          rc:=CS_GetConfigurationInfo(GetConfigurationInfo);
          if rc<>0 then
            begin
              Write('unknown. (',cs_errortext(rc),')');
              if rc=error_Invalid_Parameter then
                Write(' - maybe slot is empty');
              WriteLn;
              Continue;
            end;

{
          if (Attribute and $0004)=0 then
            Write('PCCard')
          else
            Write('CardBus');}

          if (IntType and $0004)=0 then
            case IntType and 3 of
              0:Write('PCCard??');
              1:Write('PCCard(memory)');
              2:Write('PCCard(memory+I/O)');
              3:Write('PCCard(invalid type)');
            end
          else
            Write('CardBus');

          if (IntType and 8)=8 then
            Write(', zoomed video');


          Write(', ',voltage('Vcc',Vcc),', ',voltage('Vpp1',Vpp1),', ',voltage('Vpp2',Vpp2));
          WriteLn;

          Write('  ManuCode     : ',Int2Hex(ManuCode,4));

          found_manufacturer:=false;
          for ii:=Low(known_jedecid) to High(known_jedecid) do
            if known_jedecid[ii].num=ManuCode then
              begin
                Write(' (',known_jedecid[ii].str,')');
                found_manufacturer:=true;
                Break;
              end;

          if (not found_manufacturer) and (ManuCode<>0) and (ManuCode<>$ffff) then
            Write(' (unknown; please contact author..)');

          WriteLn;

          Write  ('  ManuInfo     : ',Int2Hex(ManuInfo,4));
          if ManuCode=0 then
            for ii:=Low(known_jedecid) to High(known_jedecid) do
              if known_jedecid[ii].num=ManuInfo then
                begin
                  Write(' (',known_jedecid[ii].str,')');
                  Break;
                end;
          WriteLn;

          Write  ('  AssignedIRQ  : ');
          if AssignedIRQ=$ff then Write('None')
          else Write(AssignedIRQ);
          WriteLn;

        //WriteLn('  IOAddrLines  : ',IOAddrLines);

          if GetCardServicesInfo.wCSCSLevel>=$800 then
            if (ManuCode=0) and (ManuInfo=0) and (FuncCode=0) then
              WriteLn('  ** The card could be a CardBus Card. **');

        end;

      if (ParamStr(1)='/A') or (ParamStr(1)='/a') then
        begin
          for ti:=0 to $fe do
            tupel_anzeigen(ti);
        end
      else
        begin
          for ti:=Low(wichtige_tupel) to High(wichtige_tupel) do
            tupel_anzeigen(wichtige_tupel[ti]);
        end;

    end; // socket_pos

  with DeregisterClient do
    begin
      FillChar(DeregisterClient,SizeOf(DeregisterClient),0);
      IOCtlHeader.Handle:=clienthandle;
      CS_DeregisterClient(DeregisterClient);
    end;

  CS_Close;
end.

