#ifdef DEBUG
#define STATIC
#else
#define STATIC  static
#endif

#define VIDEO_IMAGE_DEFAULT           (DI_FOURCC_Y422)
#define VIDEO_BPP_DEFAULT             (DI_BITSPERPEL_16)
#define VIDEO_OVERLAY_DEFAULT         (TRUE)
#define COLOUR_KEY_DEFAULT            (0xDL)
#define VIDEO_FPS_TYPE_FPS            (0)
#define VIDEO_FPS_TYPE_MICRO          (1)
#define VIDEO_FPS_RATE_DEFAULT        (15)
#define VIDEO_FPS_TYPE_DEFAULT        (VIDEO_FPS_TYPE_FPS)
#define VGA_NUMCOLOURS_DEFAULT        (256)

#ifndef INCL_32
#define ULONG   unsigned long
#define LONG    long
#define UINT    unsigned short
#define USHORT  unsigned short
#define SHORT   short
#define BOOL    unsigned short
#define UCHAR   unsigned char
#define BYTE    unsigned char
#define CHAR    char
#define VOID    void
typedef VOID    *PVOID;
typedef USHORT  (*PF)();
#define FAR     far
#endif
#define DIM(a)  (sizeof(a)/sizeof(a[0]))
#define MAX(x,y) (((x)>(y))?(x):(y))
#define MIN(x,y) (((x)<(y))?(x):(y))

#ifndef TRUE
#define TRUE    (1)
#define FALSE   (0)
#endif

// extern USHORT Io;

/* IOCTL Commands */
#define  VCAI_CAT            (0x8C)
#define  VCAI_INIINFO          0x60
#define  VCAI_SAVE             0x61
#define  VCAI_RESTORE          0x62
                                  /* KLL New Image Restore Functions - Start */
#define  VCAI_LOAD_MICROCODE   0x63
#define  VCAI_RESTORE_FORMAT   0x64
#define  VCAI_CAPTURE_FORMAT   0x65
#define  VCAI_RESTORE_IMAGE    0x66
#define  VCAI_PLAY             0x67
                                  /* KLL New Image Restore Functions - End   */
                                  /* KLL New Tuner Functions - Start         */
#define  VCAI_QUERYVIDEOSIGNAL 0x68
#define  VCAI_TUNERCHANNEL     0x69
                                  /* KLL New Tuner Functions - End           */
#define  VCAI_VIDEOINPUT       0x6A
#define  VCAI_SETCAPTRECT      0x6B
#define  VCAI_GETIMAGESCALE    0x6C
#define  VCAI_GETDEVINFO       0x6D
#define  VCAI_VALIDRECT        0x6E
#define  VCAI_UNFREEZE         0x72
#define  VCAI_FREEZE           0x74
#define  VCAI_VIDEOADJ         0x75
#define  VCAI_SETFPS           0x76
#define  VCAI_USER             0x79
#define  VCAI_AUDIODEV         0x79
#define  VCAI_SCREENINFO       0x7C
#define  VCAI_SETMONITOR       0x80
#define  VCAI_EDCOLORKEY       0x81
#define  VCAI_SETCOLORKEY      0x82
#define  VCAI_SETCHROMAKEY     0x83
#define  VCAI_TTSTATUS         0x92
#define  VCAI_TTSETPAGE        0x93
#define  VCAI_TTQUERYPAGE      0x94
#define  VCAI_TTGETPAGE        0x95
#define VCAERR_SUCCESS            0
#define VCAERR_INVALID_BUFFER     1
#define VCAERR_INVALID_RECT       2
#define VCAERR_INVALID_PARM       3
#define VCAERR_UNSUPPORTED_CMD    4
#define VCAERR_HW_ERROR           5
                                          /* KLL New Tuner Functions - Start */
#define VCAERR_CHANNEL_TOO_LOW       6
#define VCAERR_CHANNEL_TOO_HIGH      7
#define VCAERR_CHANNEL_SKIP          8
#define VCAERR_CHANNEL_NO_TUNER      9
#define VCAERR_SIGNAL_LOCKED        10
#define VCAERR_SIGNAL_NOT_LOCKED    11
#define VCAERR_SIGNAL_INDETERMINATE 12

// Video format types
#define CF_PAL          0
#define CF_NTSC         1
#define CF_YC           8
#define CF_COMPOSITE    9
#define CF_COMPRESS    10
#define CF_EXPAND      11
#define CF_INPUT0      12
#define CF_INPUT1      13
#define CF_INPUT2      14

// these are the video formats supported by the celebrity boards
#define CF_PAL_BGHI     0
#define CF_NTSC_M       1
#define CF_SECAM        2
#define CF_PAL_M        3
#define CF_PAL_N        4
#define CF_NTSC_443     5
#define CF_EXTERNAL_SRC 6

// these formats are supported by the prism board
#define CF_PAL_443      7
#define CF_MONO         8

typedef struct VIDSETTINGS
{
  USHORT vid_brightness;
  USHORT vid_hue;
  USHORT vid_saturation;
  USHORT vid_contrast;
} VIDSETTINGS, FAR *PVIDSETTINGS;

/* Used to contain initialiser strings for vxp500/bt812 chips */
typedef struct REGPAIR {
   USHORT rp_register;
   USHORT rp_value;
} REGPAIR, FAR *PREGPAIR;

typedef struct TUNER
{
    ULONG tune_if_freq;
    ULONG tune_low_band;
    ULONG tune_mid_band;
    USHORT tune_band_low;
    USHORT tune_band_mid;
    USHORT tune_band_high;
} TUNER, FAR * PTUNER;

#define TT_SYNC             (0x80)
#define TT_VERSION          (0x1C)
#define TT_CHIP_ID_MASK     (0x60)
#define TT_CHIP_ID_5246     (0x00)
#define TT_CHIP_ID_5248     (0x20)
#define TT_CHIP_ID_5280     (0x40)
#define TT_CHIP_ID_5281     (0x60)
#define TT_TELETEXT_QUALITY (0x02)
#define TT_VIDEO_QUALITY    (0x01)
#define TT_ACQUISITION_CIRCUITS (4)

typedef struct TTSTATUS        // Teletext status result
{
    ULONG  tt_length;
    USHORT tt_no_acquisition_circuits;
    USHORT tt_flags;
} TTSTATUS, FAR *PTTSTATUS;

typedef struct TTSETPAGE      // Specify Teletext page to acquire
{
    USHORT  tt_page_no;
    USHORT  tt_acquisition_circuit;
} TTSETPAGE, FAR *PTTSETPAGE;

typedef struct TTQUERYPAGE    // Query if Teletext page present
{
    USHORT  tt_page_no;
    USHORT  tt_result;
} TTQUERYPAGE, FAR *PTTQUERYPAGE;


#define TT_PAGE_NOT_PRESENT (0x00)      // return status results
#define TT_PAGE_PRESENT     (0x01)
#define TT_GOOD_PAGE        (0x02)
#define TT_BAD_PAGE_NO      (0x04)

                                        // Input flag settings
#define TT_ACQUIRE_SYNC     (0x02)      // call return
#define TT_ACQUIRE_ASYNC    (0x04)      // return & use semaphore
#define TT_TIMEOUT          (0x80)      // Timeout on long acquires SYNC/ASYNC

typedef struct TTGETPAGE      // Get page of teletext
{
    USHORT tt_page_no;
    USHORT tt_page_start;       // where in page to start acquiring from
    USHORT tt_page_length;      // number of bytes to acquire
    ULONG  tt_timeout;
    USHORT tt_flags;
    // HSEM   tt_sem;
} TTGETPAGE, FAR *PTTGETPAGE;

                                  // Specify the chip to use
#define HW_CHIP_ID_VXP500   (0x01)
#define HW_CHIP_ID_DIG      (0x02)
#define HW_CHIP_ID_BT848    (0x03)
                                  // Is it a read or a write
#define HW_READ             (0x01)
#define HW_WRITE            (0x02)
#define HW_READ_GPIO        (0x03)      // GPIO reads under Bt848 chip
#define HW_WRITE_GPIO       (0x04)      // GPIO writes under Bt848 chip

typedef struct HWINFO
{
    USHORT hw_chip;
    USHORT hw_flags;
    USHORT hw_register;
    USHORT hw_value;
} HWINFO, FAR * PHWINFO;


typedef struct I2CIO
{
    USHORT i2c_id;
    USHORT i2c_length_out;
    UCHAR  FAR *i2c_out_data;
    USHORT i2c_length_in;
    UCHAR  FAR *i2c_in_data;
    USHORT i2c_result;
} I2CIO, FAR * PI2CIO;

typedef struct ADV_FEATURES
{
    ULONG   af_red_low;
    ULONG   af_red_high;
    ULONG   af_green_low;
    ULONG   af_green_high;
    ULONG   af_blue_low;
    ULONG   af_blue_high;
    ULONG   af_crop_left;
    ULONG   af_crop_top;
    ULONG   af_crop_right;
    ULONG   af_crop_bottom;
    ULONG   af_scale_h;
    ULONG   af_scale_v;
    ULONG   af_chroma_key_flag;
    ULONG   af_colour_key_flag;
    ULONG   af_colour_key;
    ULONG   af_no_colours;
    ULONG   af_input_format;
    ULONG   af_interlace_flag;
    ULONG   af_v_interpolation;
    ULONG   af_uniform_flag;
    ULONG   af_hfilter;
    ULONG   af_q_factor;
    ULONG   af_q_auto;
    ULONG   af_interleave;
    ULONG   af_tuner_region;
    ULONG   af_tuner_frequency;
} AF, FAR * PAF;

/* Common Cature Rectangle Define */
typedef struct CRECT {     /* CR */
   ULONG X_Left;
   ULONG Y_Top;
   ULONG Y_Height;
   ULONG X_Width;
} CRECT;

/* XLATOFF */
#pragma pack(1)
/* XLATON */

/* IOCTL category 140 code 6Ah - Set Video Input Source Connector     */
/*                             & Query Current Input Source Connector */
typedef struct VCASETVIDEOINPUT{      /* VI */
   ULONG  INPUT_CONNECTOR;  /* -1 NO_Change Returns Current Setting */
} VCASETVIDEOINPUT;
typedef VCASETVIDEOINPUT FAR * PVCASETVIDEOINPUT;


/* IOCTL category 140 code 6Bh - Set Source and Destination Capture Rectangles */
typedef struct VCASETCAPTURERECT{      /* CR */
   ULONG  Source_X_Left;
   ULONG  Source_Y_Top;
   ULONG  Source_Y_Height;
   ULONG  Source_X_Width;
   ULONG  Dest_X_Left;
   ULONG  Dest_Y_Top;
   ULONG  Dest_Y_Height;
   ULONG  Dest_X_Width;
} VCASETCAPTURERECT;
typedef VCASETCAPTURERECT FAR * PVCASETCAPTURERECT;

/* IOCTL category 140 code 6Ch - Get Image and Scale Into RAM Buffer */
typedef struct VCAGETIMAGESCALE{      /* GIS */
   ULONG  Capture_Buf_Len;
   ULONG  Capture_Buf_Ptr;
   ULONG  Source_X_Left;
   ULONG  Source_Y_Top;
   ULONG  Source_Y_Height;
   ULONG  Source_X_Width;
   ULONG  Dest_X_Left;
   ULONG  Dest_Y_Top;
   ULONG  Dest_Y_Height;
   ULONG  Dest_X_Width;
} VCAGETIMAGESCALE;
typedef VCAGETIMAGESCALE FAR * PVCAGETIMAGESCALE;

/* IOCTL category 140 code 6Dh - Get Devinfo */
typedef struct _vcadevinfo {     /* DI */
   ULONG  Length;
   CHAR   ProdInfo[30];
   CHAR   ManInfo[30];
   CHAR   Version[10];
   ULONG  ImgFormat;        /* Image Format Supported by the card            */
   USHORT BitsPerPEL;       /* Bit Per PEL in this image format              */
   USHORT Overlay;          /* Device has overlay support                    */
   ULONG  Brightness;       /* Default Video Attributes for the card         */
   ULONG  hue;
   ULONG  saturation;
   ULONG  contrast;
   ULONG  Sharpness;
   ULONG  unused1;
   ULONG  S_X_Left;         /* Default Source Coordinates                    */
   ULONG  S_Y_Top;
   ULONG  S_Y_Height;
   ULONG  S_X_Width;
   ULONG  D_X_Left;         /* Default Destination Coordinates               */
   ULONG  D_Y_Top;
   ULONG  D_Y_Height;
   ULONG  D_X_Width;
   ULONG  D_ScaleFactor;    /* Default Scale Factor on copy                  */
   ULONG  S_X_MAX;          /* Maximum X size for the digitized Source       */
   ULONG  S_Y_MAX;          /* Maximun Y size for the digitized Source       */
   ULONG  D_X_MAX;          /* Maximun X size for the Destination            */
   ULONG  D_Y_MAX;          /* Maximun Y size for the Destination            */
   ULONG  O_X_MAX;          /* Maximun X size for the Overlay Destination    */
   ULONG  O_Y_MAX;          /* Maximun Y size for the Overlay Destination    */
   USHORT VideoInputs;      /* Number of Software Switchable video Inputs    */
   USHORT CanRestore;
   USHORT CanStretch;
   USHORT CanDistort;
   USHORT HasVolume;        /* Has Volume  Control                           */
   USHORT HasBalance;       /* Has Balance Control                           */
   USHORT CanScale;         /* Can Scale Down on GetImage                    */
   USHORT CanStream;        /* Can do streaming of Images to Stream Handler  */
   ULONG  ulFileNum;        /* System File Number used in Streaming          */
   //////////// New Items after 1.0 release below //////////////////////////
   BYTE   HasTuner;         /* Card Has a Channel Tuner                      */
   BYTE   HasTeleTex;       /* Card Has a TeleTex support                    */
   LONG   Delay_Time;       /* MS delay between connector change/query signal*/
   BYTE   HasAFC;           /* Automatic Frequency Control/FineTune          */
   BYTE   HasPolarizer;     /* Automatic Frequency Control/FineTune          */
   //////////// New Items after 1.1 release below //////////////////////////
// USHORT VideoOutputs;     /* Opposite of Videoinputs */
} VCADEVINFO;

typedef VCADEVINFO FAR * PVCADEVINFO;

/* XLATOFF */
#pragma pack()
/* XLATON */

#define DI_FOURCC_Y422               0x32323459L //( 'Y422' in RAM = 224Y long)
#define DI_BITSPERPEL_16             16 /* 16 Bits Per PEL                          */
#define DI_NotSupported              -1 /* Not Supported                            */
#define DI_Supported                  1 /* Supported                                */

/* IOCTL category 140 code 6Eh - Set Streaming Capture Image Size */
typedef struct VCACAPISIZE {     /* CS */
   ULONG X_Left;
   ULONG Y_Top;
   ULONG Y_Height;
   ULONG X_Width;
   ULONG ScaleFactor;
} VCACAPISIZE;
typedef VCACAPISIZE FAR * PVCACAPISIZE;

/* IOCTL category 140 code 6Fh - Get Image Into RAM Buffer */
typedef struct VCAGETIMAGE{      /* GI */
   ULONG  Capture_Buf_Len;
   ULONG  Capture_Buf_Ptr;
} VCAGETIMAGE;
typedef VCAGETIMAGE FAR * PVCAGETIMAGE;


/* IOCTL category 140 code 70h - get buffer addressing */
typedef struct VCABUFFER{        /* BA */
   ULONG buf_addr;   /* 32 bit linear address                                 */
   ULONG buf_len;    /* buffer length in bytes                                */
   ULONG buf_banks;  /* number of banks (1 if full aperature)                 */
} VCABUFFER;
typedef VCABUFFER FAR * PVCABUFFER;

/* IOCTL category 140 code 71h - set current VRAM bank number */
typedef struct VCASELECTBANK{    /* SB */
   ULONG bank_num;   /* number of bank to select (0-39)                       */
} VCASELECTBANK;
typedef VCASELECTBANK FAR * PVCASELECTBANK;

/* IOCTL category 140 code 75h - set/query video adjustments  */
typedef struct VCASETVIDEO{      /* SV */
   ULONG set_brightness;   /* 1=min, 255=max, 128=norm, -1=no change, -2=reset default   */
   ULONG set_hue;          /* 1=min, 255=max, 128=neutral, -1=no change, -2=reset default*/
   ULONG set_saturation;   /* 1=min, 255=max, 128=norm, -1=no change, -2=reset default   */
   ULONG set_contrast;     /* 1=min, 255=max, 128=norm, -1=no change, -2=reset default   */
   ULONG ret_brightness;   /* 1=min, 255=max */
   ULONG ret_hue;          /* 1=min, 255=max */
   ULONG ret_saturation;   /* 1=min, 255=max */
   ULONG ret_contrast;     /* 1=min, 255=max */
} VCASETVIDEO;
typedef VCASETVIDEO FAR * PVCASETVIDEO;

#define NO_CHANGE (0xFFFFFFFFL)
#define DEFAULT   (0xFFFFFFFEL)

/* IOCTL category 140 code 76h - set Frame Rate for Streaming */
typedef struct VCASETFPS{        /* SF */
   ULONG set_FPS;          /* Frames to Second to stream to the Stream Handler   */
   ULONG ulFlags;          /* Frames or MicroSeconds */
} VCASETFPS;
typedef VCASETFPS FAR * PVCASETFPS;
/* Defines for ulFlags */
#define  VCASF_FRAMES       0x0
#define  VCASF_MICROSECONDS 0x1

/* IOCTL cat 140 code 7Ch - New func that supplies info about the display */

typedef struct VCASCREENINFO{      /* SCRINFO */
   ULONG  ulLength;          /* Length of this structure               */
   ULONG  ul_RESV01;         /* Reserved and set to zero               */
   ULONG  ulWidth;           /* Width of the Screen                    */
   ULONG  ulHeight;          /* Height of the Screen                   */
   ULONG  ulNumColours;      /* Number of Color in Screen's Palette    */
   ULONG  ulHFreq;           /* Horizontal Screen Frequency            */
   ULONG  ulVFreq;           /* Vertical   Screen Frequency            */
   ULONG  ulRGB[256];        /* Pallete Info if ulNumColors < 256      */
} VCASCREENINFO, FAR *PVCASCREENINFO;

/* IOCTL category 140 code 60h - Init Info from .INI file  Generic Format  */
typedef struct VCAINITG {      /* INI */
   ULONG ulBrightness;   /* 1=min, 255=max                    */
   ULONG ulHue;          /* 1=min, 255=max  or Tint           */
   ULONG ulSaturation;   /* 1=min, 255=max  or Color          */
   ULONG ulContrast;     /* 1=min, 255=max                    */
   BYTE  bD_Info[512];   /* Device Specific Info              */
} VCAINITG;
typedef VCAINITG FAR * PVCAINITG;

/* IOCTL category 140 code 60h - Init Info from .INI file     */
typedef struct VCAINIT {      /* IN */
   ULONG ulBrightness;   /* 1=min, 255=max                    */
   ULONG ulHue;          /* 1=min, 255=max  or Tint           */
   ULONG ulSaturation;   /* 1=min, 255=max  or Color          */
   ULONG ulContrast;     /* 1=min, 255=max                    */
   BYTE  bControl ;      /* see ulControl Defines             */
   BYTE  bCapPos  ;      /* see ulCappos  Defines             */
} VCAINIT;
typedef VCAINIT FAR * PVCAINIT;


                               /* KLL New Image Restore Functions - Start */
/**************************************************************************/
/* IOCTL category 140 code 63h - Query/Load/Unload MicroCode              */
typedef struct VCALOAD {     /* LOAD */
   ULONG  ulflags;           /* 1=Query,2=Load,3=Unload                   */
   CHAR   ProdInfo[256];     /* Path and Name of MicroCode Load           */
   ULONG  ulLoadID;          /* Load ID (returend on a load)              */
   ULONG  ulLength;          /* Lenght of load data                       */
   PVOID  pLoadData;         /* Pointer to MicroCode Load Data            */
} VCALOAD;
typedef VCALOAD FAR * PVCALOAD;

/*  ulFlags for VCALOAD                                                */
#define  VCALOAD_QUERY          0x01
#define  VCALOAD_LOAD           0x02
#define  VCALOAD_UNLOAD         0x03

/**************************************************************************/
/* IOCTL category 140 code 64h  - Query/Set Image Restore Format           */
typedef struct VCAIMAGERF {      /* IRF */
   ULONG ulFlags;        /* 0 = Query, 1 = Set                            */
   ULONG ulNumFormats;   /* Number of supported format(s)                 */
   ULONG ulCurIndex;     /* Current or Format to set to                   */
   ULONG FourCC[64];     /* Name for Format                               */
} VCAIMAGERF;
typedef VCAIMAGERF FAR * PVCAIMAGERF;

/*  ulFlags for VCAIMAGERF (Image Restore Format)                         */
#define  VCAIRF_Query           0x00
#define  VCAIRF_Set             0x01

/**************************************************************************/
/* IOCTL category 140 code 65h - Query/Set Image Capture Format           */
typedef struct VCAIMAGECF {      /* ICF */
   ULONG ulFlags;        /* 0 = Query, 1 = Set                            */
   ULONG ulNumFormats;   /* Number of supported format(s)                 */
   ULONG ulCurIndex;     /* Current or Format to set to                   */
   ULONG FourCC[64];     /* Name for Format                               */
} VCAIMAGECF;
typedef VCAIMAGECF FAR * PVCAIMAGECF;

/*  ulFlags for VCAIMAGECF (Image Capture Format)                         */
#define  VCAICF_Query           0x00
#define  VCAICF_Set             0x01


/**************************************************************************/
/* IOCTL category 140 code 66h - Restore Image data to the device         */
typedef struct VCAIMAGER {      /* IR */
   ULONG ulLength;       /* Lenght of Image Data                          */
   PVOID pImageData;     /* Pointer to Image Data                         */
} VCAIMAGER;
typedef VCAIMAGER FAR * PVCAIMAGER;

/**************************************************************************/
/* IOCTL category 140 code 67h - Restore Image data to the device         */
typedef struct VCASTREAM {      /* STRM */
   ULONG ulLength;       /* Lenght of Image Data                          */
   PVOID pImageData;     /* Pointer to Image Data                         */
   ULONG ulFlags;        /* Flag info                                     */
} VCASTREAM;
typedef VCASTREAM FAR * PVCASTREAM;

/* ulFlag    Defines  for VCASTREAM */
#define  VCA_PLAY_START         0x01
#define  VCA_PLAY_DATA          0x02
#define  VCA_PLAY_STOP          0x04

/*********************** ********************** ****************************/
/*********************** Overlay Card Functions ****************************/
/*********************** ********************** ****************************/

/* IOCTL category 140 code 80h - Enable/Disable Monitor       */
typedef struct VCASETMONITOR {   /* EDM */
   BOOL  bMonitor;               /* 1=TRUE=ON, 0=FALSE=OFF    */
} VCASETMONITOR;
typedef VCASETMONITOR FAR * PVCASETMONITOR;

/* IOCTL category 140 code 81h - Enable/Disable Transparrent Color  */
typedef struct VCAEDCOLORKEY {   /* EDCK */
   BOOL  bColorKeying;           /* 1=TRUE=ON, 0=FALSE=OFF          */
} VCAEDCOLORKEY;
typedef VCAEDCOLORKEY FAR * PVCAEDCOLORKEY;

/* IOCTL category 140 code 82h - Set Color Key / Transparrent Color */
typedef struct VCASETCOLORKEY {   /* SCK */
   ULONG  ulColorKey;             /* Transparrent Color             */
                                  // VCA_QUERY_CURRENT
                                  // VCA_SET_DEFAULT
} VCASETCOLORKEY;
typedef VCASETCOLORKEY FAR * PVCASETCOLORKEY;

/* IOCTL category 140 code 83h - Enable/Disable Chroma Key */
typedef struct VCASETCHROMAKEY {
   BOOL  bChromaKeying;           /* 1=TRUE=ON, 0=FALSE=OFF          */
} VCASETCHROMAKEY, FAR *PVCASETCHROMAKEY;


/* IOCTL category 140 code 83h - Set Destination Clip List */
typedef struct VCASETCLIPLIST
{
    ULONG   ulLength;
    ULONG   ulFlags;        // reserved and set to zero
    ULONG   ulNum_Rects;
    CRECT   VisRect[256];   // Array of n visible Rectangles
} VCASETCLIPLIST, FAR *PVCASETCLIPLIST;


                                          /* KLL New Tuner Functions - Start */
/* IOCTL category 140 code 68h - Query Video Input Connector's Signal */
/* no structure it just Returns a status */
    /* VCAERR_SIGNAL_LOCKED        10    */
    /* VCAERR_SIGNAL_NOT_LOCKED    11    */
    /* VCAERR_SIGNAL_INDETERMINATE 12    */

/* IOCTL category 140 code 69h - Set/Query Tuner Channel     */
typedef struct VCATUNCHAN {      /* TUC */
   ULONG  ulFlags;        /* 1=Set, 2=Query                      */
   ULONG  ulOptions;      /* Options                             */
   USHORT usRegion;       /* Region of the word tuner is used in */
   USHORT usChannel;      /* Channel Number                      */
   LONG   lFineTune;      /* Fine Tune value for Channel         */
   ULONG  ulFrequency;    /* Frequency instead of Channel/region */
} VCATUNCHAN;
typedef VCATUNCHAN FAR * PVCATUNCHAN;

/* Values for ulFlags on Set/Query Channel */
#define TUC_SET_CHANNEL   1
#define TUC_QUERY_CHANNEL 2

/* Values for ulOptions on Set/Query Channel */
/* Bit sensitive field                       */
#define TUC_AFC_ON             4
#define TUC_AFC_OFF            0
#define TUC_FREQUENCY          8
#define TUC_CHANNEL            0
#define TUC_POLARIZATION_VERT 16
#define TUC_POLARIZATION_HORI  0

/* values for ulRegion use on Set/Query Channel */
/*   Tuner Type M  */
#define USA             0
#define US_CATV         1
/*   Tuner Type BG */
#define CCIR            2       /* Western Europe       */
#define CCIR_CATV       3       /* Western Europe       */
/*   Tuner Type I  */
#define AUSTRALIA       4       /* Australia            */

#define JAPAN           5       /* Japan                */
#define JAPAN_CATV      6       /* Japan                */

/* Specific Status Returned by Set/Query Channel */
    /* VCAERR_CHANNEL_TOO_LOW       6    */
    /* VCAERR_CHANNEL_TOO_HIGH      7    */
    /* VCAERR_CHANNEL_SKIP          8    */
    /* VCAERR_CHANNEL_NO_TUNER      9    */

                                          /* KLL New Tuner Functions - End   */
                                       /* KLL Volume Functions - Start */

                                       // Modified by TS to comply to
                                       // naming convention standard
/* IOCTL category 140 code 79h - General purpose VCAI_USER   */
/*                               a General Device Specific command     */
typedef struct VCAUSER{      /* Generic general purpose */
   ULONG  user_length;       /* Length of this structure               */
   ULONG  user_function;     /* Function                               */
} VCAUSER, FAR *PVCAUSER;;

                                       // Modified by TS to comply to
                                       // naming convention standard
/* IOCTL category 140 code 79h - Set/Query  Audio Functions, this is   */
/*                               a General Device Specific command     */
typedef struct VCADEVAUDIO{      /* DEVAUD */
   ULONG  aud_length;        /* Length of this structure               */
   ULONG  aud_function;      /* Audio Input Channel                    */
   ULONG  aud_flags;         /* Flags                                  */
   ULONG  aud_reserved;      /* Reserved and set to zero               */
   ULONG  aud_lvolume;       /* Left  Volume                           */
   ULONG  aud_rvolume;       /* Right   "                              */
   ULONG  aud_lbass;         /* Left  Bass                             */
   ULONG  aud_rbass;         /* Right   "                              */
   ULONG  aud_ltreble;       /* Left  Treble                           */
   ULONG  aud_rtreble;       /* Right   "                              */
} VCADEVAUDIO;

typedef VCADEVAUDIO FAR * PVCADEVAUDIO;

/* Defines for function on VCADEVAUDIO IOCTL */
//                           A U D 1
#define VCADEV_AUDIO_FUNC 0x41554431

/* Defines for ulFlags on VCADEVAUDIO IOCTL */
#define VCADEV_AUDIO_FLAG_MUTE   1
#define VCADEV_AUDIO_FLAG_UNMUTE 0

/* Defines for ulL_xxx and ulR_xxx on VCADEVAUDIO IOCTL         */
/*  -1=no change, -2=reset default, -1 on QUERY = not supported */
#define VCA_QUERY_CURRENT  0xFFFFFFFF
#define VCA_SET_TO_DEFAULT 0xFFFFFFFE
#define VCA_NOT_SUPPORTED  0xFFFFFFFF
                                       /* New Volume Functions - End   */


typedef struct
{
   ULONG   vfh_FrameNumber;      /* relative frame number       */
   ULONG   vfh_FramesSkipped;    /* no. frames skipped          */
   ULONG   vfh_StreamTime;       /* stream time in milliseconds */
   ULONG   vfh_FrameSize;        /* size in bytes               */
   ULONG   vfh_SHparm1;          /* used by stream handler      */
   ULONG   vfh_reserved3;        /* unused                      */
   ULONG   vfh_reserved2;        /* unused                      */
   ULONG   vfh_reserved1;        /* unused                      */
} VIDEO_FRAME_HDR, FAR *PVIDEO_FRAME_HDR;

void ini_load (char *ini_name);


typedef struct MODEINFO
{
    ULONG mi_len;
    ULONG mi_bpp;
    ULONG mi_hres;
    ULONG mi_vres;
    ULONG mi_vram_address;
    ULONG mi_vram_bank_size;    // Current bank size
    ULONG mi_line_size;         // Size in bytes of one scan line
    ULONG mi_fcc;               // PEL format FOURCC
    ULONG mi_vram_size;
} MODEINFO, FAR *PMODEINFO;


typedef struct INIDATA
{
    char *ini_name;
    void *ini_address;
} INIDATA, FAR *PINIDATA;

                            // This structure is used by the hardware layer
                            // to supply the generic layer with the addresses
                            // of some key fields.
typedef struct DETAILS
{
    ULONG  det_length;
    UCHAR  det_product[30];         // VCA product name
    UCHAR  det_manufacturer[30];    // VCA manufacturer
    UCHAR  det_version[10];         // VCA version
    USHORT *det_id;                 // address of VCAs Id      variable
    USHORT *det_irq;                // address of VCAs Irq     variable
    USHORT *det_io;                 // address of VCAs Io      variable
    USHORT *det_dma;                // address of VCAs dma     variable
    ULONG  *det_memory;             // address of VCAs memory  variable
    UCHAR  *det_inifile;            // address of VCAs inifile variable
} VCADETAILS, FAR *PVCADETAILS;

                            // Instance data structure passed from the generic
                            // layer to the hardware specific.
                            // The generic layer is responble for creating
                            // & initialising this data structure.
                            // In the current release (20/5/95) the instance
                            // data is single instance per driver
typedef struct VCAINST
{
    USHORT      vca_videoinput;
    USHORT      vca_videoinputs;
    ULONG       vca_fps_rate;
    ULONG       vca_fps_type;
    USHORT      vca_screenwidth;
    USHORT      vca_screenheight;
    USHORT      vca_xposition;
    USHORT      vca_yposition;
    SHORT       vca_xoffset;
    SHORT       vca_yoffset;
    USHORT      vca_windowwidth;
    USHORT      vca_windowheight;
    USHORT      vca_internhscale;
    USHORT      vca_internvscale;
    USHORT      vca_externhscale;
    USHORT      vca_externvscale;
    USHORT      vca_externhzoom;
    USHORT      vca_externvzoom;
    USHORT      vca_vzoomfactor;
    USHORT      vca_vzoomtearpoint;
    ULONG       vca_numcolours;
    ULONG       vca_colourkey;
    USHORT      vca_vgacolours;
    USHORT      vca_vgaclock;
    VIDSETTINGS vca_video;
    VCADEVAUDIO vca_aud;
    ULONG       vca_captureformat;
    USHORT      vca_capturebpp;
    USHORT      vca_capturemask;
    USHORT      vca_capturequality;
    USHORT      vca_freezestatus;
    USHORT      vca_inputformat;
    BOOL        vca_monitor;
    BOOL        vca_colourkeyflag;
    BOOL        vca_chromakeyflag;
    ULONG       vca_tunerregion;
    ULONG       vca_tunerchannel;
    ULONG       vca_tunerfreq;             // Sky Satellite/Video
    LONG        vca_tunerfinetune;
    BOOL        vca_tunerafc;
    BOOL        vca_tunerpolarization;
    BOOL        vca_tunermute;
    USHORT      vca_tunertype;              // Different tuner types
    USHORT      vca_tuneraddress;           // Added to support new tuners
    BOOL        vca_overlay;                // Is this an overlay driver
    BOOL        vca_monitorsvert;           // Multi-monitor setting
    BOOL        vca_monitorshoriz;          // Multi-monitor setting
    BOOL        vca_hwnd;                   // Destination Window Handle
    BOOL        vca_vram_present;           // Is there a physical VRAM buffer
} VCAINST, FAR * PVCAINST;

