
/*------------------------------------------------------------------*
 *                                                                  *
 *  Video Toolkit For OS/2 Version 2.0                              *
 *  Example PM Application No. 2.                                   *
 *  Date : 22/02/95.                                                *
 *  Copyright (c) Abbotsbury Software Ltd., United Kingdom. 1995-98 *
 *                                                                  *
 *  Filename : ex2.c                                                *
 *                                                                  *
 *------------------------------------------------------------------*/

#define     INCL_PM
#define     INCL_OS2MM
#define     INCL_DOS
#define     INCL_SW

#include    <os2.h>
#include    <os2me.h>
#include    <stdlib.h>
#include    <stdio.h>
#include    <string.h>
#include    <vcadd.h>
#include    <vcai.h>
#include    "ex2.h"
#include    "pmtv2rem.h"
#include    "helpfunc.h"
#include    "region.h"

extern  BOOL    RemOpen;
extern  MRESULT EXPENTRY TuneDlgProc (HWND hwnd, ULONG msg,
                                      MPARAM mp1, MPARAM mp2);

HAB     Hab;
HWND    HwndFrame;
DRIVERHANDLE    DevHandle;
USHORT  DevInstance;
CHAR    DevType[20];
LONG    ColourKey;
LONG    Colours[256];
LONG    NumColours;

static  HWND    HwndClient, HwndRemote;
static  VCADEVINFO  DevInfo;
static  PSZ     RemoteName = "RemoteDlgProc";
static  PFN     RemoteAddr;
static  HMODULE HmodRemote;
static  CHAR    txt[256];
static  UCHAR   *Copyright =
  "Copyright (c) Abbotsbury Software Ltd., UK. 1994-1998. All Rights Reserved";

int     main (int argc, char **argv);
void    msg_box (UCHAR *txt, UCHAR *title, ULONG options);
void    err_msg (UCHAR *mess);
LONG    get_colour (HPS hps);
MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY QuitDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY AboutDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

static  BOOL    init_window (void);
static  void    init_colour (void);
static  void    map_pallete (HPS hps);

int main (int argc, char **argv)
{
    HMQ     hmq;
    QMSG    qmsg;
    CHAR    mod_txt[256];
    PSZ     pmmbase, env = "MMBASE";
    LONG    len;
    APIRET  rc;

        if (argc < 3)
            DosExit (EXIT_PROCESS, 1);

        Hab = WinInitialize (0);
        if (!Hab)
            DosExit (EXIT_PROCESS, 1);

        hmq = WinCreateMsgQueue (Hab, 0);
        if (!hmq)
            DosExit (EXIT_PROCESS, 1);

        strcpy (DevType, argv[1]);
        DevInstance = (USHORT)atoi (argv[2]);
        DevHandle = VcaiDeviceOpen (DevType, DevInstance);
        if (DevHandle < 0)
        {
            sprintf (txt, "Cannot Open Device %u !", atoi (argv[2]));
            msg_box (txt, "Error", MB_OK | MB_ERROR);
            DosExit (EXIT_PROCESS, 1);
        }

        rc = DosScanEnv (env, &pmmbase);
        if (rc != 0)
            DosExit (EXIT_PROCESS, 1);
        len = strlen (pmmbase);
        if (pmmbase[len-1] == ';')
            pmmbase[len-1] = '\0';
        sprintf (mod_txt, "%s\\DLL\\PMTV2REM.DLL", pmmbase);
        rc = DosLoadModule (txt, sizeof (txt), mod_txt, &HmodRemote);
        if (rc != 0)
            DosExit (EXIT_PROCESS, 1);
        rc = DosQueryProcAddr (HmodRemote, 0L, RemoteName, &RemoteAddr);
        if (rc != 0)
            DosExit (EXIT_PROCESS, 1);

        if (!init_window ())
            DosExit (EXIT_PROCESS, 1);

        while (WinGetMsg (Hab, &qmsg, NULLHANDLE, 0, 0))
            WinDispatchMsg (Hab, &qmsg);

        DestroyHelpInstance ();
        WinDestroyWindow (HwndFrame);
        WinDestroyMsgQueue (hmq);
        WinTerminate (Hab);
        DosExit (EXIT_PROCESS, 0);
}

void msg_box (UCHAR *txt, UCHAR *title, ULONG options)
{
        WinMessageBox (HWND_DESKTOP,
                       HWND_DESKTOP,
                       txt,
                       title,
                       IDD_MSG,
                       options);
}

void err_msg (UCHAR *mess)
{
    CHAR    txt[256];
    ERRORID err;

        err = WinGetLastError (Hab);
        sprintf (txt, "%s - %lx", mess,  err & 0xffff);
        msg_box (txt, "Error", MB_OK | MB_ERROR);
}

                        // The colour value for the Video Colour Key
                        // is a physical palette value.
                        // For systems with 256 or less colours in the
                        // palette, you MUST map the physical palette
                        // to PM logical palette first.
                        // If there are more than 256 colours this
                        // step should be ignored.
LONG get_colour (HPS hps)
{
    LONG index;

        map_pallete (hps);

        index = VcaiColourkeyGet();
        if (index > (ULONG)NumColours)
        {
            index = COLOUR_KEY_DEFAULT;
            VcaiColourkeySet (index);
        }
        return (LONG)index;
}

MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    static  HWND        hwnd_menu;
    static  HPOINTER    hptr_rem;
    static  BOOL        minimize = FALSE;
    HPS     hps;
    RECTL   rcl;
    LONG    bx, by, cy, x, y, width, height;
    VCADEVAUDIO ad;
    MOUSEPOS mousepos;
    PSWP    pswp;

        switch(msg)
        {
            case WM_CREATE :
                RemOpen = FALSE;
                VcaiOverlay (TRUE);
                VcaiFreeze (FALSE);
                hwnd_menu = WinLoadMenu (hwnd, NULLHANDLE, IDR_MAIN);
                hptr_rem = WinLoadPointer (HWND_DESKTOP, NULLHANDLE,
                                           PTR_REMOTE);
                init_colour ();
                break;
            case WM_PAINT :
                hps = WinBeginPaint (hwnd, NULLHANDLE, &rcl);
                WinQueryWindowRect (hwnd, &rcl);
                ColourKey = get_colour (hps);
                if ((ULONG)NumColours <= 256)
                    WinFillRect (hps, &rcl, Colours[ColourKey]);
                else
                    WinFillRect (hps, &rcl, ColourKey);
                WinEndPaint (hps);
                break;
            case MSG_SIZE_TV :
            case WM_SIZE :
            case WM_MOVE :
            case WM_WINDOWPOSCHANGED :
                if (minimize)
                    break;
                if (!WinQueryWindowRect (hwnd, &rcl))
                    return 0;
                WinMapWindowPoints (hwnd, HWND_DESKTOP, (PPOINTL)&rcl, 2);
                bx = WinQuerySysValue (HWND_DESKTOP, SV_CXSIZEBORDER);
                by = WinQuerySysValue (HWND_DESKTOP, SV_CYSIZEBORDER);
                cy = WinQuerySysValue (HWND_DESKTOP, SV_CYSCREEN);
                x = rcl.xLeft + bx;
                y = cy - rcl.yTop - by;
                width = rcl.xRight - rcl.xLeft;
                height = rcl.yTop - rcl.yBottom;
                VcaiVideoRectValidate (0, 0, 0, 0, (USHORT)x, (USHORT)y,
                                       (USHORT)width, (USHORT)height);
                if (RemOpen)
                    WinSetActiveWindow (HWND_DESKTOP, HwndRemote);
                break;
            case WM_MINMAXFRAME :
                pswp = (PSWP)PVOIDFROMMP (mp1);
                if (!(pswp->fl & SWP_MINIMIZE))
                {
                    minimize = FALSE;
                    break;
                }
                minimize = TRUE;
                VcaiVideoRectValidate (0, 0, 0, 0, 0, 0, 0, 0);
                break;
            case WM_BUTTON1CLICK :
                if (RemOpen)
                    return 0;
                WinQueryWindowRect (hwnd, & rcl);
                WinMapWindowPoints (hwnd, HWND_DESKTOP, (PPOINTL)&rcl, 2);
                mousepos.mp_x = MOUSEMSG (&msg)->x + rcl.xLeft;
                mousepos.mp_y = MOUSEMSG (&msg)->y + rcl.yBottom;
                init_audio ();
                init_video ();
                HwndRemote = WinLoadDlg (HWND_DESKTOP,
                                         HWND_DESKTOP,
                                         (PFNWP)RemoteAddr,
                                         HmodRemote,
                                         IDD_REM,
                                         (PVOID)&mousepos);
                return 0;
            case WM_BUTTON2CLICK :
                WinPopupMenu (hwnd, hwnd, hwnd_menu,
                              MOUSEMSG (&msg)->x, MOUSEMSG (&msg)->y, 0L,
                              PU_HCONSTRAIN | PU_VCONSTRAIN |
                              PU_NONE | PU_MOUSEBUTTON1 |
                              PU_KEYBOARD);
                return 0;
            case WM_MOUSEMOVE :
                WinSetPointer (HWND_DESKTOP, hptr_rem);
                return MRFROMSHORT (1);

            case WM_CLOSE :
                VcaiDeviceClose (DevHandle);
                break;

            case WM_COMMAND :
                switch (SHORT1FROMMP (mp1))
                {
                    case IDM_FILE_QUIT :
                        WinDlgBox (HWND_DESKTOP,
                                   HwndFrame,
                                   (PFNWP)QuitDlgProc,
                                   (HMODULE)NULLHANDLE,
                                   IDD_QUIT,
                                   NULL);
                        WinInvalidateRegion (HwndFrame, NULLHANDLE, FALSE);
                        break;
                    case IDM_TUNE :
                        WinDlgBox (HWND_DESKTOP,
                                   HWND_DESKTOP,
                                   (PFNWP)TuneDlgProc,
                                   (HMODULE)NULLHANDLE,
                                   IDD_TUNE,
                                   NULL);
                        break;
                    case IDM_HELPCONTENTS :
                        HelpContents ();
                        break;
                    case IDM_HELPINDEX :
                        HelpIndex ();
                        break;
                    case IDM_KEYSHELP :
                        HelpKeys ();
                        break;
                    case IDM_GENERALHELP :
                        HelpHelpForHelp ();
                        break;
                    case IDM_HELPPRODUCTINFO :
                        HelpAbout ();
                        break;
                    default :
                        break;
                }
                break;
            case HM_QUERY_KEYS_HELP :
                return ((MRESULT)PANEL_KEYSHELP);
            case MSG_UPDATE_WINDOW :
                WinQueryWindowRect (hwnd, &rcl);
                WinInvalidateRect (hwnd, &rcl, TRUE);
                WinPostMsg (hwnd, MSG_SIZE_TV, NULL, NULL);
            default :
                break;
        }
        return WinDefWindowProc (hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY QuitDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
        switch (msg)
        {
            case WM_COMMAND :
                switch (SHORT1FROMMP (mp1))
                {
                    case DID_OK :
                        WinPostMsg (HwndFrame, WM_CLOSE, NULL, NULL);
                        WinDismissDlg (hwnd, TRUE);
                        break;
                    case DID_CANCEL :
                        WinDismissDlg (hwnd, TRUE);
                        break;
                    default :
                        break;
                }
                break;
            default :
                break;
        }
        return WinDefDlgProc (hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY AboutDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    HPS     hps;
    RECTL   rcl;
    LONG    x, y;

        switch (msg)
        {
            case WM_PAINT :
                hps = WinBeginPaint (hwnd, NULLHANDLE, &rcl);
                WinQueryWindowRect (hwnd, &rcl);
                WinFillRect (hps, &rcl, CLR_PALEGRAY);
                sprintf (txt, "%30.30s", DevInfo.ProdInfo);
                WinSetDlgItemText (hwnd, IDD_ABOUT_PROD_INFO, txt);
                sprintf (txt, "%30.30s", DevInfo.ManInfo);
                WinSetDlgItemText (hwnd, IDD_ABOUT_MAN_INFO, txt);
                sprintf (txt, "%10.10s", DevInfo.Version);
                WinSetDlgItemText (hwnd, IDD_ABOUT_VERSION, txt);
                WinDrawBorder (hps, &rcl, x, y, 0L, 0L, DB_AREAATTRS |
                               DB_DLGBORDER);
                WinEndPaint (hps);
                break;
            case WM_COMMAND :
                switch (SHORT1FROMMP (mp1))
                {
                    case DID_OK :
                        WinDismissDlg (hwnd, TRUE);
                        break;
                    default :
                        break;
                }
                break;
            default :
                break;
        }
        return WinDefDlgProc (hwnd, msg, mp1, mp2);
}

static BOOL init_window ()
{
    CHAR    szClient[] = "Client";
    ULONG   flFrameFlags = FCF_TITLEBAR | FCF_SYSMENU | FCF_ICON |
                           FCF_SIZEBORDER | FCF_MINMAX | FCF_ACCELTABLE |
                           FCF_SHELLPOSITION | FCF_TASKLIST;

        if (!WinRegisterClass (Hab, szClient, ClientWndProc,
                               CS_SIZEREDRAW | CS_MOVENOTIFY, 0))
            return (FALSE);

        if (!WinRegisterGraphicButton ())
            return (FALSE);

        DevInfo.Length = sizeof (VCADEVINFO);
        VcaiDeviceInfoGet (&DevInfo);

        sprintf (txt, "Example 2 - %s %u", DevType, DevInstance);

        HwndFrame = WinCreateStdWindow (HWND_DESKTOP,
                                        WS_VISIBLE,
                                        &flFrameFlags,
                                        szClient,
                                        txt,
                                        0L,
                                        (HMODULE)NULLHANDLE,
                                        IDR_MAIN,
                                        &HwndClient);
        if (!HwndFrame)
            return (FALSE);

        HelpInit (HwndFrame);

        if (!init_video ())
            return (FALSE);

        if (!init_audio ())
            return (FALSE);

        return (TRUE);
}

static void init_colour ()
{
    HDC     hdc;
    DEVOPENSTRUC dop = {NULL, "DISPLAY", NULL, NULL, NULL, NULL, NULL, NULL,
                        NULL};

        hdc = DevOpenDC (Hab, OD_INFO, "*", 5L, (PDEVOPENDATA)&dop, NULLHANDLE);
        DevQueryCaps (hdc, CAPS_COLORS, 1L, &NumColours);
        DevCloseDC (hdc);
}


static void map_pallete (HPS hps)
{
    LONG    rc;
    VCASCREENINFO vs;
    USHORT cx, cy, i;

        if ((NumColours <= 256) && (NumColours > 0))
        {
            rc = GpiQueryRealColors (hps, 0L, 0L, NumColours, Colours);
            if (rc == GPI_ALTERROR)
            {
                err_msg ("GpiQueryRealColors");
                return;
            }
        }
        cx = WinQuerySysValue (HWND_DESKTOP, SV_CXSCREEN);
        cy = WinQuerySysValue (HWND_DESKTOP, SV_CYSCREEN);
        vs.ulLength = sizeof (VCASCREENINFO);
        vs.ul_RESV01 = 0L;
        vs.ulWidth = (ULONG)cx;
        vs.ulHeight = (ULONG)cy;
        vs.ulNumColours = (ULONG)NumColours;
        vs.ulHFreq = 0L;
        vs.ulVFreq = 0L;
        if ((ULONG)NumColours <= 256)
        {
            for (i = 0; i < NumColours; i++)
                vs.ulRGB[i] = (ULONG)Colours[i];
        }
        else
        {
            for (i = 0; i < 256; i++)
                vs.ulRGB[i] = 0L;
        }
        VcaiScreenInfoSet (&vs);
        rc = GpiCreateLogColorTable (hps, LCOL_RESET, LCOLF_RGB,
                                     0L, 0L, (PLONG)0L);
        if (!rc)
        {
            err_msg ("GpiCreateLogColorTable");
            return;
        }
}
