/**********************************************************************/
/* CDSETUP.C: OS/2 Base Device Driver                                 */
/* (C) A. Zeuner 1994/95                                              */
/*     Uni Magdeburg                                                  */
/*     IEP/NLP                                                        */
/**********************************************************************/
#include <drvlib.h>
#include "cdsetup.h"


/**********************************************************************/
/* DEVICE-HEADER                                                      */
/**********************************************************************/
#pragma data_seg("HEADER");

DEVICEHDR devhdr= {
   (FPDEVICEHDR) 0xFFFFFFFFL,
   (DAW_CHR | DAW_LEVEL3),
   (NPVOID)CDStrategy,
   (NPVOID)__IDC_ENTRY,
   "CDSETUP$",
   {0,0,0,0,0,0,0,0},
   CBS_ADD 
};
#pragma data_seg();

/**********************************************************************/
/* STATISCHE DATEN                                                    */
/**********************************************************************/

ULONG       DevHlp       =0L;

/******************************************************************/
/* Strategy-Routine                                               */
/******************************************************************/
VOID CDStrategy(PREQPACKET rp)
{
switch(rp->RPcommand) {
   case RPINIT:
   case RPINIT_ADD:
      rp->RPstatus=CDInit(rp);
      break;
   default:
      rp->RPstatus=RPDONE | RPERR | I24_BAD_COMMAND;
      break;
}
}


