/* mscntrl.c */

#pragma strings(readonly)

#include <stdlib.h>
#include <stdio.h>
#define INCL_BASE
#define INCL_ERRORS
#include <os2.h>

/*  */
#define IOCTL_CDROMDISK        0x80
#define CDROMDISK_MS_CTRL      0x4a
#define CDROMDISK_DEVICESTATUS 0x60

#define IOCTL_CDROMDISK2        0x82
#define CDROMDISK2_DRIVELETTERS 0x60
#define CDROMDISK2_FEATURES     0x63

#define MSCTRL_DISABLEMS 0x0001
struct MSCtrl_Parm
{
    ULONG ID_code;
    USHORT flags;
};

struct DeviceStatus_Parm
{
    ULONG ID_code;
};
#define DSF_MS_DISABLED 0x10000000L
#define DSF_MS_SUPPORT  0x20000000L
struct DeviceStatus_Data
{
    ULONG device_status;
};

struct DriveLetters_Data
{
    USHORT drive_count;
    USHORT first_drive;
};

#define FEATURE_MSCTRL_SUPPORT 0x00008000L
struct Features_Data
{
    ULONG driver_status;
};

#define CD01 (((ULONG)'C' << 0) + ((ULONG)'D' << 8) + ((ULONG)'0' << 16) + ((ULONG)'1' << 24))

/*  */
int main(int argc,
         char* argv[])
{
    APIRET rc;
    HFILE hfDMD, hfDrive;
    ULONG ulWork;
    ULONG ulDriveIndex;
    union
    {
        struct DeviceStatus_Parm DeviceStatus;
        struct MSCtrl_Parm MSCtrl;
    } xParm;
    ULONG ulParmLength;
    union
    {
        struct Features_Data Features;
        struct DriveLetters_Data DriveLetters;
        struct DeviceStatus_Data DeviceStatus;
    } xData;
    ULONG ulDataLength;
    UCHAR aucDrive[4];
    BOOL bNewState;

    if(argc > 1)
    {
        rc = DosOpen((PSZ)"\\DEV\\CD-ROM2$",
                     &hfDMD,
                     &ulWork,
                     (ULONG)0,
                     FILE_NORMAL,
                     OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
                     OPEN_FLAGS_FAIL_ON_ERROR | OPEN_FLAGS_NOINHERIT | OPEN_SHARE_DENYNONE | OPEN_ACCESS_READONLY,
                     (PEAOP2)NULL);
        if(rc != NO_ERROR)
            (void)printf("CD-ROM device manager driver is not installed.\n");
        else
        {
            rc = DosDevIOCtl(hfDMD,
                             IOCTL_CDROMDISK2,
                             CDROMDISK2_FEATURES,
                             (PVOID)NULL,
                             (ULONG)0,
                             (PULONG)NULL,
                             (PVOID)&xData.Features,
                             ulDataLength = (ULONG)sizeof(xData.Features),
                             &ulDataLength);
            if(rc != NO_ERROR ||
               (xData.Features.driver_status & FEATURE_MSCTRL_SUPPORT) == (ULONG)0)
                (void)printf("CD-ROM device manager driver does not support 'multisession control' feature.\n");
            else
            {
                ulDriveIndex = (ULONG)((argv[1][0] & (char)~('a' - 'A')) - (char)'A');
                rc = DosDevIOCtl(hfDMD,
                                 IOCTL_CDROMDISK2,
                                 CDROMDISK2_DRIVELETTERS,
                                 (PVOID)NULL,
                                 (ULONG)0,
                                 (PULONG)NULL,
                                 (PVOID)&xData.DriveLetters,
                                 ulDataLength = (ULONG)sizeof(xData.DriveLetters),
                                 &ulDataLength);
                if(rc != NO_ERROR)
                    (void)printf("cannot determine CD-ROM driveletter range.\n");
                else if(ulDriveIndex < (ULONG)xData.DriveLetters.first_drive ||
                        ulDriveIndex >= (ULONG)(xData.DriveLetters.first_drive + xData.DriveLetters.drive_count))
                    (void)printf("%c is not a CD-ROM drive.\n",
                                 'A' + (int)ulDriveIndex);
                else
                {
                    aucDrive[0] = (UCHAR)('A' + (int)ulDriveIndex);
                    aucDrive[1] = (UCHAR)':';
                    aucDrive[2] = (UCHAR)'\0';
                    rc = DosOpen((PSZ)&aucDrive[0],
                                 &hfDrive,
                                 &ulWork,
                                 (ULONG)0,
                                 FILE_NORMAL,
                                 OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
                                 OPEN_FLAGS_DASD | OPEN_FLAGS_FAIL_ON_ERROR | OPEN_FLAGS_NOINHERIT | OPEN_SHARE_DENYNONE | OPEN_ACCESS_READONLY,
                                 (PEAOP2)NULL);
                    if(rc != NO_ERROR)
                        (void)printf("cannot open CD-ROM drive %c.\n",
                                     'A' + (int)ulDriveIndex);
                    else
                   {
                        xParm.DeviceStatus.ID_code = CD01;
                        rc = DosDevIOCtl(hfDrive,
                                         IOCTL_CDROMDISK,
                                         CDROMDISK_DEVICESTATUS,
                                         (PVOID)&xParm.DeviceStatus,
                                         ulParmLength = (ULONG)sizeof(xParm.DeviceStatus),
                                         &ulParmLength,
                                         (PVOID)&xData.DeviceStatus,
                                         ulDataLength = (ULONG)sizeof(xData.DeviceStatus),
                                         &ulDataLength);
                        if(rc != NO_ERROR)
                            (void)printf("cannot determine device status of CD-ROM drive %c.\n",
                                         'A' + (int)ulDriveIndex);
                        else if((xData.DeviceStatus.device_status & DSF_MS_SUPPORT) == (ULONG)0)
                            (void)printf("CD-ROM drive %c does not support multisessioning.\n",
                                         'A' + (int)ulDriveIndex);
                        else
                        {
                            (void)printf("CD-ROM drive %c multisessioning is currently %s.\n",
                                         'A' + (int)ulDriveIndex,
                                         (xData.DeviceStatus.device_status & DSF_MS_DISABLED) == (ULONG)0 ? "ENABLED" : "DISABLED");
                            if(argc > 2)
                            {
                                xParm.MSCtrl.ID_code = CD01;
                                xParm.MSCtrl.flags = (bNewState = (BOOL)(atoi((const char*)argv[2]) != 0)) ? MSCTRL_DISABLEMS : (USHORT)0;
                                rc = DosDevIOCtl(hfDrive,
                                                 IOCTL_CDROMDISK,
                                                 CDROMDISK_MS_CTRL,
                                                 (PVOID)&xParm.MSCtrl,
                                                 ulParmLength = (ULONG)sizeof(xParm.MSCtrl),
                                                 &ulParmLength,
                                                 (PVOID)NULL,
                                                 (ULONG)0,
                                                 (PULONG)NULL);
                                if(rc != NO_ERROR)
                                    (void)printf("cannot set 'multisession control' flags of CD-ROM drive %c.\n",
                                                 'A' + (int)ulDriveIndex);
                                else
                                    (void)printf("  --> now %s.\n",
                                                 bNewState == (BOOL)FALSE ? "ENABLED" : "DISABLED");
                            }
                        }
                        (VOID)DosClose(hfDrive);
                    }
                }
            }
            (VOID)DosClose(hfDMD);
        }
    }
    else
        (void)printf("mscntrl.exe:  sets or resets 'multisessioning disabling' flag of\n"
                     "                specified CD-ROM drive.\n"
                     "usage:  mscntrl  {CD-ROM driveletter}  [0(reset) / 1(set)]\n"
                     "ex.  mscntrl G    (to show current state only)\n"
                     "     mscntrl G 1  (to set 'multisessioning disabling' flag)\n");

    return 0;
}

