/*
    Copyright

   (standard Lucent Technologies copyright)



*/
/* This Rexx Script will place the correct config.sys statements
   into your config.sys file to give your system the correct drivers and
   program for your Lucent Technologies modem.

   Your old config.sys will be renamed config.lt.     */



/* Copy files from Source to Destination

   Source is assumed to be the current directory
   Destination is:

     X:\os2 for applications and ini file
     X:\os2\boot for driver file

   Where X: is the drive OS2 is installed on.

*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

Signal ON HALT

BootDrive = filespec('Drive',Value('USER_INI',,'OS2ENVIRONMENT'))

outfile = BootDrive'\config.sys'
infile  = BootDrive'\config.lt'
tempfile=systempfilename(BootDrive'\config.???')

if stream(outfile, 'C', 'Query Exists') = '' then do
   say 'Install failed.  Could not locate file: 'outfile)
   exit
end

'@copy 'outfile infile '> nul'   /* Create backup file */

/* We will create a new config.sys using the tempfile name.
   Once we have finished without error, we will copy tempfile
   to config.sys
*/

rc=lineout(tempfile,'REM   LTMDMOS2 install - The device=ltmdmos2.sys line must come prior')
rc=lineout(tempfile,'REM   to the device=com.sys line')
rc=lineout(tempfile,'DEVICE='BootDrive'\os2\boot\ltmdmos2.sys')
rc=lineout(tempfile,'RUN='BootDrive'\os2\boot\lt_mon.exe')
rc=lineout(tempfile,'REM   end LTMDMOS2 install')

do while lines(infile)
   line=linein(infile)
   parse upper value line with keyword "=" therest
   if (keyword=DEVICE) then do
      if pos(' ',therest) = 0 then
         pathname=therest
      else
         pathname=substr(therest,1,pos(' ',therest))

      lpname=pathname
      do while pos('\',pathname)\=0
         parse UPPER value pathname with apath '\' pathname
      end
      parse value pathname with driver " " params
      if driver = LTMDMOS2.SYS then do
         rc=lineout(tempfile,'REM The following line "REM"ed by LT install')
         rc=lineout(tempfile,'REM 'line)
      end
      else
         rc=lineout(tempfile, line)
   end /* if keyword=DEVICE */

   else if (keyword=RUN) then do
      if pos(' ',therest) = 0 then
         pathname=therest
      else
         pathname=substr(therest,1,pos(' ',therest))

      lpname=pathname
      do while pos('\',pathname)\=0
         parse UPPER value pathname with apath '\' pathname
      end
      parse value pathname with program " " params
      if program = LT_MON.EXE then do
         rc=lineout(tempfile,'REM The following line "REM"ed by LT install')
         rc=lineout(tempfile,'REM 'line)
      end
      else
         rc=lineout(tempfile, line)
   end /* if keyword=RUN */
   else
      rc=lineout(tempfile, line)
end /* while loop for lines in config.lt */

/* close tempfile */
rc=lineout(tempfile)

/* copy the newly created tempfile to config.sys */
'@copy 'tempfile outfile '> nul'
'@del 'tempfile' > nul'


/* Copy files from installation source to correct destinations */

'@copy ltcs.exe 'BootDrive'\os2\ > nul'
'@copy ltmdmos2.sys 'BootDrive'\os2\boot\ > nul'
'@copy ltmodem.ini 'BootDrive'\os2\ > nul'

monitorprg = BootDrive'\os2\boot\lt_mon.exe'

if stream(monitorprg, 'C', 'Query Exists') \= '' then do
   '@lt_mon.exe > nul' /* This should kill the current version in \os2\boot */

end

'@copy lt_mon.exe  'BootDrive'\os2\boot\ > nul'


/* Create the icon in the 'System Setup' Folder */

class = "WPPROGRAM"
cr = '0d'x
lf = '0a'x
title = "Modem "cr||lf"Country Select"
location = "<WP_CONFIG>"

rc=Syscreateobject(class, title, location, "EXENAME="BootDrive"\os2\ltcs.exe;STARTUPDIR="BootDrive"\os2")

exit

HALT:
  SAY 'Exiting install due to Control-C'
  exit


