/*
    Copyright 1999 Lucent Technologies
    Copyright 2001 Applied Digital Consulting

*/


/* This REXX Script will place the correct config.sys statements
   into your config.sys file to give your system the correct drivers and
   program for your Lucent Technologies modem.

   Your old config.sys will be renamed config.lt.

*/

/* Copy files from Source to Destination

   Source is assumed to be the current directory
   Destination is:

     X:\os2 for applications and ini file
     X:\os2\boot for driver  and snooper files

   Where X: is the drive OS2 is installed on.

*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

Signal ON HALT

infile = "ltmodem.ini"

iniheader. = 0


langstr = translate(VALUE('lang',,'OS2ENVIRONMENT'))
BootDrive = filespec('Drive',Value('USER_INI',,'OS2ENVIRONMENT'))

call ParseIniFile

/* check to see if langauage is set in [DialogText] section of .ini */
lang = getentry( 'DialogText' 'Language')
/* If langauge was not set, try and determine language from 'lang' environment variable */
if lang = '' then
   lang = getentry( 'OS2LanguageCode' langstr)
/* Cannot determine language so default to english */
if lang = '' then
   lang = 'English'


call modifyConfigSys
call killmonitor
call copyFiles
call createIcon
say
say getentry( lang 'OS2RestartText')

say
say getentry( lang 'ExitInstText')

pull

exit

/* Modify Config.sys */
modifyConfigSys: Procedure expose BootDrive iniheader. lang

   outfile = BootDrive'\config.sys'
   infile  = BootDrive'\config.lt'
   tempfile=systempfilename(BootDrive'\config.???')

   if stream(outfile, 'C', 'Query Exists') = '' then do
      say getentry( lang 'MissingConfigFileText')' 'outfile
      exit
   end

   '@copy 'outfile infile '> nul'   /* Create backup file */

   /* We will create a new config.sys using the tempfile name.
      Once we have finished without error, we will copy tempfile
      to config.sys
   */

   rc=lineout(tempfile,'REM   LTMDMOS2 install - The device=ltmdmos2.sys line must come prior to the device=com.sys line')
   rc=lineout(tempfile,'DEVICE='BootDrive'\os2\boot\ltmdmos2.sys')
   rc=lineout(tempfile,'RUN='BootDrive'\os2\boot\lt_mon.exe')
   rc=lineout(tempfile,'REM   end LTMDMOS2 install')

   ltmodem_driver_exists = 0
   no_change_required_for_lt_driver = 0
   no_change_required_for_lt_monitor =0
   com_driver_exists = 0
   configsys_update_required = 0

   do while lines(infile)
      line=linein(infile)
      parse upper value line with keyword "=" therest
      if (keyword=DEVICE) then do
         if pos(' ',therest) = 0 then
            pathname=therest
         else
            pathname=substr(therest,1,pos(' ',therest))

         lpname=pathname
         do while pos('\',pathname)\=0
            parse UPPER value pathname with apath '\' pathname
         end
         parse value pathname with driver " " params
         if driver = LTMDMOS2.SYS then do
            if com_driver_exists = 1 then do
               configsys_update_required = 1
            end
            ltmodem_driver_exists = 1
            rc=lineout(tempfile,'REM The following line "REM"ed by LT install')
            rc=lineout(tempfile,'REM 'line)
         end
         else do
            if driver = COM.SYS then do
               com_driver_exists = 1
               if ltmodem_driver_exists then do
                  no_change_required_for_lt_driver = 1
               end
            end
            rc=lineout(tempfile, line)
         end
      end /* if keyword=DEVICE */

      else if (keyword=RUN) then do
         if pos(' ',therest) = 0 then
            pathname=therest
         else
            pathname=substr(therest,1,pos(' ',therest))

         lpname=pathname
         do while pos('\',pathname)\=0
            parse UPPER value pathname with apath '\' pathname
         end
         parse value pathname with program " " params
         if program = LT_MON.EXE then do
            no_change_required_for_lt_monitor =1
            rc=lineout(tempfile,'REM The following line "REM"ed by LT install')
            rc=lineout(tempfile,'REM 'line)
         end
         else
            rc=lineout(tempfile, line)
      end /* if keyword=RUN */
      else
         rc=lineout(tempfile, line)
   end /* while loop for lines in config.lt */

   /* close tempfile */
   rc=lineout(tempfile)

   if ( configsys_update_required = 1) | (no_change_required_for_lt_driver = 0) | (no_change_required_for_lt_monitor =0)
   then do
      say getentry(lang 'ChangeConfigFileText')' 'infile
      say
      /* copy the newly created tempfile to config.sys */
      '@copy 'tempfile outfile '> nul'
   end

   '@del 'tempfile' > nul'

return


/* Copy files from installation source to correct destinations */
copyfiles: Procedure expose BootDrive

   'copy LTEEPROM.DAT 'BootDrive'\ '
   'copy ltcs.exe 'BootDrive'\os2\ '
   'copy ltmdmos2.sys 'BootDrive'\os2\boot\ '
   'copy lt_mon.exe 'BootDrive'\os2\boot\ '
   'copy ltmodem.ini 'BootDrive'\os2\ '

return


killmonitor: Procedure expose BootDrive
   monitorprg = BootDrive'\os2\boot\lt_mon.exe'

   '@del 'monitorprg '1> nul 2>nul'
   if stream(monitorprg, 'C', 'Query Exists') \= '' then do
      '@lt_mon.exe > nul' /* This should kill the current version in \os2\boot */
   end

return


/* Create the icon in the 'System Setup' Folder */
createIcon: Procedure expose BootDrive lang iniheader. lang

   class = "WPPROGRAM"
   cr = '0d'x
   lf = '0a'x


   title = getentry(lang 'AppletName')

   location = "<WP_CONFIG>"
   objectid = "<LT_CS_APP>"

   say
   say GetEntry( lang 'CreateIconText') " '"title"'"
   rc=SysDestroyObject(objectid)
   rc=Syscreateobject(class, title, location, "EXENAME="BootDrive"\os2\ltcs.exe;STARTUPDIR="BootDrive"\os2;OBJECTID="objectid)

return

ParseIniFile: Procedure Expose iniheader. infile

   If Stream( infile, 'C', 'QUERY EXISTS' ) = '' then do
      say getentry( lang 'MissingFileText')
      exit
   end

   i = 0
   j = 0

   do while lines(infile)
      line = linein(infile)
      /*
      if header
         attach new header
      else if element
         attach new element
      */
      if line='' then iterate
      if substr(line,1,1) = ';' then iterate
      if (substr(line,1,1) = '[') & (substr(line,length(line),1) = ']') then do
         i=i+1
         iniheader.i = strip(translate(line,'  ','[]'))
         j = 0
      end
      else do
         parse value line with key '=' value
         if value <> '' then do
            value = strip(translate(value,' ','"'))
            j = j+1
            iniheader.i.element.j.tkey = key
            iniheader.i.element.j.tvalue = value
            iniheader.i.element.0 = j
         end
      end
   end
   iniheader.0 = i
   /* close file */
   call lineout(infile)

return


DumpIniFile: Procedure Expose iniheader.

do i = 1 to iniheader.0
   say iniheader.i
   do j = 1 to iniheader.i.element.0
   say '   'iniheader.i.element.j.tkey'='iniheader.i.element.j.tvalue
   end
end

return


GetEntry: Procedure expose iniheader.

parse ARG header key

do i = 1 to iniheader.0
   if header=iniheader.i then
      do j = 1 to iniheader.i.element.0
         if key =iniheader.i.element.j.tkey then
            return (iniheader.i.element.j.tvalue)
      end
end
return ('')

HALT:
  exit

