;/*************************************************************************
;*
;* SOURCE FILE NAME = DATA.ASM
;*
;* DESCRIPTIVE NAME = Device dependent DD data segment
;**************************************************************************

DSEG   	SEGMENT   WORD  PUBLIC  'DATA'
DSEG   	ENDS
CSEG   	SEGMENT   WORD  PUBLIC  'CODE'
CSEG   	ENDS
DUMMY  	SEGMENT   WORD  PUBLIC  'CODE'
DUMMY  	ENDS
DGROUP 	GROUP DSEG
CGROUP 	GROUP CSEG, DUMMY
.xlist
       	include devsym.inc
       	include dddd.inc
.list
.286c

;*
;*  External Mouse Referneces From this Module
;*

       	extrn HIDC_Entry         : near
       	extrn Strategy           : near
       	extrn Query_Config       : near
       	extrn Read_Enable        : near
       	extrn Read_Disable       : near
       	extrn Enable_Device      : near
       	extrn Disable_Device     : near


DSEG    SEGMENT

;*
;*      OS/2 Device Driver Header
;*

MouseHDR    LABEL   WORD
            DW       -1                    ; Device header pointer
            DW       -1                    ; Device header pointer
            DW       DEV_IOCTL+DEV_CHAR_DEV+DEVLEV_3 ; Device Driver attributes
            DW       Strategy              ; Strategy Routine Offset
            DW       HIDC_Entry            ; IDC entry point
            DB       'GRAPHIR$'            ; Device Name
            DW       0                     ; Protect-mode CS Strategy Selector
            DW       0                     ; Protect-mode DS selector
            DW       0                     ; Real-mode CS Strategy Segment
            DW       0                     ; Real-mode DS segment
            DD       2                     ; Can handle > 16MB physical memory

;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;              IDC function table                                          *
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

IDC_Func    dw     Query_Config
            dw     Read_Enable
            dw     Read_Disable
            dw     Enable_Device
            dw     Disable_Device

;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;                           Variables                                      *
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Device_Help dd       0                 ; Dev helper entry point
DevStatus   dw       0                 ; current device status
                                         ; High byte: reserved 0
                                         ; Low byte:
                                         ;   0000000x  Read enabled
                                         ;   000000x0  MOUSE$ attach done
                                         ;   00000x00  IRQ enabled
                                         ;   0000x000  We've been deinstalled
                                         ;   000x0000  device enabled
                                         ;   00000000
                                         ;   00000000
IntPacketOff dw     0               ; offset in Mouse DS for int data
First_Port   dw     ?               ; used to claim BIOS data area
ByteCount    dw     0               ; packet counter
pComAddr     dw     0               ; pointer to com port address


; Length, mick/cm, buttons, irq, type, com-port
DeviceData   Dev_Data  <CFGDATLEN,100,3,0,2,1>    ; !! Device data   (KD)


MseDD        Attach_DD  <>               ; mse DD Interface Data Record
msename      db     'MOUSE$  ',0         ; mouse device name for AttachDD
Disable_8259 db     ?                    ; disable IRQ level mask for the 8259
Enable_8259  db     ?                    ; enable IRQ level mask for the 8259
_ABIOS_Mch   db     0                    ; 0 = Non ABIOS machine
                                         ; 1 = ABIOS machine
;TabProc       db 'Int '
;TabMsg       db     'Tablet data >>'
;TABX         dw     0                   ; tablet X-Pos
;TABY         dw     0                   ; tablet Y-Pos
;TABB         dw     0                   ; tablet Buttons
;TABZ         dw     0                   ; tablet Pressure
TABOPT       db     0                   ; tablet status (xxxxxxPS)
             db     0AAh
OLDTABX      dw     0                   ; tablet old X-Pos
OLDTABY      dw     0                   ; tablet old Y-Pos
OLDTABB      dw     0                   ; tablet old Buttons
             db     0AAh
MEvent       db     7 dup (0)           ; interrupt data building buffer
             db    	0AAh

;* Graphire Parameters
XSIZE        dw    5103                 ; X-resolution
YSIZE        dw    3711                 ; Y-resolution
OKPRESS      dw    170                  ; Pressure level to emulate 1-button
RELA         db    00000010b            ; Relative status (xxxxxxMS)
InitMsg      db    'Graphire tablet device driver Ver.0.8 (build 03-Dec-2002)'
             db    13,10,'Product of eCo Software (c) Gleb Mazursky',13,10

; Basic WACOM Tablet Commands (all 3 bytes long!)
RESET_BAUD   db    13,'$',13
RESET_TAB    db    13,'#',13
START_TAB    db    'ST',13
STOP_TAB     db    10,'SP',13
GET_MODEL    db    '~#',13

;*
;* everything following is discarded at the end of initialization
;*
ENDDATA      EQU   $               ; end of data segment

DSEG     ENDS


;*
;*  Data Segment Variables Made Public for other Mouse Modules
;*
        public IDC_Func
        public Device_Help
        public DevStatus
        public msename
        public IntPacketOff
        public DeviceData
        public MseDD
        public ENDDATA
        public Enable_8259
        public Disable_8259
        public First_Port
        public MEvent
        public ByteCount
        public pComAddr
        public _ABIOS_Mch
        public InitMsg
;        public TabMsg

        public RESET_BAUD
        public RESET_TAB
        public START_TAB
        public STOP_TAB
        public GET_MODEL

;        public TABX
;        public TABY
;        public TABZ
;        public TABB
        public TABOPT

        public OLDTABX
        public OLDTABY
        public OLDTABB

        public XSIZE
        public YSIZE
        public OKPRESS
        public RELA
;       public TabProc

     END
