/* check NIF files */

Trace 'N'

/* get our directory */
Parse Source . . our_cmd .
our_dir = Left(our_cmd, Lastpos('\', our_cmd) - 1)
Call Directory(our_dir)

/* Load RexxUtil.DLL */
Call Rxfuncadd 'SysLoadFuncs','Rexxutil','SysLoadFuncs'
Call SysLoadFuncs
/* Load RexxIni.DLL */
Call Rxfuncadd 'IniLoadFuncs','RexxIni','IniLoadFuncs'
Call IniLoadFuncs

Parse Arg nifchk_args '|' pmrexx
pmrexx = (pmrexx <> '')
If \pmrexx Then
   Do
      /* setup to run under PMREXX */
      pmrexx_name = SysSearchPath('PATH', 'PMREXX.EXE')
      If pmrexx_name <> '' Then
         Do
            class = 'WPProgram'
            title = 'NIF Checker'
            location = '<WP_DESKTOP>'
            obj = 'OBJECTID=<NIFCHK_CMD>;'
            exec = 'EXENAME=' || pmrexx_name || ';'
            parm = 'PARAMETERS=' || our_cmd nifchk_args '| X' || ';'
            startdir = 'STARTUPDIR=' || our_dir || ';'
            window = 'MINIMIZED=YES;'
            setup = obj || exec || parm || startdir
            rc = SysCreateObject(class, title, location, setup, 'R')
            If rc Then
               Do
                  rc = SysSetObjectData('<NIFCHK_CMD>', 'OPEN=DEFAULT;CCVIEW=NO;')
                  If rc Then
                     Say 'Started NIF Checker under PMRexx'
                  Exit
               End
            Else
               Say 'Unable to start NIF Checker under PMRexx'
         End
   End

Parse Upper Var nifchk_args ibmcom_path .
/* locate \IBMCOM\MACS */
If ibmcom_path = '' Then
   Do
      ibm_com = SysSearchPath('path', 'mpts.exe')
      ibm_com = Left(ibm_com, Lastpos('\', ibm_com) - 1)
   End
Else
   ibm_com = ibmcom_path
If ibm_com <> '' Then
   ibm_macs = ibm_com || '\MACS'
Else
   Do
      Say 'Networking support does not appear to be installed on this system'
      Say 'Press enter to exit'
      Parse Pull .
      Call SysDestroyObject '<NIFCHK_CMD>'
      Return 0
   End

macs_path = Value('MACS_PATH', ibm_macs || ';', 'os2environment')
copy_path = Value('COPY_PATH', ibm_com || ';' || ibm_macs || ';', 'os2environment')

/* find all of the NIF files */
nif_path = ibm_macs || '\*.nif'
xrc = SysFileTree(nif_path, 'nifs.', 'FO')
Do i = 1 To nifs.0
   Parse Value(Find_nif(nifs.i)) With title '|' Version '|' nif_stamp
   Say 'Checking' nifs.i
   Say Strip(title) Strip(version) Strip(nif_stamp)
   Do j = 1 To driver.0
      Say Strip(driver.j)
   End
   Do j = 1 To copyfile.0
      Say Strip(copyfile.j)
   End
   Address cmd '@sniffle' nifs.i
   Say ''
End

macs_path = Value('MACS_PATH', '', 'os2environment')
copy_path = Value('COPY_PATH', '', 'os2environment')
Say 'Press enter to exit'
Parse Pull .
Call SysDestroyObject '<NIFCHK_CMD>'
Return 0

/* get info from NIF file */
Find_nif: Procedure Expose ibm_macs driver. copyfile.
save_trace = Trace('N')
Parse Arg nif_loc
version = ''
nic_stamp = ''
driver. = ''
driver.0 = 0
copyfile. = ''
copyfile.0 = 0

If IniEnumSections('hdr.', nif_loc) > 0 Then
   Do
      nif_hdr = hdr.1
      handle = IniOpen(nif_hdr, nif_loc)
      /* locate title */
      If handle > 0 Then
         title = IniGet('title', handle)
      Else
         title = ''
      If title <> '' Then
         title = 'Title = ' title
      Else
         title = 'Title = unknown'
      /* locate version */
      If handle > 0 Then
         version = IniGet('version', handle)
      Else
         version = ''
      If version <> '' Then
         version = 'Version =' version
      Else
         version = 'Version = unknown'
      /* locate copyfile */
      If handle > 0 Then
         copyfile = IniGet('copyfile', handle)
      Else
         copyfile = ''
      If copyfile <> '' Then
         Do
            copyfile_list = copyfile
            Parse Var copyfile_list copyfile ',' copyfile_list
            copyfile = Space(copyfile)
            Do While copyfile <> ''
               If Pos('\', copyfile) <> 0 Then
                  copyfile = Substr(copyfile, Lastpos('\', copyfile) + 1)
               test_copyfile = SysSearchPath('copy_path', copyfile)
               If test_copyfile <> '' Then
                  Do
                     copyfile = test_copyfile
                     copyfile_stamp = SysGetFileDateTime(copyfile, 'w')
                     j = copyfile.0 + 1
                     copyfile.j = 'Copyfile =' copyfile copyfile_stamp
                     copyfile.0 = j
                  End
               Else
                  Do
                     j = copyfile.0 + 1
                     copyfile.j = 'Copyfile =' copyfile '(not found in' Value('copy_path', , 'os2environment') || ')'
                     copyfile.0 = j
                  End
               Parse Var copyfile_list copyfile ',' copyfile_list
               copyfile = Space(copyfile)
            End
         End
      Else
         Do
            copyfile.1 = 'Copyfile = none'
            copyfile.0 = 1
         End
      /* locate driver name */
      handle = IniOpen('file' ,nif_loc)
      If handle > 0 Then
         driver = IniGet('name', handle)
      Else
         driver = ''
      If driver <> '' Then
         Do
            driver_list = driver
            Parse Var driver_list driver ',' driver_list
            driver = Space(driver)
            Do While driver <> ''
               If Pos('\', driver) <> 0 Then
                  driver = Substr(driver, Lastpos('\', driver) + 1)
               test_driver = SysSearchPath('macs_path', driver)
               If test_driver <> '' Then
                  Do
                     driver = test_driver
                     driver_stamp = SysGetFileDateTime(driver, 'w')
                     j = driver.0 + 1
                     driver.j = 'Driver =' driver driver_stamp
                     driver.0 = j
                  End
               Else
                  Do
                     j = driver.0 + 1
                     driver.j = 'driver =' driver '(not found in' Value('macs_path', , 'os2environment') || ')'
                     driver.0 = j
                  End
               Parse Var driver_list driver ',' driver_list
               driver = Space(driver)
            End
         End
      Else
         Do
            driver.1 = 'Driver = none'
            driver.0 = 1
         End
      nic_stamp = SysGetFileDateTime(nif_loc, 'w')
   End
Trace(save_trace)
Return title '|' version '|' nic_stamp
