/* CLEANPPD.CMD
 *
 * "Clean up" a PPD file by stripping out various options related to CUPS and/or
 * Foomatic which PIN can't handle.  Based on previous work by Paul Smedley and
 * Peter Brown.
 */
SIGNAL ON NOVALUE

CALL RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
CALL SysLoadFuncs

ARG ppdfile

IF ppdfile == '' THEN DO
    SAY 'CLEANPPD - Cleans up a CUPS PPD file for use with PIN.'
    SAY 'Syntax:  CLEANPPD <ppd_file>'
    RETURN 0
END
CALL CleanPPD ppdfile

RETURN 0


CleanPPD: PROCEDURE
    PARSE ARG in_ppd

    tmpdir = VALUE('TMP',,'OS2ENVIRONMENT')
    out_ppd = SysTempFileName( tmpdir'\?????.PPD')
    IF STREAM( out_ppd, 'C', 'QUERY EXISTS') \= '' THEN CALL SysFileDelete out_ppd

    SAY 'Doing cleanup on' in_ppd '...'
    /* SAY '(Using temporary file' out_ppd')' */

    CALL LINEIN in_ppd, 1, 0
    CALL LINEIN out_ppd, 1, 0
    skip_next = 0
    DO WHILE LINES( in_ppd ) \= 0
        line = LINEIN( in_ppd )
        SELECT
            WHEN skip_next == 1 THEN DO
                line = STRIP( TRANSLATE( line ))
                IF line == '*END' THEN skip_next = 0
            END
            WHEN LEFT( line, 11 ) == '*StpDefault'        THEN NOP
            WHEN LEFT( line, 7  ) == '*StpStp'            THEN NOP
            WHEN LEFT( line, 18 ) == '*StpResolutionMap:' THEN NOP
            WHEN LEFT( line, 14 ) == '*OPOptionHints'     THEN NOP
            WHEN LEFT( line, 4 ) ==  '*da.'               THEN NOP
            WHEN LEFT( line, 4 ) ==  '*de.'               THEN NOP
            WHEN LEFT( line, 4 ) ==  '*es.'               THEN NOP
            WHEN LEFT( line, 4 ) ==  '*fi.'               THEN NOP
            WHEN LEFT( line, 4 ) ==  '*fr.'               THEN NOP
            WHEN LEFT( line, 4 ) ==  '*it.'               THEN NOP
            WHEN LEFT( line, 4 ) ==  '*ja.'               THEN NOP
            WHEN LEFT( line, 4 ) ==  '*ko.'               THEN NOP
            WHEN LEFT( line, 4 ) ==  '*nb.'               THEN NOP
            WHEN LEFT( line, 4 ) ==  '*nl.'               THEN NOP
            WHEN LEFT( line, 4 ) ==  '*pt.'               THEN NOP
            WHEN LEFT( line, 4 ) ==  '*ru.'               THEN NOP
            WHEN LEFT( line, 4 ) ==  '*sv.'               THEN NOP
            WHEN LEFT( line, 4 ) ==  '*zh.'               THEN NOP
            WHEN LEFT( line, 7 ) ==  '*zh_CN.'            THEN NOP
            WHEN LEFT( line, 7 ) ==  '*zh_TW.'            THEN NOP
            WHEN LEFT( line, 9  ) == '*Foomatic'          THEN DO
                line = STRIP( line )
                IF RIGHT( line, 2 ) == '&&' THEN skip_next = 1
            END
            OTHERWISE DO
                CALL LINEOUT out_ppd, line
                skip_next = 0
            END
        END
    END
    CALL STREAM in_ppd,  'C', 'CLOSE'
    CALL STREAM out_ppd, 'C', 'CLOSE'

    '@copy' out_ppd in_ppd '>NUL'
    IF rc = 0 THEN SAY 'Updated' in_ppd'.'
    ELSE CALL SAY 'Failed to update' in_ppd'!'
    CALL SysFileDelete out_ppd

RETURN


NOVALUE:
    SAY '>>>' SOURCELINE( sigl )
    'NOVALUE on line' sigl
EXIT sigl
