/*   */
'@echo off'
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
call SysCls
env = 'OS2ENVIRONMENT'

call GetOS2DriverName
name1 = result
call GetWinDriverName name1
name2 = result

call Mainpart name1 name2
exit

Mainpart: procedure
do
Arg OS2name1 Winname1
say   "                                                          "
say   "      ͻ "
say   "                    xxx       Installation              "
say   "      ͹ "
say   "                                                        "
say   "          This script installs the   xxx      Audio     "
say   "           Driver for OS2-WARP and WIN-OS2 as well      "
say   "                                                        "
say   "      ͼ "
say   "                                                          "
say   "      ͻ "
say   "        You have to enter  'N'  at the cursor, if you   "
say   "         decide not to install the Win-OS2 driver.      "
say   "         Otherwise, you can hit ENTER to proceed.       "
say   "      ͼ "
say   "                                                          "
say   "                                                          "
say   "                                                          "
say   "      Do you want to install the WIN-OS2 driver  ----> "  Y

pos = SysCurPos(2, 21)
say OS2name1
pos = SysCurPos(5, 38)
say OS2name1

ROW = 18
COL = 56
/******************************************************************/
/**    Let's set the cursor to another position                  **/
/******************************************************************/
pos = SysCurPos(ROW,COL)

/******************************************************************/
/**    Let's read the user's selection                           **/
/******************************************************************/
pull val

/******************************************************************/
/**    Let's set the cursor to another position                  **/
/******************************************************************/
pos = SysCurPos(ROW,COL)
line = SysTextScreenRead(ROW,0,80)
line = substr(line,COL)

select
   when val="Y"
       then
         call OS2_WINDOWS Winname1 OS2name1
   when line="Y"
       then
         call OS2_WINDOWS Winname1 OS2name1
   when val="YES"
       then
         call OS2_WINDOWS Winname1 OS2name1
   when val="N"
       then
         call OS2_ONLY
   when val="NO"
       then
         call OS2_ONLY
   otherwise
         call TOOBAD
end

pos = SysCurPos(2, 21)
say drivername

/******************************************************************/
/**    Exiting with a reboot message on the screen               **/
/******************************************************************/
call SysCls
lastline =  "             xxx       Installation Completed !!        "
lastline=OVERLAY(OS2name1,lastline,14)
say   "                                                          "
say   "                                                          "
say   "                                                          "
say   "      ͻ "
say   "                                                        "
say   "      ͹ "
say   "                                                        "
say   "          Please shutdown and reboot your system for    "
say   "              the changes to take effect now.           "
say   "                                                        "
say   "      ͼ "
say   "                                                          "
say   "                                                          "
pos = SysCurPos(4,0)
say lastline
pos = SysCurPos(14,0)
return
end

/*******************************************************/
/* This routine will install the OS2 and WIN-OS2       */
/* driver for the user.                                */
/*******************************************************/
OS2_WINDOWS: procedure
do
Arg Win_file  Driver_file
call OS2_WIN
call MESSAGES_OS2
call BACKUP_FILE Driver_file
minstall.exe
pos = SysCurPos(12,5)
say "                                                             "
pos = SysCurPos(14,5)
say "   WIN-OS2 Audio Installation is about to begin..        "
call SysSleep 1
call WINSTALL Win_file
call SysSleep 1
return
end

/*******************************************************/
/* Print message for OS2 and WIN-OS2 installation      */
/*******************************************************/
OS2_WIN: procedure
do
call SysCls
say   " "
say   " "
say   " "
say   " "
say   " "
say   "      ͻ "
say   "                                                        "
say   "          OS2 and WIN-OS2 drivers will be installed     "
say   "                                                        "
say   "      ͼ "
say   "                                                          "
say   "                                                          "
say   "                                                          "
say   "                                                          "
return
end

/*******************************************************/
/* This routine will install only the OS2 driver for   */
/* the user.                                           */
/*******************************************************/
OS2_ONLY: procedure
do
ROW2=7
call OS2_WIN
pos = SysCurPos(ROW2,10)
win_value= " Only the OS2 driver will be installed    "
say win_value
call MESSAGES_OS2
call BACKUP_FILE
MINSTALL.EXE
return
end

MESSAGES_OS2: procedure
i=1
message1 = " Please wait! it will only take a minute "
message2 = " .... "
first  = ''
second = ''

do  while(i<5)
pos = SysCurPos(14,5)
strings = OVERLAY(first,message2,i+1)
full_value = strings||message1||strings
say full_value
call SysSleep 1
i=i+1
end

do  while(i<>2)
pos = SysCurPos(14,5)
strings = OVERLAY(second,message2,i-1)
full_value = strings||message1||strings
say full_value
call SysSleep 1
i=i-1
end

pos = SysCurPos(14,5)
say "   Installation of OS2 driver is about to begin..        "
return
end

/*******************************************************/
/* This routine searches for a file in OS/2 Boot drive */
/* and backs it up to *.000 if it exists. If the file  */
/* is not found, the program will exit.                */
/*******************************************************/
BACKUP_FILE: procedure
do
  Arg Driver_file1
  if (Driver_file1<>'CS4232') then return
  BootDrvSpec = SysSearchPath('PATH', 'CMD.EXE')
  OSDrvCheck  = SysSearchPath('PATH', 'OS2KRNL')

  if (BootDrvSpec = '') then
                        call NON_OS2_PARTITION_ERROR
  if (OSDrvCheck = '')  then
                        call NON_OS2_PARTITION_ERROR

  BootDrv = left(OSDrvCheck, 2)
  DrivePath= BootDrv||'\OS2\BOOT'

/*******************************************************************/
/*  Now look for the specific file RESOURCE.SYS                    */
/*******************************************************************/

  DrivePathFile=DrivePath||'\RESOURCE.SYS'
  Call SysFileTree  DrivePathFile ,'file','F'
  if (substr(file.1,50)='RESOURCE.SYS')
      then
        do
           DrivePathFile=DrivePath||'\RESOURCE.000'
           Call SysFileTree  DrivePathFile ,'file','F'
           if (substr(file.1,50)='RESOURCE.000')
               then return
               else
                 do
                    pos = SysCurPos(12,5)
                    say "    Let's Backup RESOURCE.SYS   to   RESOURCE.000            "
                    copy DrivePath||'\RESOURCE.SYS' DrivePath||'\RESOURCE.000 > NUL'
                    call DISPLAY_MOVING_BAR 3
                    pos = SysCurPos(12,5)
                    say "                                                             "
                 end
        end
return
end

/*******************************************************************/
/*  Let's read the driver's name from the control.scr file.        */
/*  The control.scr file is in the same drive the user has run     */
/*  the REXX command file ( OS2SETUP.CMD )                         */
/*******************************************************************/
GetOS2DriverName: procedure
do
 OS2_file='CONTROL.SCR'
 call SysFileTree OS2_file, checkit, 'F'
 if (checkit.0 = 0)
  then call NO_FILE_FOUND_ERROR OS2_file
   else
    do
       call SysFileSearch 'filelist=',OS2_file,'searchit.'
       parse value searchit.1 with 'filelist="' drivername '.' garbage
       return drivername
    end
end

/*******************************************************************/
/*  Let's read the windows control file of which we can find out   */
/*  the windows directory.  OS2\DRIVERS\xxxxx                      */
/*******************************************************************/
GetWinDriverName: procedure
do
 Arg   OS2_file
 OS2_file = OS2_file||'.SCR'
 call SysFileTree OS2_file, checkitt, 'F'
 if (checkitt.0 = 0)
  then call NO_FILE_FOUND_ERROR OS2_file
   else
     do
       call SysFileSearch '.CTL',OS2_file,'trouve.'
       if (trouve.0=0)
        then call NO_FILE_FOUND_ERROR OS2_file
        else parse value trouve.1 with '"' WIN_file '.' garbage
    end
return WIN_file
end


/*******************************************************/
/* This routine will let the user know the file that   */
/* it is about to backup. In our case, the file is     */
/* called RESOURCE.SYS and the backup is RESOURCE.000. */
/*******************************************************/
DISPLAY_MOVING_BAR: PROCEDURE
DO
        arg row
        base_line = 'Ĵ'
        cur       = ''
        i = 2
        do 49
          pos = SysCurPos(14, 6)
          new_line = overlay(cur, base_line, i)
          base_line = new_line
          i = i +1
          say new_line
          say '      0%                     50%                      100%'
          end /* do */
        return
END

/*******************************************************/
/* This routine will prompt the user if he/she has     */
/* not responded to the very first panel correctly.    */
/*******************************************************/
TOOBAD: procedure
do
call SysCls
say   " "
say   " "
say   " "
say   " "
say   "      ͻ "
say   "                                                        "
say   "            SORRY! your selection is invalid. Try       "
say   "          again, if you wish to install the driver.     "
say   "                                                        "
say   "      ͼ "
say   " "
say   " "
say   " "
say   " "
exit
return
end

/*******************************************************/
/* This routine will make sure that the user is aware  */
/* that his/her operating system is corrupted because  */
/* RESOURCE.SYS was not found anywhere on the system.  */
/*******************************************************/
NON_OS2_PARTITION_ERROR: procedure
do
call SysCls
say   " "
say   " "
say   " "
say   " "
say   "      ͻ "
say   "                                                               "
say   "             SORRY!                                            "
say   "             Either OS/2 is not running, or this program is    "
say   "             not running from an OS/2 Window.                  "
say   "             Please run this command from an OS/2 window.      "
say   "                                                               "
say   "      ͼ "
say   " "
say   " "
say   " "
say   " "
exit
end

/*******************************************************/
/* This routine will make sure that the user is aware  */
/* that his/her operating system is corrupted because  */
/* RESOURCE.SYS was not found anywhere on the system.  */
/*******************************************************/
NO_FILE_FOUND_ERROR: procedure
do
Arg value
mess =  "             file is not found on your          "
call SysCls
say   " "
say   " "
say   " "
say   " "
say   "      ͻ "
say   "                                                        "
say   "                                                        "
say   "                    installation disk.                  "
say   "                                                        "
say   "      ͼ "
say   " "
say   " "
say   " "
say   " "
pos = SysCurPos(6,12)
mess = OVERLAY(value,mess,1)
say mess
pos = SysCurPos(17,0)
exit
end
