/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.comm;

import com.ibm.comm.OS2ParallelPort;
import java.io.IOException;
import java.io.InputStream;

public class OS2ParallelInputStream
extends InputStream {
    private int handle;
    private OS2ParallelPort pPort;

    public OS2ParallelInputStream(OS2ParallelPort oS2ParallelPort, int n) {
        this.handle = n;
        this.pPort = oS2ParallelPort;
    }

    public int read() throws IOException {
        int n = this._ReadByteParallel(this.handle);
        if (n == -2) {
            throw new IOException();
        }
        if (n == -1) {
            this.pPort.SetNewData(true);
        } else {
            this.pPort.SetNewData(false);
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this._ReadByteArrayParallel(this.handle, byArray, 0, byArray.length);
        if (n == -2) {
            throw new IOException();
        }
        if (n == -1) {
            this.pPort.SetNewData(true);
        } else {
            this.pPort.SetNewData(false);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this._ReadByteArrayParallel(this.handle, byArray, n, n2);
        if (n3 == -2) {
            throw new IOException();
        }
        if (n3 == -1) {
            this.pPort.SetNewData(true);
        } else {
            this.pPort.SetNewData(false);
        }
        return n3;
    }

    public void close() throws IOException {
    }

    public long skip(long l) throws IOException {
        return 0L;
    }

    public synchronized void mark(int n) {
    }

    public synchronized void reset() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    private native int _ReadByteParallel(int var1);

    private native int _ReadByteArrayParallel(int var1, byte[] var2, int var3, int var4);
}

