/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SearchPath {
    private String pathString;
    private String[] pathArray;

    public SearchPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.pathString = string;
        this.pathArray = arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean isEmpty() {
        return this.pathArray.length == 0;
    }

    public String asString() {
        return this.pathString;
    }

    public String[] asArray() {
        return (String[])this.pathArray.clone();
    }

    public File resolve(String string) {
        for (int i = 0; i < this.pathArray.length; ++i) {
            File file = new File(this.pathArray[i], string);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public String[] children(String string, FilenameFilter filenameFilter) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < this.pathArray.length; ++i) {
            String[] stringArray;
            File file = new File(this.pathArray[i], string);
            if (!file.exists() || (stringArray = file.list(filenameFilter)) == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (treeSet.contains(stringArray[j])) continue;
                treeSet.add(stringArray[j]);
            }
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }
}

