/*
 * Decompiled with CFR 0.152.
 */
package com.sun.image.codec.jpeg;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.image.codec.jpeg.JPEGQTable;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class JPEGCodec {
    public static JPEGImageDecoder createJPEGDecoder(InputStream inputStream) {
        return new ImageIOJPEGImageDecoder(inputStream);
    }

    public static JPEGImageEncoder createJPEGEncoder(OutputStream outputStream) {
        return new ImageIOJPEGImageEncoder(outputStream);
    }

    public static JPEGImageDecoder createJPEGDecoder(InputStream inputStream, JPEGDecodeParam jPEGDecodeParam) {
        return new ImageIOJPEGImageDecoder(inputStream);
    }

    public static JPEGImageEncoder createJPEGEncoder(OutputStream outputStream, JPEGEncodeParam jPEGEncodeParam) {
        return new ImageIOJPEGImageEncoder(outputStream);
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(BufferedImage bufferedImage) {
        throw new UnsupportedOperationException("FIX ME!");
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(int n, int n2) {
        throw new UnsupportedOperationException("FIX ME!");
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(JPEGDecodeParam jPEGDecodeParam) {
        throw new UnsupportedOperationException("FIX ME!");
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(Raster raster, int n) {
        throw new UnsupportedOperationException("FIX ME!");
    }

    private static class ImageIOJPEGImageEncoder
    implements JPEGImageEncoder {
        private static final String JPGMime = "image/jpeg";
        private ImageWriter JPGWriter;
        private OutputStream out;
        private ImageIOJPEGEncodeParam param;

        private ImageIOJPEGImageEncoder(OutputStream outputStream) {
            this.out = outputStream;
            this.param = null;
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(JPGMime);
            if (iterator.hasNext()) {
                this.JPGWriter = iterator.next();
            }
            this.JPGWriter.setOutput(new MemoryCacheImageOutputStream(this.out));
        }

        private BufferedImage checkImage(BufferedImage bufferedImage) {
            boolean bl = false;
            int[] nArray = bufferedImage.getSampleModel().getSampleSize();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= 8) continue;
                bl = true;
                break;
            }
            if (bl) {
                BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                bufferedImage = bufferedImage2;
            }
            return bufferedImage;
        }

        public JPEGEncodeParam getJPEGEncodeParam() {
            return this.param;
        }

        public void setJPEGEncodeParam(JPEGEncodeParam jPEGEncodeParam) {
            if (!(jPEGEncodeParam instanceof ImageIOJPEGEncodeParam)) {
                throw new RuntimeException("Must specify object returned by getDefaultJPEGEncodeParam()");
            }
            this.param = (ImageIOJPEGEncodeParam)jPEGEncodeParam;
        }

        public JPEGEncodeParam getDefaultJPEGEncodeParam(BufferedImage bufferedImage) {
            return new ImageIOJPEGEncodeParam(this.JPGWriter, bufferedImage.getWidth(), bufferedImage.getHeight());
        }

        public JPEGEncodeParam getDefaultJPEGEncodeParam(Raster raster, int n) throws ImageFormatException {
            return new ImageIOJPEGEncodeParam(this.JPGWriter, raster.getWidth(), raster.getHeight());
        }

        public JPEGEncodeParam getDefaultJPEGEncodeParam(int n, int n2) throws ImageFormatException {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public JPEGEncodeParam getDefaultJPEGEncodeParam(JPEGDecodeParam jPEGDecodeParam) throws ImageFormatException {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public int getDefaultColorId(ColorModel colorModel) {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        public void encode(BufferedImage bufferedImage, JPEGEncodeParam jPEGEncodeParam) throws IOException, ImageFormatException {
            if (!(jPEGEncodeParam instanceof ImageIOJPEGEncodeParam)) {
                throw new RuntimeException("Must specify object returned by getDefaultJPEGEncodeParam()");
            }
            bufferedImage = this.checkImage(bufferedImage);
            this.JPGWriter.write(null, new IIOImage(bufferedImage, null, null), ((ImageIOJPEGEncodeParam)jPEGEncodeParam).getImageWriteParam());
        }

        public void encode(Raster raster) throws IOException, ImageFormatException {
            this.JPGWriter.write(null, new IIOImage(raster, null, null), this.param.getImageWriteParam());
        }

        public void encode(BufferedImage bufferedImage) throws IOException, ImageFormatException {
            bufferedImage = this.checkImage(bufferedImage);
            this.JPGWriter.write(null, new IIOImage(bufferedImage, null, null), this.param.getImageWriteParam());
        }

        public void encode(Raster raster, JPEGEncodeParam jPEGEncodeParam) throws IOException, ImageFormatException {
            if (!(jPEGEncodeParam instanceof ImageIOJPEGEncodeParam)) {
                throw new RuntimeException("Must specify object returned by getDefaultJPEGEncodeParam()");
            }
            this.JPGWriter.write(null, new IIOImage(raster, null, null), ((ImageIOJPEGEncodeParam)jPEGEncodeParam).getImageWriteParam());
        }
    }

    private static class ImageIOJPEGEncodeParam
    implements JPEGEncodeParam {
        private ImageWriter writer;
        private ImageWriteParam p;
        private int width;
        private int height;

        private ImageIOJPEGEncodeParam(ImageWriter imageWriter, int n, int n2) {
            this.writer = imageWriter;
            this.p = imageWriter.getDefaultWriteParam();
            this.width = n;
            this.height = n2;
        }

        private ImageWriteParam getImageWriteParam() {
            return this.p;
        }

        public void setQuality(float f, boolean bl) {
            this.p.setCompressionMode(2);
            this.p.setCompressionQuality(f);
        }

        public JPEGEncodeParam clone() {
            return new ImageIOJPEGEncodeParam(this.writer, this.width, this.height);
        }

        public void setTableInfoValid(boolean bl) {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public void setImageInfoValid(boolean bl) {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public int getHorizontalSubsampling(int n) {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public int getVerticalSubsampling(int n) {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getDensityUnit() {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public int getXDensity() {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public int getYDensity() {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public int getRestartInterval() {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public JPEGQTable getQTable(int n) {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public void setDensityUnit(int n) {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public void setXDensity(int n) {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public void setYDensity(int n) {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public void setRestartInterval(int n) {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public void setQTable(int n, JPEGQTable jPEGQTable) {
            throw new UnsupportedOperationException("FIX ME!");
        }
    }

    private static class ImageIOJPEGImageDecoder
    implements JPEGImageDecoder {
        private static final String JPGMime = "image/jpeg";
        private ImageReader JPGReader;
        private InputStream in;

        private ImageIOJPEGImageDecoder(InputStream inputStream) {
            this.in = inputStream;
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByMIMEType(JPGMime);
            if (iterator.hasNext()) {
                this.JPGReader = iterator.next();
            }
            this.JPGReader.setInput(new MemoryCacheImageInputStream(this.in));
        }

        public BufferedImage decodeAsBufferedImage() throws IOException, ImageFormatException {
            return this.JPGReader.read(0);
        }

        public Raster decodeAsRaster() throws IOException, ImageFormatException {
            return this.JPGReader.readRaster(0, null);
        }

        public InputStream getInputStream() {
            return this.in;
        }

        public JPEGDecodeParam getJPEGDecodeParam() {
            throw new UnsupportedOperationException("FIX ME!");
        }

        public void setJPEGDecodeParam(JPEGDecodeParam jPEGDecodeParam) {
            throw new UnsupportedOperationException("FIX ME!");
        }
    }
}

