/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.InetAddress;
import java.net.InetAddressContainer;
import java.net.SocketException;
import java.net.SocketImpl;

class TwoStacksPlainSocketImpl
extends AbstractPlainSocketImpl {
    private FileDescriptor fd1;
    private InetAddress anyLocalBoundAddr = null;
    private int lastfd = -1;

    public TwoStacksPlainSocketImpl() {
    }

    public TwoStacksPlainSocketImpl(FileDescriptor fileDescriptor) {
        this.fd = fileDescriptor;
    }

    protected synchronized void create(boolean bl) throws IOException {
        this.fd1 = new FileDescriptor();
        super.create(bl);
    }

    protected synchronized void bind(InetAddress inetAddress, int n) throws IOException {
        super.bind(inetAddress, n);
        if (inetAddress.isAnyLocalAddress()) {
            this.anyLocalBoundAddr = inetAddress;
        }
    }

    public Object getOption(int n) throws SocketException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        if (n == 15) {
            if (this.fd != null && this.fd1 != null) {
                return this.anyLocalBoundAddr;
            }
            InetAddressContainer inetAddressContainer = new InetAddressContainer();
            this.socketGetOption(n, inetAddressContainer);
            return inetAddressContainer.addr;
        }
        return super.getOption(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() throws IOException {
        Object object = this.fdLock;
        synchronized (object) {
            if (this.fd != null || this.fd1 != null) {
                if (this.fdUseCount == 0) {
                    if (this.closePending) {
                        return;
                    }
                    this.closePending = true;
                    this.socketClose();
                    this.fd = null;
                    this.fd1 = null;
                    return;
                }
                if (!this.closePending) {
                    this.closePending = true;
                    --this.fdUseCount;
                    this.socketClose();
                }
            }
        }
    }

    void reset() throws IOException {
        if (this.fd != null || this.fd1 != null) {
            this.socketClose();
        }
        this.fd = null;
        this.fd1 = null;
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosedOrPending() {
        Object object = this.fdLock;
        synchronized (object) {
            return this.closePending || this.fd == null && this.fd1 == null;
            {
            }
        }
    }

    static native void initProto();

    native void socketCreate(boolean var1) throws IOException;

    native void socketConnect(InetAddress var1, int var2, int var3) throws IOException;

    native void socketBind(InetAddress var1, int var2) throws IOException;

    native void socketListen(int var1) throws IOException;

    native void socketAccept(SocketImpl var1) throws IOException;

    native int socketAvailable() throws IOException;

    native void socketClose0(boolean var1) throws IOException;

    native void socketShutdown(int var1) throws IOException;

    native void socketSetOption(int var1, boolean var2, Object var3) throws SocketException;

    native int socketGetOption(int var1, Object var2) throws SocketException;

    native int socketGetOption1(int var1, Object var2, FileDescriptor var3) throws SocketException;

    native void socketSendUrgentData(int var1) throws IOException;

    static {
        TwoStacksPlainSocketImpl.initProto();
    }
}

