/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ClientPropertyKey;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.Popup;
import javax.swing.RootPaneContainer;
import javax.swing.SwingHeavyWeight;
import javax.swing.SwingUtilities;

public class PopupFactory {
    private static final Object SharedInstanceKey = new Object();
    private static final int MAX_CACHE_SIZE = 5;
    static final int LIGHT_WEIGHT_POPUP = 0;
    static final int MEDIUM_WEIGHT_POPUP = 1;
    static final int HEAVY_WEIGHT_POPUP = 2;
    private int popupType = 0;

    public static void setSharedInstance(PopupFactory popupFactory) {
        if (popupFactory == null) {
            throw new IllegalArgumentException("PopupFactory can not be null");
        }
        SwingUtilities.appContextPut(SharedInstanceKey, popupFactory);
    }

    public static PopupFactory getSharedInstance() {
        PopupFactory popupFactory = (PopupFactory)SwingUtilities.appContextGet(SharedInstanceKey);
        if (popupFactory == null) {
            popupFactory = new PopupFactory();
            PopupFactory.setSharedInstance(popupFactory);
        }
        return popupFactory;
    }

    void setPopupType(int n) {
        this.popupType = n;
    }

    int getPopupType() {
        return this.popupType;
    }

    public Popup getPopup(Component component, Component component2, int n, int n2) throws IllegalArgumentException {
        if (component2 == null) {
            throw new IllegalArgumentException("Popup.getPopup must be passed non-null contents");
        }
        int n3 = this.getPopupType(component, component2, n, n2);
        Popup popup = this.getPopup(component, component2, n, n2, n3);
        if (popup == null) {
            popup = this.getPopup(component, component2, n, n2, 2);
        }
        return popup;
    }

    private int getPopupType(Component component, Component component2, int n, int n2) {
        int n3 = this.getPopupType();
        if (component == null || this.invokerInHeavyWeightPopup(component)) {
            n3 = 2;
        } else if (n3 == 0 && !(component2 instanceof JToolTip) && !(component2 instanceof JPopupMenu)) {
            n3 = 1;
        }
        for (Component component3 = component; component3 != null; component3 = component3.getParent()) {
            if (!(component3 instanceof JComponent) || ((JComponent)component3).getClientProperty((Object)ClientPropertyKey.PopupFactory_FORCE_HEAVYWEIGHT_POPUP) != Boolean.TRUE) continue;
            n3 = 2;
            break;
        }
        return n3;
    }

    private Popup getPopup(Component component, Component component2, int n, int n2, int n3) {
        if (GraphicsEnvironment.isHeadless()) {
            return this.getHeadlessPopup(component, component2, n, n2);
        }
        switch (n3) {
            case 0: {
                return this.getLightWeightPopup(component, component2, n, n2);
            }
            case 1: {
                return this.getMediumWeightPopup(component, component2, n, n2);
            }
            case 2: {
                return this.getHeavyWeightPopup(component, component2, n, n2);
            }
        }
        return null;
    }

    private Popup getHeadlessPopup(Component component, Component component2, int n, int n2) {
        return HeadlessPopup.getHeadlessPopup(component, component2, n, n2);
    }

    private Popup getLightWeightPopup(Component component, Component component2, int n, int n2) {
        return LightWeightPopup.getLightWeightPopup(component, component2, n, n2);
    }

    private Popup getMediumWeightPopup(Component component, Component component2, int n, int n2) {
        return MediumWeightPopup.getMediumWeightPopup(component, component2, n, n2);
    }

    private Popup getHeavyWeightPopup(Component component, Component component2, int n, int n2) {
        if (GraphicsEnvironment.isHeadless()) {
            return this.getMediumWeightPopup(component, component2, n, n2);
        }
        return HeavyWeightPopup.getHeavyWeightPopup(component, component2, n, n2);
    }

    private boolean invokerInHeavyWeightPopup(Component component) {
        if (component != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof Popup.HeavyWeightWindow)) continue;
                return true;
            }
        }
        return false;
    }

    private static class MediumWeightPopup
    extends ContainerPopup {
        private static final Object mediumWeightPopupCacheKey = new Object();
        private JRootPane rootPane;

        private MediumWeightPopup() {
        }

        static Popup getMediumWeightPopup(Component component, Component component2, int n, int n2) {
            MediumWeightPopup mediumWeightPopup = MediumWeightPopup.getRecycledMediumWeightPopup();
            if (mediumWeightPopup == null) {
                mediumWeightPopup = new MediumWeightPopup();
            }
            mediumWeightPopup.reset(component, component2, n, n2);
            if (!mediumWeightPopup.fitsOnScreen() || mediumWeightPopup.overlappedByOwnedWindow()) {
                mediumWeightPopup.hide();
                return null;
            }
            return mediumWeightPopup;
        }

        private static List getMediumWeightPopupCache() {
            ArrayList arrayList = (ArrayList)SwingUtilities.appContextGet(mediumWeightPopupCacheKey);
            if (arrayList == null) {
                arrayList = new ArrayList();
                SwingUtilities.appContextPut(mediumWeightPopupCacheKey, arrayList);
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void recycleMediumWeightPopup(MediumWeightPopup mediumWeightPopup) {
            Class<MediumWeightPopup> clazz = MediumWeightPopup.class;
            synchronized (MediumWeightPopup.class) {
                List list = MediumWeightPopup.getMediumWeightPopupCache();
                if (list.size() < 5) {
                    list.add(mediumWeightPopup);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static MediumWeightPopup getRecycledMediumWeightPopup() {
            Class<MediumWeightPopup> clazz = MediumWeightPopup.class;
            synchronized (MediumWeightPopup.class) {
                List list = MediumWeightPopup.getMediumWeightPopupCache();
                int n = list.size();
                if (n > 0) {
                    MediumWeightPopup mediumWeightPopup = (MediumWeightPopup)list.get(0);
                    list.remove(0);
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return mediumWeightPopup;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
        }

        public void hide() {
            super.hide();
            this.rootPane.getContentPane().removeAll();
            MediumWeightPopup.recycleMediumWeightPopup(this);
        }

        public void show() {
            Component component = this.getComponent();
            Container container = null;
            if (this.owner != null) {
                container = this.owner.getParent();
            }
            while (!(container instanceof Window) && !(container instanceof Applet) && container != null) {
                container = container.getParent();
            }
            if (container instanceof RootPaneContainer) {
                container = ((RootPaneContainer)((Object)container)).getLayeredPane();
                Point point = SwingUtilities.convertScreenLocationToParent(container, this.x, this.y);
                component.setVisible(false);
                component.setLocation(point.x, point.y);
                ((JLayeredPane)container).add(component, JLayeredPane.POPUP_LAYER, 0);
            } else {
                Point point = SwingUtilities.convertScreenLocationToParent(container, this.x, this.y);
                component.setLocation(point.x, point.y);
                component.setVisible(false);
                container.add(component);
            }
            component.setVisible(true);
        }

        Component createComponent(Component component) {
            MediumWeightComponent mediumWeightComponent = new MediumWeightComponent();
            this.rootPane = new JRootPane();
            this.rootPane.setOpaque(true);
            mediumWeightComponent.add((Component)this.rootPane, "Center");
            return mediumWeightComponent;
        }

        void reset(Component component, Component component2, int n, int n2) {
            super.reset(component, component2, n, n2);
            Component component3 = this.getComponent();
            component3.setLocation(n, n2);
            this.rootPane.getContentPane().add(component2, "Center");
            component2.invalidate();
            component3.validate();
            this.pack();
        }

        private static class MediumWeightComponent
        extends Panel
        implements SwingHeavyWeight {
            MediumWeightComponent() {
                super(new BorderLayout());
            }
        }
    }

    private static class LightWeightPopup
    extends ContainerPopup {
        private static final Object lightWeightPopupCacheKey = new Object();

        private LightWeightPopup() {
        }

        static Popup getLightWeightPopup(Component component, Component component2, int n, int n2) {
            LightWeightPopup lightWeightPopup = LightWeightPopup.getRecycledLightWeightPopup();
            if (lightWeightPopup == null) {
                lightWeightPopup = new LightWeightPopup();
            }
            lightWeightPopup.reset(component, component2, n, n2);
            if (!lightWeightPopup.fitsOnScreen() || lightWeightPopup.overlappedByOwnedWindow()) {
                lightWeightPopup.hide();
                return null;
            }
            return lightWeightPopup;
        }

        private static List getLightWeightPopupCache() {
            ArrayList arrayList = (ArrayList)SwingUtilities.appContextGet(lightWeightPopupCacheKey);
            if (arrayList == null) {
                arrayList = new ArrayList();
                SwingUtilities.appContextPut(lightWeightPopupCacheKey, arrayList);
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void recycleLightWeightPopup(LightWeightPopup lightWeightPopup) {
            Class<LightWeightPopup> clazz = LightWeightPopup.class;
            synchronized (LightWeightPopup.class) {
                List list = LightWeightPopup.getLightWeightPopupCache();
                if (list.size() < 5) {
                    list.add(lightWeightPopup);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static LightWeightPopup getRecycledLightWeightPopup() {
            Class<LightWeightPopup> clazz = LightWeightPopup.class;
            synchronized (LightWeightPopup.class) {
                List list = LightWeightPopup.getLightWeightPopupCache();
                int n = list.size();
                if (n > 0) {
                    LightWeightPopup lightWeightPopup = (LightWeightPopup)list.get(0);
                    list.remove(0);
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return lightWeightPopup;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
        }

        public void hide() {
            super.hide();
            Container container = (Container)this.getComponent();
            container.removeAll();
            LightWeightPopup.recycleLightWeightPopup(this);
        }

        public void show() {
            Serializable serializable;
            Serializable serializable2 = null;
            if (this.owner != null) {
                serializable2 = this.owner instanceof Container ? (Container)this.owner : this.owner.getParent();
            }
            for (serializable = serializable2; serializable != null; serializable = ((Component)serializable).getParent()) {
                if (serializable instanceof JRootPane) {
                    if (((Component)serializable).getParent() instanceof JInternalFrame) continue;
                    serializable2 = ((JRootPane)serializable).getLayeredPane();
                    continue;
                }
                if (serializable instanceof Window) {
                    if (serializable2 != null) break;
                    serializable2 = serializable;
                    break;
                }
                if (serializable instanceof JApplet) break;
            }
            serializable = SwingUtilities.convertScreenLocationToParent((Container)serializable2, this.x, this.y);
            Component component = this.getComponent();
            component.setLocation(((Point)serializable).x, ((Point)serializable).y);
            if (serializable2 instanceof JLayeredPane) {
                ((JLayeredPane)serializable2).add(component, JLayeredPane.POPUP_LAYER, 0);
            } else {
                ((Container)serializable2).add(component);
            }
        }

        Component createComponent(Component component) {
            JPanel jPanel = new JPanel(new BorderLayout(), true);
            jPanel.setOpaque(true);
            return jPanel;
        }

        void reset(Component component, Component component2, int n, int n2) {
            super.reset(component, component2, n, n2);
            JComponent jComponent = (JComponent)this.getComponent();
            jComponent.setOpaque(component2.isOpaque());
            jComponent.setLocation(n, n2);
            jComponent.add(component2, "Center");
            component2.invalidate();
            this.pack();
        }
    }

    private static class HeadlessPopup
    extends ContainerPopup {
        private HeadlessPopup() {
        }

        static Popup getHeadlessPopup(Component component, Component component2, int n, int n2) {
            HeadlessPopup headlessPopup = new HeadlessPopup();
            headlessPopup.reset(component, component2, n, n2);
            return headlessPopup;
        }

        Component createComponent(Component component) {
            return new Panel(new BorderLayout());
        }

        public void show() {
        }

        public void hide() {
        }
    }

    private static class ContainerPopup
    extends Popup {
        Component owner;
        int x;
        int y;

        private ContainerPopup() {
        }

        public void hide() {
            Container container;
            Component component = this.getComponent();
            if (component != null && (container = component.getParent()) != null) {
                Rectangle rectangle = component.getBounds();
                container.remove(component);
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.owner = null;
        }

        public void pack() {
            Component component = this.getComponent();
            if (component != null) {
                component.setSize(component.getPreferredSize());
            }
        }

        void reset(Component component, Component component2, int n, int n2) {
            if (component instanceof JFrame || component instanceof JDialog || component instanceof JWindow) {
                component = ((RootPaneContainer)((Object)component)).getLayeredPane();
            }
            super.reset(component, component2, n, n2);
            this.x = n;
            this.y = n2;
            this.owner = component;
        }

        boolean overlappedByOwnedWindow() {
            Component component = this.getComponent();
            if (this.owner != null && component != null) {
                Window window = SwingUtilities.getWindowAncestor(this.owner);
                if (window == null) {
                    return false;
                }
                Window[] windowArray = window.getOwnedWindows();
                if (windowArray != null) {
                    Rectangle rectangle = component.getBounds();
                    for (int i = 0; i < windowArray.length; ++i) {
                        Window window2 = windowArray[i];
                        if (!window2.isVisible() || !rectangle.intersects(window2.getBounds())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        boolean fitsOnScreen() {
            Component component = this.getComponent();
            if (this.owner != null && component != null) {
                int n = component.getWidth();
                int n2 = component.getHeight();
                for (Container container = this.owner.getParent(); container != null; container = container.getParent()) {
                    if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                        Rectangle rectangle = container.getBounds();
                        Insets insets = container.getInsets();
                        rectangle.x += insets.left;
                        rectangle.y += insets.top;
                        rectangle.width -= insets.left + insets.right;
                        rectangle.height -= insets.top + insets.bottom;
                        GraphicsConfiguration graphicsConfiguration = container.getGraphicsConfiguration();
                        Rectangle rectangle2 = this.getContainerPopupArea(graphicsConfiguration);
                        return rectangle.intersection(rectangle2).contains(this.x, this.y, n, n2);
                    }
                    if (container instanceof JApplet) {
                        Rectangle rectangle = container.getBounds();
                        Point point = container.getLocationOnScreen();
                        rectangle.x = point.x;
                        rectangle.y = point.y;
                        return rectangle.contains(this.x, this.y, n, n2);
                    }
                    if (container instanceof Window || container instanceof Applet) break;
                }
            }
            return false;
        }

        Rectangle getContainerPopupArea(GraphicsConfiguration graphicsConfiguration) {
            Insets insets;
            Rectangle rectangle;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (graphicsConfiguration != null) {
                rectangle = graphicsConfiguration.getBounds();
                insets = toolkit.getScreenInsets(graphicsConfiguration);
            } else {
                rectangle = new Rectangle(toolkit.getScreenSize());
                insets = new Insets(0, 0, 0, 0);
            }
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            return rectangle;
        }
    }

    private static class HeavyWeightPopup
    extends Popup {
        private static final Object heavyWeightPopupCacheKey = new Object();

        private HeavyWeightPopup() {
        }

        static Popup getHeavyWeightPopup(Component component, Component component2, int n, int n2) {
            Container container;
            Window window = component != null ? SwingUtilities.getWindowAncestor(component) : null;
            HeavyWeightPopup heavyWeightPopup = null;
            if (window != null) {
                heavyWeightPopup = HeavyWeightPopup.getRecycledHeavyWeightPopup(window);
            }
            boolean bl = false;
            if (component2 != null && component2.isFocusable() && component2 instanceof JPopupMenu) {
                container = (JPopupMenu)component2;
                Component[] componentArray = container.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    if (componentArray[i] instanceof MenuElement || componentArray[i] instanceof JSeparator) continue;
                    bl = true;
                    break;
                }
            }
            if (heavyWeightPopup == null || ((JWindow)heavyWeightPopup.getComponent()).getFocusableWindowState() != bl) {
                if (heavyWeightPopup != null) {
                    heavyWeightPopup._dispose();
                }
                heavyWeightPopup = new HeavyWeightPopup();
            }
            heavyWeightPopup.reset(component, component2, n, n2);
            if (bl) {
                container = (JWindow)heavyWeightPopup.getComponent();
                ((Window)container).setFocusableWindowState(true);
                container.setName("###focusableSwingPopup###");
            }
            return heavyWeightPopup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static HeavyWeightPopup getRecycledHeavyWeightPopup(Window window) {
            Class<HeavyWeightPopup> clazz = HeavyWeightPopup.class;
            synchronized (HeavyWeightPopup.class) {
                Map map = HeavyWeightPopup.getHeavyWeightPopupCache();
                if (!map.containsKey(window)) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                List list = (List)map.get(window);
                int n = list.size();
                if (n > 0) {
                    HeavyWeightPopup heavyWeightPopup = (HeavyWeightPopup)list.get(0);
                    list.remove(0);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return heavyWeightPopup;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Map getHeavyWeightPopupCache() {
            Class<HeavyWeightPopup> clazz = HeavyWeightPopup.class;
            synchronized (HeavyWeightPopup.class) {
                HashMap hashMap = (HashMap)SwingUtilities.appContextGet(heavyWeightPopupCacheKey);
                if (hashMap == null) {
                    hashMap = new HashMap(2);
                    SwingUtilities.appContextPut(heavyWeightPopupCacheKey, hashMap);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return hashMap;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void recycleHeavyWeightPopup(HeavyWeightPopup heavyWeightPopup) {
            Class<HeavyWeightPopup> clazz = HeavyWeightPopup.class;
            synchronized (HeavyWeightPopup.class) {
                List<HeavyWeightPopup> list;
                Window window = SwingUtilities.getWindowAncestor(heavyWeightPopup.getComponent());
                Map map = HeavyWeightPopup.getHeavyWeightPopupCache();
                if (window instanceof Popup.DefaultFrame || !window.isVisible()) {
                    heavyWeightPopup._dispose();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (map.containsKey(window)) {
                    list = (List)map.get(window);
                } else {
                    list = new ArrayList();
                    map.put(window, list);
                    final Window window2 = window;
                    window2.addWindowListener(new WindowAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void windowClosed(WindowEvent windowEvent) {
                            Class<HeavyWeightPopup> clazz = HeavyWeightPopup.class;
                            synchronized (HeavyWeightPopup.class) {
                                Map map = HeavyWeightPopup.getHeavyWeightPopupCache();
                                List list = (List)map.remove(window2);
                                // ** MonitorExit[var3_2] (shouldn't be in output)
                                if (list != null) {
                                    for (int i = list.size() - 1; i >= 0; --i) {
                                        ((HeavyWeightPopup)list.get(i))._dispose();
                                    }
                                }
                                return;
                            }
                        }
                    });
                }
                if (list.size() < 5) {
                    list.add(heavyWeightPopup);
                } else {
                    heavyWeightPopup._dispose();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public void hide() {
            super.hide();
            HeavyWeightPopup.recycleHeavyWeightPopup(this);
        }

        void dispose() {
        }

        void _dispose() {
            super.dispose();
        }
    }
}

