/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html.parser;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.DocumentParser;
import javax.swing.text.html.parser.ResourceLoader;
import sun.awt.AppContext;

public class ParserDelegator
extends HTMLEditorKit.Parser
implements Serializable {
    private static final Object DTD_KEY = new Object();

    protected static synchronized void setDefaultDTD() {
        AppContext appContext = AppContext.getAppContext();
        DTD dTD = (DTD)appContext.get(DTD_KEY);
        if (dTD == null) {
            DTD dTD2 = null;
            String string = "html32";
            try {
                dTD2 = DTD.getDTD(string);
            }
            catch (IOException iOException) {
                System.out.println("Throw an exception: could not get default dtd: " + string);
            }
            dTD = ParserDelegator.createDTD(dTD2, string);
            appContext.put(DTD_KEY, dTD);
        }
    }

    protected static DTD createDTD(DTD dTD, String string) {
        InputStream inputStream = null;
        boolean bl = true;
        try {
            String string2 = string + ".bdtd";
            inputStream = ParserDelegator.getResourceAsStream(string2);
            if (inputStream != null) {
                dTD.read(new DataInputStream(new BufferedInputStream(inputStream)));
                DTD.putDTDHash(string, dTD);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return dTD;
    }

    public ParserDelegator() {
        ParserDelegator.setDefaultDTD();
    }

    @Override
    public void parse(Reader reader, HTMLEditorKit.ParserCallback parserCallback, boolean bl) throws IOException {
        new DocumentParser((DTD)AppContext.getAppContext().get(DTD_KEY)).parse(reader, parserCallback, bl);
    }

    static InputStream getResourceAsStream(String string) {
        try {
            return ResourceLoader.getResourceAsStream(string);
        }
        catch (Throwable throwable) {
            return ParserDelegator.class.getResourceAsStream(string);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        ParserDelegator.setDefaultDTD();
    }
}

