/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sun.awt.OSInfo;
import sun.awt.shell.ShellFolder;
import sun.awt.shell.ShellFolderManager;
import sun.awt.shell.Win32ShellFolder2;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public class Win32ShellFolderManager2
extends ShellFolderManager {
    private static Win32ShellFolder2 desktop;
    private static Win32ShellFolder2 drives;
    private static Win32ShellFolder2 recent;
    private static Win32ShellFolder2 network;
    private static Win32ShellFolder2 personal;
    private static String osVersion;
    private static final boolean useShell32Icons;
    private static File[] roots;
    private Comparator driveComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            Win32ShellFolder2 win32ShellFolder2 = (Win32ShellFolder2)object;
            Win32ShellFolder2 win32ShellFolder22 = (Win32ShellFolder2)object2;
            boolean bl = win32ShellFolder2.getPath().endsWith(":\\");
            if (bl ^ win32ShellFolder22.getPath().endsWith(":\\")) {
                return bl ? -1 : 1;
            }
            return win32ShellFolder2.getPath().compareTo(win32ShellFolder22.getPath());
        }
    };
    private static List topFolderList;
    private Comparator fileComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return this.compare((File)object, (File)object2);
        }

        public int compare(File file, File file2) {
            return Win32ShellFolderManager2.compareFiles(file, file2);
        }
    };

    public ShellFolder createShellFolder(File file) throws FileNotFoundException {
        return Win32ShellFolderManager2.createShellFolder(Win32ShellFolderManager2.getDesktop(), file);
    }

    static Win32ShellFolder2 createShellFolder(Win32ShellFolder2 win32ShellFolder2, File file) throws FileNotFoundException {
        long l;
        try {
            l = win32ShellFolder2.parseDisplayName(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            l = 0L;
        }
        if (l == 0L) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " not found");
        }
        Win32ShellFolder2 win32ShellFolder22 = Win32ShellFolderManager2.createShellFolderFromRelativePIDL(win32ShellFolder2, l);
        Win32ShellFolder2.releasePIDL(l);
        return win32ShellFolder22;
    }

    static Win32ShellFolder2 createShellFolderFromRelativePIDL(Win32ShellFolder2 win32ShellFolder2, long l) {
        long l2;
        while (l != 0L && (l2 = Win32ShellFolder2.copyFirstPIDLEntry(l)) != 0L) {
            win32ShellFolder2 = new Win32ShellFolder2(win32ShellFolder2, l2);
            l = Win32ShellFolder2.getNextPIDLEntry(l);
        }
        return win32ShellFolder2;
    }

    static Win32ShellFolder2 getDesktop() {
        if (desktop == null) {
            try {
                desktop = new Win32ShellFolder2(0);
            }
            catch (IOException iOException) {
                desktop = null;
            }
        }
        return desktop;
    }

    static Win32ShellFolder2 getDrives() {
        if (drives == null) {
            try {
                drives = new Win32ShellFolder2(17);
            }
            catch (IOException iOException) {
                drives = null;
            }
        }
        return drives;
    }

    static Win32ShellFolder2 getRecent() {
        if (recent == null) {
            try {
                String string = Win32ShellFolder2.getFileSystemPath(8);
                if (string != null) {
                    recent = Win32ShellFolderManager2.createShellFolder(Win32ShellFolderManager2.getDesktop(), new File(string));
                }
            }
            catch (IOException iOException) {
                recent = null;
            }
        }
        return recent;
    }

    static Win32ShellFolder2 getNetwork() {
        if (network == null) {
            try {
                network = new Win32ShellFolder2(18);
            }
            catch (IOException iOException) {
                network = null;
            }
        }
        return network;
    }

    static Win32ShellFolder2 getPersonal() {
        if (personal == null) {
            try {
                String string = Win32ShellFolder2.getFileSystemPath(5);
                if (string != null) {
                    Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDesktop();
                    personal = win32ShellFolder2.getChildByPath(string);
                    if (personal == null) {
                        personal = Win32ShellFolderManager2.createShellFolder(Win32ShellFolderManager2.getDesktop(), new File(string));
                    }
                    if (personal != null) {
                        personal.setIsPersonal();
                    }
                }
            }
            catch (IOException iOException) {
                personal = null;
            }
        }
        return personal;
    }

    public Object get(String string) {
        if (string.equals("fileChooserDefaultFolder")) {
            Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getPersonal();
            if (win32ShellFolder2 == null) {
                win32ShellFolder2 = Win32ShellFolderManager2.getDesktop();
            }
            return win32ShellFolder2;
        }
        if (string.equals("roots")) {
            if (roots == null) {
                Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDesktop();
                roots = win32ShellFolder2 != null ? new File[]{win32ShellFolder2} : (File[])super.get(string);
            }
            return roots;
        }
        if (string.equals("fileChooserComboBoxFolders")) {
            Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDesktop();
            if (win32ShellFolder2 != null) {
                ArrayList<File> arrayList = new ArrayList<File>();
                Win32ShellFolder2 win32ShellFolder22 = Win32ShellFolderManager2.getDrives();
                Win32ShellFolder2 win32ShellFolder23 = Win32ShellFolderManager2.getRecent();
                if (win32ShellFolder23 != null && OSInfo.getWindowsVersion().compareTo(OSInfo.WINDOWS_2000) >= 0) {
                    arrayList.add(win32ShellFolder23);
                }
                arrayList.add(win32ShellFolder2);
                Object[] objectArray = win32ShellFolder2.listFiles();
                Arrays.sort(objectArray);
                for (Object object : objectArray) {
                    File[] fileArray;
                    Win32ShellFolder2 win32ShellFolder24 = (Win32ShellFolder2)object;
                    if (win32ShellFolder24.isFileSystem() && !win32ShellFolder24.isDirectory()) continue;
                    arrayList.add(win32ShellFolder24);
                    if (!win32ShellFolder24.equals(win32ShellFolder22) || (fileArray = win32ShellFolder24.listFiles()) == null) continue;
                    Arrays.sort(fileArray, this.driveComparator);
                    for (File file : fileArray) {
                        arrayList.add(file);
                    }
                }
                return arrayList.toArray(new File[arrayList.size()]);
            }
            return super.get(string);
        }
        if (string.equals("fileChooserShortcutPanelFolders")) {
            Object object;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ArrayList<File> arrayList = new ArrayList<File>();
            int n = 0;
            do {
                object = toolkit.getDesktopProperty("win.comdlg.placesBarPlace" + n++);
                try {
                    if (object instanceof Integer) {
                        arrayList.add(new Win32ShellFolder2((Integer)object));
                        continue;
                    }
                    if (!(object instanceof String)) continue;
                    arrayList.add(this.createShellFolder(new File((String)object)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            } while (object != null);
            if (arrayList.size() == 0) {
                for (File file : new File[]{Win32ShellFolderManager2.getRecent(), Win32ShellFolderManager2.getDesktop(), Win32ShellFolderManager2.getPersonal(), Win32ShellFolderManager2.getDrives(), Win32ShellFolderManager2.getNetwork()}) {
                    if (file == null) continue;
                    arrayList.add(file);
                }
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }
        if (string.startsWith("fileChooserIcon ")) {
            int n;
            block38: {
                n = -1;
                String string2 = string.substring(string.indexOf(" ") + 1);
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (string2.equals("ListView")) {
                        n = useShell32Icons ? 21 : 2;
                    }
                    if (string2.equals("DetailsView")) {
                        n = useShell32Icons ? 23 : 3;
                    }
                    if (string2.equals("UpFolder")) {
                        n = useShell32Icons ? 28 : 8;
                    }
                    if (string2.equals("NewFolder")) {
                        n = useShell32Icons ? 31 : 11;
                    }
                    if (!string2.equals("ViewMenu")) break block38;
                    int n2 = n = useShell32Icons ? 21 : 2;
                }
            }
            if (n >= 0) {
                return Win32ShellFolder2.getFileChooserIcon(n);
            }
        } else {
            if (string.startsWith("optionPaneIcon ")) {
                Win32ShellFolder2.SystemIcon systemIcon;
                if (string == "optionPaneIcon Error") {
                    systemIcon = Win32ShellFolder2.SystemIcon.IDI_ERROR;
                } else if (string == "optionPaneIcon Information") {
                    systemIcon = Win32ShellFolder2.SystemIcon.IDI_INFORMATION;
                } else if (string == "optionPaneIcon Question") {
                    systemIcon = Win32ShellFolder2.SystemIcon.IDI_QUESTION;
                } else if (string == "optionPaneIcon Warning") {
                    systemIcon = Win32ShellFolder2.SystemIcon.IDI_EXCLAMATION;
                } else {
                    return null;
                }
                return Win32ShellFolder2.getSystemIcon(systemIcon);
            }
            if (string.startsWith("shell32Icon ")) {
                String string3 = string.substring(string.indexOf(" ") + 1);
                try {
                    int n = Integer.parseInt(string3);
                    if (n >= 0) {
                        return Win32ShellFolder2.getShell32Icon(n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public boolean isComputerNode(File file) {
        if (file != null && file == Win32ShellFolderManager2.getDrives()) {
            return true;
        }
        String string = file.getAbsolutePath();
        return string.startsWith("\\\\") && string.indexOf("\\", 2) < 0;
    }

    public boolean isFileSystemRoot(File file) {
        if (file != null) {
            Object object;
            Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDrives();
            if (file instanceof Win32ShellFolder2) {
                object = (Win32ShellFolder2)file;
                if (((Win32ShellFolder2)object).isFileSystem()) {
                    if (((Win32ShellFolder2)object).parent != null) {
                        return ((Win32ShellFolder2)object).parent.equals(win32ShellFolder2);
                    }
                } else {
                    return false;
                }
            }
            return ((String)(object = file.getPath())).length() == 3 && ((String)object).charAt(1) == ':' && Arrays.asList(win32ShellFolder2.listFiles()).contains(file);
        }
        return false;
    }

    public void sortFiles(List list) {
        Collections.sort(list, this.fileComparator);
    }

    static int compareShellFolders(Win32ShellFolder2 win32ShellFolder2, Win32ShellFolder2 win32ShellFolder22) {
        boolean bl = win32ShellFolder2.isSpecial();
        boolean bl2 = win32ShellFolder22.isSpecial();
        if (bl || bl2) {
            if (topFolderList == null) {
                ArrayList<Win32ShellFolder2> arrayList = new ArrayList<Win32ShellFolder2>();
                arrayList.add(Win32ShellFolderManager2.getPersonal());
                arrayList.add(Win32ShellFolderManager2.getDesktop());
                arrayList.add(Win32ShellFolderManager2.getDrives());
                arrayList.add(Win32ShellFolderManager2.getNetwork());
                topFolderList = arrayList;
            }
            int n = topFolderList.indexOf(win32ShellFolder2);
            int n2 = topFolderList.indexOf(win32ShellFolder22);
            if (n >= 0 && n2 >= 0) {
                return n - n2;
            }
            if (n >= 0) {
                return -1;
            }
            if (n2 >= 0) {
                return 1;
            }
        }
        if (bl && !bl2) {
            return -1;
        }
        if (bl2 && !bl) {
            return 1;
        }
        return Win32ShellFolderManager2.compareNames(win32ShellFolder2.getAbsolutePath(), win32ShellFolder22.getAbsolutePath());
    }

    static int compareFiles(File file, File file2) {
        if (file instanceof Win32ShellFolder2) {
            return file.compareTo(file2);
        }
        if (file2 instanceof Win32ShellFolder2) {
            return -1 * file2.compareTo(file);
        }
        return Win32ShellFolderManager2.compareNames(file.getName(), file2.getName());
    }

    static int compareNames(String string, String string2) {
        int n = string.toLowerCase().compareTo(string2.toLowerCase());
        if (n != 0) {
            return n;
        }
        return string.compareTo(string2);
    }

    static {
        boolean bl = AccessController.doPrivileged(new GetPropertyAction("os.name")).startsWith("OS/2");
        AccessController.doPrivileged(new LoadLibraryAction(bl ? "jawtos2" : "awt"));
        osVersion = System.getProperty("os.version");
        useShell32Icons = osVersion != null && osVersion.compareTo("5.1") >= 0;
        topFolderList = null;
    }
}

