/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import sun.awt.ComponentAccessor;
import sun.awt.EmbeddedFrame;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.windows.WEmbeddedFramePeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;

public class WEmbeddedFrame
extends EmbeddedFrame {
    private long handle;
    private int bandWidth = 0;
    private int bandHeight = 0;
    private int imgWid = 0;
    private int imgHgt = 0;
    private static final int MAX_BAND_SIZE = 30720;

    public WEmbeddedFrame() {
        this(0L);
    }

    @Deprecated
    public WEmbeddedFrame(int n) {
        this((long)n);
    }

    public WEmbeddedFrame(long l) {
        this.handle = l;
        if (l != 0L) {
            this.addNotify();
            this.show();
        }
    }

    public void addNotify() {
        if (this.getPeer() == null) {
            WToolkit wToolkit = (WToolkit)Toolkit.getDefaultToolkit();
            this.setPeer(wToolkit.createEmbeddedFrame(this));
        }
        super.addNotify();
    }

    public long getEmbedderHandle() {
        return this.handle;
    }

    void print(long l) {
        BufferedImage bufferedImage = null;
        int n = 1;
        int n2 = 1;
        if (this.isPrinterDC(l)) {
            n = 4;
            n2 = 4;
        }
        int n3 = this.getHeight();
        if (bufferedImage == null) {
            this.bandWidth = this.getWidth();
            if (this.bandWidth % 4 != 0) {
                this.bandWidth += 4 - this.bandWidth % 4;
            }
            if (this.bandWidth <= 0) {
                return;
            }
            this.bandHeight = Math.min(30720 / this.bandWidth, n3);
            this.imgWid = this.bandWidth * n;
            this.imgHgt = this.bandHeight * n2;
            bufferedImage = new BufferedImage(this.imgWid, this.imgHgt, 5);
        }
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.white);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.translate(0, this.imgHgt);
        graphics2D.scale(n, -n2);
        ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)bufferedImage.getRaster();
        byte[] byArray = byteInterleavedRaster.getDataStorage();
        for (int i = 0; i < n3; i += this.bandHeight) {
            graphics.fillRect(0, 0, this.bandWidth, this.bandHeight);
            this.printComponents(graphics2D);
            int n4 = 0;
            int n5 = this.bandHeight;
            int n6 = this.imgHgt;
            if (i + this.bandHeight > n3) {
                n5 = n3 - i;
                n6 = n5 * n2;
                n4 = this.imgWid * (this.imgHgt - n6) * 3;
            }
            this.printBand(l, byArray, n4, 0, 0, this.imgWid, n6, 0, i, this.bandWidth, n5);
            graphics2D.translate(0, -this.bandHeight);
        }
    }

    protected native boolean isPrinterDC(long var1);

    protected native void printBand(long var1, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    private static native void initIDs();

    public void activateEmbeddingTopLevel() {
    }

    public void synthesizeWindowActivation(boolean bl) {
        ((WEmbeddedFramePeer)this.getPeer()).synthesizeWmActivate(bl);
    }

    public void registerAccelerator(AWTKeyStroke aWTKeyStroke) {
    }

    public void unregisterAccelerator(AWTKeyStroke aWTKeyStroke) {
    }

    public void notifyModalBlocked(Dialog dialog, boolean bl) {
        try {
            this.notifyModalBlockedImpl((WEmbeddedFramePeer)ComponentAccessor.getPeer(this), (WWindowPeer)ComponentAccessor.getPeer(dialog), bl);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    native void notifyModalBlockedImpl(WEmbeddedFramePeer var1, WWindowPeer var2, boolean var3);

    static {
        WEmbeddedFrame.initIDs();
    }
}

