/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import sun.management.ManagementFactory;
import sun.management.MemoryImpl;
import sun.management.Sensor;

class MemoryPoolImpl
implements MemoryPoolMXBean {
    private final String name;
    private final boolean isHeap;
    private final boolean isValid;
    private final boolean collectionThresholdSupported;
    private final boolean usageThresholdSupported;
    private MemoryManagerMXBean[] managers;
    private long usageThreshold;
    private long collectionThreshold;
    private boolean usageSensorRegistered;
    private boolean gcSensorRegistered;
    private Sensor usageSensor;
    private Sensor gcSensor;

    MemoryPoolImpl(String string, boolean bl, long l, long l2) {
        this.name = string;
        this.isHeap = bl;
        this.isValid = true;
        this.managers = null;
        this.usageThreshold = l;
        this.collectionThreshold = l2;
        this.usageThresholdSupported = l >= 0L;
        this.collectionThresholdSupported = l2 >= 0L;
        this.usageSensor = new PoolSensor(this, string + " usage sensor");
        this.gcSensor = new CollectionSensor(this, string + " collection sensor");
        this.usageSensorRegistered = false;
        this.gcSensorRegistered = false;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public MemoryType getType() {
        if (this.isHeap) {
            return MemoryType.HEAP;
        }
        return MemoryType.NON_HEAP;
    }

    public MemoryUsage getUsage() {
        return this.getUsage0();
    }

    public synchronized MemoryUsage getPeakUsage() {
        return this.getPeakUsage0();
    }

    public synchronized long getUsageThreshold() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException("Usage threshold is not supported");
        }
        return this.usageThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsageThreshold(long l) {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException("Usage threshold is not supported");
        }
        ManagementFactory.checkControlAccess();
        MemoryUsage memoryUsage = this.getUsage0();
        if (l < 0L) {
            throw new IllegalArgumentException("Invalid threshold: " + l);
        }
        if (memoryUsage.getMax() != -1L && l > memoryUsage.getMax()) {
            throw new IllegalArgumentException("Invalid threshold: " + l + " must be <= maxSize." + " Committed = " + memoryUsage.getCommitted() + " Max = " + memoryUsage.getMax());
        }
        MemoryPoolImpl memoryPoolImpl = this;
        synchronized (memoryPoolImpl) {
            if (!this.usageSensorRegistered) {
                this.usageSensorRegistered = true;
                this.setPoolUsageSensor(this.usageSensor);
            }
            this.setUsageThreshold0(this.usageThreshold, l);
            this.usageThreshold = l;
        }
    }

    private synchronized MemoryManagerMXBean[] getMemoryManagers() {
        if (this.managers == null) {
            this.managers = this.getMemoryManagers0();
        }
        return this.managers;
    }

    public String[] getMemoryManagerNames() {
        MemoryManagerMXBean[] memoryManagerMXBeanArray = this.getMemoryManagers();
        String[] stringArray = new String[memoryManagerMXBeanArray.length];
        for (int i = 0; i < memoryManagerMXBeanArray.length; ++i) {
            stringArray[i] = memoryManagerMXBeanArray[i].getName();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetPeakUsage() {
        ManagementFactory.checkControlAccess();
        MemoryPoolImpl memoryPoolImpl = this;
        synchronized (memoryPoolImpl) {
            this.resetPeakUsage0();
        }
    }

    public boolean isUsageThresholdExceeded() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException("Usage threshold is not supported");
        }
        if (this.usageThreshold == 0L) {
            return false;
        }
        MemoryUsage memoryUsage = this.getUsage0();
        return memoryUsage.getUsed() >= this.usageThreshold || this.usageSensor.isOn();
    }

    public long getUsageThresholdCount() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException("Usage threshold is not supported");
        }
        return this.usageSensor.getCount();
    }

    public boolean isUsageThresholdSupported() {
        return this.usageThresholdSupported;
    }

    public synchronized long getCollectionUsageThreshold() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException("CollectionUsage threshold is not supported");
        }
        return this.collectionThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCollectionUsageThreshold(long l) {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException("CollectionUsage threshold is not supported");
        }
        ManagementFactory.checkControlAccess();
        MemoryUsage memoryUsage = this.getUsage0();
        if (l < 0L) {
            throw new IllegalArgumentException("Invalid threshold: " + l);
        }
        if (memoryUsage.getMax() != -1L && l > memoryUsage.getMax()) {
            throw new IllegalArgumentException("Invalid threshold: " + l + " > max (" + memoryUsage.getMax() + ").");
        }
        MemoryPoolImpl memoryPoolImpl = this;
        synchronized (memoryPoolImpl) {
            if (!this.gcSensorRegistered) {
                this.gcSensorRegistered = true;
                this.setPoolCollectionSensor(this.gcSensor);
            }
            this.setCollectionThreshold0(this.collectionThreshold, l);
            this.collectionThreshold = l;
        }
    }

    public boolean isCollectionUsageThresholdExceeded() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException("CollectionUsage threshold is not supported");
        }
        if (this.collectionThreshold == 0L) {
            return false;
        }
        MemoryUsage memoryUsage = this.getCollectionUsage0();
        return this.gcSensor.isOn() || memoryUsage != null && memoryUsage.getUsed() >= this.collectionThreshold;
    }

    public long getCollectionUsageThresholdCount() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException("CollectionUsage threshold is not supported");
        }
        return this.gcSensor.getCount();
    }

    public MemoryUsage getCollectionUsage() {
        return this.getCollectionUsage0();
    }

    public boolean isCollectionUsageThresholdSupported() {
        return this.collectionThresholdSupported;
    }

    private native MemoryUsage getUsage0();

    private native MemoryUsage getPeakUsage0();

    private native MemoryUsage getCollectionUsage0();

    private native void setUsageThreshold0(long var1, long var3);

    private native void setCollectionThreshold0(long var1, long var3);

    private native void resetPeakUsage0();

    private native MemoryManagerMXBean[] getMemoryManagers0();

    private native void setPoolUsageSensor(Sensor var1);

    private native void setPoolCollectionSensor(Sensor var1);

    class CollectionSensor
    extends Sensor {
        MemoryPoolImpl pool;

        CollectionSensor(MemoryPoolImpl memoryPoolImpl2, String string) {
            super(string);
            this.pool = memoryPoolImpl2;
        }

        void triggerAction(MemoryUsage memoryUsage) {
            MemoryImpl.createNotification("java.management.memory.collection.threshold.exceeded", this.pool.getName(), memoryUsage, MemoryPoolImpl.this.gcSensor.getCount());
        }

        void triggerAction() {
            throw new InternalError();
        }

        void clearAction() {
        }
    }

    class PoolSensor
    extends Sensor {
        MemoryPoolImpl pool;

        PoolSensor(MemoryPoolImpl memoryPoolImpl2, String string) {
            super(string);
            this.pool = memoryPoolImpl2;
        }

        void triggerAction(MemoryUsage memoryUsage) {
            MemoryImpl.createNotification("java.management.memory.threshold.exceeded", this.pool.getName(), memoryUsage, this.getCount());
        }

        void triggerAction() {
            throw new InternalError();
        }

        void clearAction() {
        }
    }
}

