// Diafragm Max/2 Monitor
// Config file read and parse module
// 08/07/94 Wouter Cloetens		readcfg() start
// 02/08/94 Wouter Cloetens		readcfg() finished, getentry() start
// (c) 1994 The Amoeba Crew

// config file syntax:
//  A valid entry consists of a line with a alpha character as the first
//  non-space character. The first contiguous string is the entry name.
//  The name is case-independant.
//  The entry value is a contiguous string starting from the first non-space
//  character after the name. If nothing follows the entry name, the entry
//  value is empty string. Matched double quotes (") can be used to embed
//  the entry value to allow spaces within the value. Any double quotes
//  occuring in the string must be escaped by doubling them (use "" instead
//  of ").


#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define LINELEN 	255		// max. linelength in configfile
#define MERROR { perror("Memory allocation error scanning config file"); exit(1); }

typedef struct entry			// entry: linked list with name & value
{
	char *name;
	char *value;
	void *next;
} entry;

entry *entrytop;			// top of linked list of entries

// ****************************************
// Preprocess config file: read all entries
// ****************************************

void readcfg(char *fname)
{
 FILE *cfg;
 entry *ent, *oldent;
 char buf[LINELEN], *p, *q;
 int i;
 short flag;

// Open config file ---------------------------------------------------------
 if((cfg=fopen(fname,"r"))==NULL)
 {
	perror("Cannot open config file");
	exit(1);
 }

// Extract all valid entries ------------------------------------------------
 entrytop = oldent = NULL;
 while(!feof(cfg))
 {
	// read line
	fgets(buf, sizeof(buf), cfg);

	// isolate entry name and convert to lower case
	p = buf;
	while(isspace(*p) && *p)
		p++;
	if(!isalpha(*p))
		continue;
	q = p;
	while(isgraph(*q))
	{
		*q = tolower(*q);
		q++;
	}

	// create new entry
	if((ent = (entry *)malloc(sizeof(entry))) == NULL)
		MERROR;
	if(oldent != NULL)
		oldent->next = ent;
	oldent = ent;
	if(entrytop == NULL)
		entrytop = ent;
	ent->next = NULL;

	// fill out name of entry
	if((ent->name = (char *)malloc(q-p+1)) == NULL)
		MERROR;
	strncpy(ent->name, p, q-p);

	// scan for entry value
	p = q;
	while(isspace(*p) && *p) 
		p++;
	if(!(*p))
	{
		ent->value = '\0';
		continue;
	}
	if(flag = (*p == '"'))
		q = ++p;
	else
		q = p;
	while((flag || !isspace(*q)) && *q)
	{
		if(flag && (*q == '"'))
			if(*(q + 1) == '"')
				strcpy(q, q + 1);
			else
				break;
		q++;
	}

	// fill out value of entry
	if((ent->value = (char *)malloc(q-p+1)) == NULL)
		MERROR;
	strncpy(ent->value, p, q-p);
 }

// End ----------------------------------------------------------------------
 fclose(cfg);
}

// *****************************************
// Process linked list: seek specified entry
// *****************************************

char *getentry(char *ename)
{
  entry *p;
  p = entrytop;
  while(p != NULL)
  {
	if(!strcmp(p->name, ename))
		break;
	p = p->next;
  }
  if(p == NULL)
	return NULL;
  else
	return p->value;
  
}
