/* TarFront installation */

parse arg path language

if (path='' | language='' | \(language='e' | language='d')) then do
  say 'Usage: install <target-directory> <language>'
  say '<language> may be d (German) or e (English).'
  say 'Example: install c:\TarFront e'
  say ''
  say 'Aufruf: install <zielverzeichnis> <sprache>'
  say '<sprache> kann entweder d (Deutsch) oder e (Englisch) sein.'
  say 'Beispiel: install c:\TarFront d'
  exit
end

do while (right(path,1)='\')
  path=left(path,length(path)-1)
end

if (language='d') then do
  copying='Kopiere Dateien nach "'path'".'
  installing='Installiere WPS-Objekte.'
  foldernotok='TarFront-Ordner nicht installiert.'
  everythingok1='Fertig. Zum Starten bitte "TarFront.exe <INI-Datei>" oder'
  everythingok2='die WPS-Objekte verwenden.'
  tarfrontdoc='TarFront Dokumentation'
  langlong='tfn_deut'
  say 'Leider ist die Online-Dokumentation, im Gegensatz zum restlichen Programm,'
  say 'noch nicht eingedeutscht.'
  say ''
end

if (language='e') then do
  copying='Copying files to "'path'".'
  installing='Installing WPS objects.'
  foldernotok='TarFront Folder not installed.'
  everythingok1='Installation OK. To run TarFront, use "TarFront.exe <INI file>" or'
  everythingok2='the WPS objects.'
  tarfrontdoc='TarFront Documentation'
  langlong='tfn_engl'
end

Say copying

'@xcopy TarFront.exe 'path'\ > nul'
curdir=directory()
neudir=directory(path)
call directory(curdir)
path=neudir
'@xcopy TarFront.inf 'path'\ > nul'
'@xcopy TarFront.ico 'path'\ > nul'
'@xcopy TarFront.hlp 'path'\ > nul'
'@xcopy tfn_Note.dll 'path'\ > nul'
'@xcopy tfn_deut.dll 'path'\ > nul'
'@xcopy tfn_dir.dll 'path'\ > nul'
'@xcopy tfn_engl.dll 'path'\ > nul'
'@xcopy tfn_fram.dll 'path'\ > nul'
'@xcopy tfn_misc.dll 'path'\ > nul'
'@xcopy tfn_runt.dll 'path'\ > nul'
'@xcopy cppoor3u.dll 'path'\ > nul'
'@copy 'langlong'.dll 'path'\tfn_reso.dll > nul'

tarfrontver='TarFront 2.3'
folder='<TarFront23_Folder>'
assoctype='TarFront 2.3'
template='TarFront.tfn'
exe='EXENAME='path'\TarFront.exe;STARTUPDIR='path';ASSOCFILTER=*.tfn;ASSOCTYPE='assoctype
view=path'\TarFront.inf'
icon=path'\TarFront.ico'

Say installing

call RxFuncAdd "SysLoadFuncs", "rexxutil", "SysLoadFuncs"
call SysLoadFuncs
 
if (\(SysCreateObject("WPFolder",tarfrontver,"<WP_DESKTOP>",,
                      "OBJECTID="folder,"update")))
then do
  say foldernotok
  exit
end
 
if (SysCreateObject("WPProgram",tarfrontver,folder,exe,"update") &,
    SysCreateObject("WPProgram",tarfrontdoc,folder,,
                    "EXENAME=view.exe;PARAMETERS="path"\TarFront.inf","update") &,
    SysCreateObject("WPDataFile",template,folder,"TEMPLATE=yes;TYPE="assoctype,"update"))
then do
  say everythingok1
  say everythingok2
  exit
end

say foldernotok
exit
 

