// Delphi interface unit for UnRAR.dll
// Translated from unrar.h
// Use Delphi 2.0 and higher to compile this module
//
// Ported to Delphi by Eugene Kotlyarov, fidonet: 2:5058/26.9 ek@oris.ru
// Fixed version by Alexey Torgashin <alextp@mail.ru>, 2:5020/604.24@fidonet
//
// Revisions:
// Aug 2001 - changed call convention for TChangeVolProc and TProcessDataProc
//          - added RARGetDllVersion function, see comment below
//
// Jan 2002 - Added RARSetCallback  // eugene
//
// Oct 2002 - Added RARHeaderDataEx, RAROpenArchiveDataEx // eugene
//
// 02.02.03 - converted for VPascal for OS/2 // dixie

unit UnRAR;

interface
{&OrgName+,PureInt+,StdCall+}
{$L unrar.lib}

uses os2def;

type THandle = LHandle;

const
  ERAR_END_ARCHIVE    = 10;
  ERAR_NO_MEMORY      = 11;
  ERAR_BAD_DATA       = 12;
  ERAR_BAD_ARCHIVE    = 13;
  ERAR_UNKNOWN_FORMAT = 14;
  ERAR_EOPEN          = 15;
  ERAR_ECREATE        = 16;
  ERAR_ECLOSE         = 17;
  ERAR_EREAD          = 18;
  ERAR_EWRITE         = 19;
  ERAR_SMALL_BUF      = 20;
  ERAR_UNKNOWN        = 21;

  RAR_OM_LIST         =  0;
  RAR_OM_EXTRACT      =  1;

  RAR_SKIP            =  0;
  RAR_TEST            =  1;
  RAR_EXTRACT         =  2;

  RAR_VOL_ASK         =  0;
  RAR_VOL_NOTIFY      =  1;

  RAR_DLL_VERSION     =  3;

  UCM_CHANGEVOLUME    =  0;
  UCM_PROCESSDATA     =  1;
  UCM_NEEDPASSWORD    =  2;

type
  RARHeaderData = packed record
    ArcName: packed array[0..Pred(260)] of Char;
    FileName: packed array[0..Pred(260)] of Char;
    Flags: ULONG;
    PackSize: ULONG;
    UnpSize: ULONG;
    HostOS: ULONG;
    FileCRC: ULONG;
    FileTime: ULONG;
    UnpVer: ULONG;
    Method: ULONG;
    FileAttr: ULONG;
    CmtBuf: PChar;
    CmtBufSize: ULONG;
    CmtSize: ULONG;
    CmtState: ULONG;
  end;

  RARHeaderDataEx = packed record
    ArcName: packed array [0..1023] of char;
    ArcNameW: packed array [0..1023] of USHORT;
    FileName: packed array [0..1023] of char;
    FileNameW: packed array [0..1023] of USHORT;
    Flags: ULONG;
    PackSize: ULONG;
    PackSizeHigh: ULONG;
    UnpSize: ULONG;
    UnpSizeHigh: ULONG;
    HostOS: ULONG;
    FileCRC: ULONG;
    FileTime: ULONG;
    UnpVer: ULONG;
    Method: ULONG;
    FileAttr: ULONG;
    CmtBuf: PChar;
    CmtBufSize: ULONG;
    CmtSize: ULONG;
    CmtState: ULONG;
    Reserved: packed array [0..1023] of ULONG;
  end;

  RAROpenArchiveData = packed record
    ArcName: PChar;
    OpenMode: ULONG;
    OpenResult: ULONG;
    CmtBuf: PChar;
    CmtBufSize: ULONG;
    CmtSize: ULONG;
    CmtState: ULONG;
  end;

  RAROpenArchiveDataEx = packed record
    ArcName: PChar;
    ArcNameW: PUSHORT;
    OpenMode: ULONG;
    OpenResult: ULONG;
    CmtBuf: PChar;
    CmtBufSize: ULONG;
    CmtSize: ULONG;
    CmtState: ULONG;
    Flags: ULONG;
    Reserved: packed array [0..31] of ULONG;
  end;

  TUnrarCallback = function (Msg: LongInt; UserData, P1, P2: Integer) :Integer;

function RAROpenArchive(var ArchiveData: RAROpenArchiveData): THandle;
  cdecl;
function RAROpenArchiveEx(var ArchiveData: RAROpenArchiveDataEx): THandle;
  cdecl;
function RARCloseArchive(hArcData: THandle): Integer;
  cdecl;
function RARReadHeader(hArcData: THandle; var HeaderData: RARHeaderData): Integer;
  cdecl;
function RARReadHeaderEx(hArcData: THandle; var HeaderData: RARHeaderDataEx): Integer;
  cdecl;
function RARProcessFile(hArcData: THandle; Operation: Integer; DestPath, DestName: PChar): Integer;
  cdecl;
procedure RARSetCallback(hArcData: THandle; UnrarCallback: TUnrarCallback; UserData: Integer);
  cdecl;
procedure RARSetPassword(hArcData: THandle; Password: PChar);
  cdecl;

{&Cdecl+}
// obsolete functions
type
  TChangeVolProc = function(ArcName: PChar; Mode: Integer): Integer;
  TProcessDataProc = function(Addr: PChar; Size: Integer): Integer;
{&Stdcall+}

procedure RARSetChangeVolProc(hArcData: THandle; ChangeVolProc: TChangeVolProc);
  cdecl;
procedure RARSetProcessDataProc(hArcData: THandle; ProcessDataProc: TProcessDataProc);
  cdecl;
function RARGetDllVersion: integer;
  cdecl;

implementation
end.
