/* eZIP / eRAR installation script v.07 */

if rxfuncquery('SysLoadFuncs') then do
 call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs
end

/* Get curent directory */
InstDir = directory()

say
say "Enter icon style number (1) Warp3 (2) Warp4 (3) eCs and hit enter:"
say "(enter only one number, e.g. '3' without quotes)"
pull iconstyle
iconstyle = left(iconstyle, 1)

/* select os specific icon */
Select
 when iconstyle = 3 then do
        address cmd "@copy" instdir||'\icons\eCseZip.ico' instdir||'\icons\Zip.ico'
        address cmd "@copy" instdir||'\icons\eCseRAR.ico' instdir||'\icons\RAR.ico'
        end
 when iconstyle = 1 then do
        address cmd "@copy" instdir||'\icons\W3eZip.ico' instdir||'\icons\Zip.ico'
        address cmd "@copy" instdir||'\icons\W3eRAR.ico' instdir||'\icons\RAR.ico'
        end
 when iconstyle = 2 then do
        address cmd "@copy" instdir||'\icons\W4eZip.ico' instdir||'\icons\Zip.ico'
        address cmd "@copy" instdir||'\icons\W4eRAR.ico' instdir||'\icons\RAR.ico'
        end
 otherwise do
        say "Invalid input. Using eCs icon style..."
        address cmd "@copy" instdir||'\icons\eCseZip.ico' instdir||'\icons\Zip.ico'
        address cmd "@copy" instdir||'\icons\eCseRAR.ico' instdir||'\icons\RAR.ico'
        end
end

eZipico=instdir||'\icons\Zip.ico'
eRARico=instdir||'\icons\RAR.ico'
eLZHico=instdir||'\icons\lha.ico'
eARJico=instdir||'\icons\arj.ico'

say "Creating WPS objects..."

Call SysCreateObject 'WPFolder', 'eZIP', '<WP_DESKTOP>', 'OBJECTID=<eZIPFOLDER>', 'Update'
call SysSleep 1
Call SysCreateObject 'WPProgram', 'eZIP', '<eZIPFOLDER>', 'OBJECTID=<ezipexe>;EXENAME='||InstDir||'\eZIP.exe;STARTUPDIR='||InstDir||';ICONFILE='||eZipico||';PROGTYPE=PM', 'Update'
Call SysCreateObject 'WPProgram', 'eRAR', '<eZIPFOLDER>', 'OBJECTID=<erarexe>;EXENAME='||InstDir||'\eZIP.exe;STARTUPDIR='||InstDir||';ICONFILE='||eRARico||';PROGTYPE=PM', 'Update'
Call SysCreateObject 'WPProgram', 'eLZH', '<eZIPFOLDER>', 'OBJECTID=<elzhexe>;EXENAME='||InstDir||'\eZIP.exe;STARTUPDIR='||InstDir||';ICONFILE='||eLZHico||';PROGTYPE=PM', 'Update'
Call SysCreateObject 'WPProgram', 'eARJ', '<eZIPFOLDER>', 'OBJECTID=<earjexe>;EXENAME='||InstDir||'\eZIP.exe;STARTUPDIR='||InstDir||';ICONFILE='||earjico||';PROGTYPE=PM', 'Update'
Call SysCreateObject 'WPProgram', 'e7z',  '<eZIPFOLDER>', 'OBJECTID=<e7zexe>;EXENAME='||InstDir||'\eZIP.exe;STARTUPDIR='||InstDir||';ICONFILE='||eZipico||';PROGTYPE=PM', 'Update'

Call SysCreateObject 'WPProgram', 'Extract to ..', '<eZIPFOLDER>', 'OBJECTID=<eunzipexe>;EXENAME='||InstDir||'\eZIP.exe;PARAMETERS=/UNZIP;STARTUPDIR='||InstDir||';ICONFILE='||eZipico||';PROGTYPE=PM', 'Update'
Call SysCreateObject 'WPProgram', 'ReadMe', '<eZIPFOLDER>', 'OBJECTID=<ezipreadme>;EXENAME=e.exe;STARTUPDIR='||InstDir||';PROGTYPE=PM;PARAMETERS=readme.txt', 'Update'
Call SysCreateObject 'WPUrl', 'eZIP homepage', '<eZIPFOLDER>', 'OBJECTID=<eZIPwww>;URL=http://www.subsys.de/eZIP/', 'Update'

Call SysCreateObject 'WPProgram', 'Support', '<eZIPFOLDER>', 'OBJECTID=<ezipsupport>;EXENAME=e.exe;STARTUPDIR='||InstDir||';PROGTYPE=PM;PARAMETERS=support.txt', 'Update'

ziptemplate = instdir'\empty.zip'
Call SysCopyObject ziptemplate, "<eZIPFOLDER>"
rartemplate = instdir'\empty.rar'
Call SysCopyObject rartemplate, "<eZIPFOLDER>"
lzhtemplate = instdir'\empty.lzh'
Call SysCopyObject lzhtemplate, "<eZIPFOLDER>"
arjtemplate = instdir'\empty.arj'
Call SysCopyObject arjtemplate, "<eZIPFOLDER>"
e7ztemplate = instdir'\empty.7z'
Call SysCopyObject e7ztemplate, "<eZIPFOLDER>"


say "...done."; say

say "Creating icons..."
BootDrive = substr( value( "RUNWORKPLACE",, "OS2ENVIRONMENT" ),1,2 )
ICONDLL =   BootDrive || "\OS2\DLL\PMWP.DLL"
ICONPATH = InstDir||'\icons'

rc=SysCreateObject( 'WPDataFile' , 'cmd.ico' , ICONPATH , 'ICONRESOURCE=2,'ICONDLL || ';', "U" )
rc=SysCreateObject( 'WPDataFile' , 'exe.ico' , ICONPATH , 'ICONRESOURCE=3,'ICONDLL || ';', "U" )
rc=SysCreateObject( 'WPDataFile' , 'locdrv.ico' , ICONPATH , 'ICONRESOURCE=13,'ICONDLL || ';', "U" )
/* rc=SysCreateObject( 'WPDataFile' , 'netdrv.ico' , ICONPATH , 'ICONRESOURCE=16,'ICONDLL || ';', "U" )*/
/* rc=SysCreateObject( 'WPDataFile' , 'cdrdrv.ico' , ICONPATH , 'ICONRESOURCE=19,'ICONDLL || ';', "U" )*/
/* rc=SysCreateObject( 'WPDataFile' , 'unknown.ico' , ICONPATH , 'ICONRESOURCE=24,'ICONDLL || ';', "U" )*/
rc=SysCreateObject( 'WPDataFile' , 'folder.ico' , ICONPATH , 'ICONRESOURCE=26,'ICONDLL || ';', "U" )
rc=SysCreateObject( 'WPDataFile' , 'flpdrv.ico' , ICONPATH , 'ICONRESOURCE=32,'ICONDLL || ';', "U" )
rc=SysCreateObject( 'WPDataFile' , 'com.ico' , ICONPATH , 'ICONRESOURCE= 46'ICONDLL || ';', "U" )
/*rc=SysCreateObject( 'WPDataFile' , 'desktop.ico' , ICONPATH , 'ICONRESOURCE=56,'ICONDLL || ';', "U" )*/

say "...done."; say

say "Creating associations..."
say
address cmd '@DEFASSOC F *.ZIP "<eunzipexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *ZIP  "<eunzipexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *.ZIP "<ezipexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *ZIP  "<ezipexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *.RAR "<eunzipexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *RAR  "<eunzipexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *.RAR "<erarexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *RAR  "<erarexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *.LZH "<eunzipexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *LZH  "<eunzipexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *.LZH "<elzhexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *LZH  "<elzhexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *.ARJ "<eunzipexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *ARJ  "<eunzipexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *.ARJ "<earjexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *ARJ  "<earjexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *.7Z  "<e7zexe>" 2>&1 >nul'
address cmd '@DEFASSOC F *7Z   "<e7zexe>" 2>&1 >nul'
say
say "...done. eZIP is now the default association"
say "         Extract to .. is now the secondary association"; say

/* installation of eZIP Tree - XWP addon */

if SysIni("USER","XWorkplace","XFolderPath") >< 'ERROR:' then do
say
say "XWP or eWPS (eCs 1.1 or later) detected..."
say 'Install a "eZIP Tree" feature to the context menu of all folders?'
say "Type [Y]es or [N]o and hit enter:"
say "(enter only one char, e.g. 'Y' without quotes)"
pull XWPkontextmenu
XWPkontextmenu = left(XWPkontextmenu, 1)
if translate(XWPkontextmenu)='Y' then do
        say "Creating menu object..."
        Call SysCreateObject 'WPProgram', 'eZIP Tree', '<XWP_CONFIG>', 'OBJECTID=<eziptreeexe>;EXENAME='||InstDir||'\eZIPTree.exe;ICONFILE='||ico||';PROGTYPE=PM', 'Update'
        say "...done."
        end
else say "Invalid input."
end

say "Installation is done. Hit enter to leave."
pull dummy
call SysOpenObject "<eZIPFOLDER>", '0', 'TRUE'
