/* IMANRX.CMD: Rexx-Untersttzung fr iNFOMAN (c) 1.0 / Dr. W. Sperber 10'95*/
/* Wird durch INFOMAN.CMD bei einem  V-, S-, bzw. SR-Lauf aufgerufen,
   nachdem VIEW.EXE oder ein Programm per START-Befehl gestartet wurde.
   Funktion:
   Identifiziert das aufgerufene Programm und jeweilige Bedingungen seiner
   Umgebung; unterscheidet evtl. von anderen Sessions des gleichen Programms;
   berwacht seine Beendigung, damit Archivupdates und Cleanups der tempor-
   ren Daten durch INFOMAN.CMD nicht zu frh erfolgen.-

   Aus S- und SR-Aufrufen erhlt IMANRX.CMD die START-Parameter. -
   Aus V-Aufrufen erhlt es die Parameter:
   %1    = V = Flag fr einen VIEW-Lauf zur Unterscheidung dieser Aufrufart
   %SD%  = aktuelles Verzeichnis des aktuellen VIEW-Aufrufs
   %BMX% = aktuelles Verzeichnis des ltesten VIEW-Aufrufs durch iNFOMAN
           (Dieses mu immer alle Bookmark-Files laufender iNFOMAN-VIEW-
           Aufrufe enthalten).

   Optimierungen:
   Temporre FIND-Kopien vermeiden Festplattenzugriffe bei Abfragen.
   Wartepausen halten Systembelastung gering und ermglichen die
   Erfassung auch "verspteter" Programmstarts.

   Nheres s. IMANRX.DOK.
*/

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/* Maximal 6 Parameter sind mglich. Der erste bestimmt die Aufrufart.
   Wenn V: Routine ONLINE. Sonst S/SR: Routine PROGWATCH. */
arg P1 P2 P3 P4 P5 P6;
      /* Temporre Kopie von FIND.EXE soll Festplattenzugriffe reduzieren: */
FIND = SysSearchPath('PATH', 'FIND.EXE');              /* Datei suchen und */
'@if not exist .\find.exe copy 'FIND' > nul';     /* auf RAM-Disk kopieren */

if P1 = "V" then do;
   call ONLINE;                               /* zur Routine fr V-Aufrufe */
   end;
else; do;
   call PROGWATCH;                    /* zur Routine fr S- und SR-Aufrufe */
   '@del .\find.exe 2>nul 1>nul';               /* temporres FIND lschen */
end;
exit;                                      /* .. und zurck zu INFOMAN.CMD */

/* ----------------------------------------------------------------------- */
/* Routine zur berwachung eines S- oder SR-Aufrufs */
PROGWATCH:

/* Max. 6 Parameter. Aber welcher ist der Programmaufruf?
   Als Kette einlesen und deren "Worte" auf Programmextent filtern: Erster
   gefundener Fall wird identifiziert.                                     */
Parameter_Kette = P1||" "||P2||" "||P3||" "||P4||" "||P5||" "||P6;
ProgCall = "";

do while Parameter_Kette <> "" & ProgCall = ""
   Parse Upper Var Parameter_Kette Parm Parameter_Kette
                                      /* fr lange und kurze Programmnamen */
   if length(Parm) >= 4 then
      Ext = substr(Parm,length(Parm)-3,4);
   if Ext = ".EXE" | Ext = ".COM" | Ext = ".CMD" | Ext = ".BAT"
      then ProgCall = Parm; iterate;
end; /* do while */

if ProgCall = "" then do;
 say "Fehler: Der Start-Befehl enthlt keinen gltigen Programmaufruf!"
 say "Fehler! Abbruch ...!"
 return;
end; /* do */
                              /* Filespec zerlegen in drei Komponenten und
                               Backslashes verdoppeln fr bergabe an FIND */
Laufw =filespec(d,ProgCall)
Pfad  =filespec(p,ProgCall)
Name  =filespec(n,ProgCall)
ProgCall = Laufw||'\'||Pfad||'\'||Name;
Lostit = -1;                     /* Programmbeendigungs-Flag initalisieren */
                 /* Referenzvariable Gotit initialisieren: Hier wird erste
                    der gefundenen Zeilen landen; enthlt den jngsten von
                    evtl. mehreren Prozessen mit dem gesuchten Namen.      */
Gotit = "";
                /* Jetzt erstmal 5 Sek. warten, damit wir nicht zu frh
                   prfen, falls sich der Programmaufruf verzgern sollte. */
call syssleep 5;
'@pstat /c|.\find /i "'||ProgCall||'"|rxqueue';    /* FIND: Programmaufruf */
i=queued();
if i <> 0 then do;                    /* OS/2-Prog gleich hier abfangen... */
  parse pull Zeile;
  Gotit = subword(Zeile,1,4);       /* Worte 1 - 4 der Zeile sind konstant */
end;
                    /* Wenn Programm nicht gefunden wird, ist es eine VDM!
                                         Dann eben nach "(kernel)" suchen! */
if i=0 then ProgCall = '(kernel)';

do until j=0;                                /* Solange was gefunden wird, */

  if ProgCall = '(kernel)' then;  /* VDM mit /l in Runtime Link Lib suchen */
  '@pstat /l|.\find /i "'||ProgCall||'"|rxqueue';/* fragl. Zeilen in Queue */
  else;               /* ODER: OS/2-Programm mit /c als Prozenamen suchen */
  '@pstat /c|.\find /i "'||ProgCall||'"|rxqueue';/* fragl. Zeilen in Queue */

  j=queued();
  call syssleep 5;                                        /* 5 Sek. warten */

  if j <> 0 then do;
    Lostit = 0;                                       /* Flag zurcksetzen */
    i=0;                                      /* Zeilenzhler zurcksetzen */
    do j;                                     /* Fr jede gefundene Zeile: */
       i=i+1;                                              /* Zeilenzhler */
       parse pull Zeile;                                /* Zeile speichern */

                             /* 1. Abfrage, 1. Zeile: Gesuchte Session da? */
       if (Gotit = "") & (i = 1) then do;
          Gotit = subword(Zeile,1,4);   /* Dann konstanten Teil speichern. */
       end; /* do */

             /* Wird identifizierte Session in irgendeiner Zeile gefunden,
                                              Flag setzen zum Weitermachen */
       if Gotit = subword(Zeile,1,4) then Lostit = 1;
    end; /* do j */

             /* Wird identifizierte Session in keiner Zeile mehr gefunden,
                         j-Flag zurckssetzen, damit Schleife beendet wird */
    if Lostit = 0 then j = 0;
  end; /* if j <> 0 then do */

end; /* do until j = 0 */
say "Das aufgerufene Programm wurde beendet!";
return; /* zurck zur Hauptroutine */

/* ----------------------------------------------------------------------- */
/* Routine zur berwachung eines V-Aufrufs */
ONLINE:

do until i=0;
          /* Solange aktuelle VIEW-Instanz luft, ist Umbenennen der *.INF
                   in ihrem aktuellen Verzeichnis P2 = %SD% nicht mglich. */
   '@ren '||P2||'\*.inf *.inf 2>nul 1>nul'
                       /* Wenn das geschafft wurde, wird Ende-Flag gesetzt */
   if rc = 0 then i=0;
                    /* Wenn VIEW noch luft, bleibt Flag unverndert, und
                        es wird etwas gewartet, um es erneut zu versuchen. */
   else do;
     i=1;
     call syssleep 5;
   end;
end; /* do until */
                             /* Nachdem aktuelle VIEW-Instanz beendet ist,
                                 Online-Bcher und Find schon mal lschen. */
 '@del '||P2||'\*.inf find.exe 2>nul 1>nul';
                          /* Wenn es die lteste iNFOMAN-VIEW-Instanz war,
                           wird geprft, ob noch irgendeine Instanz luft.
                                 (andernfalls gleich raus und zum Cleanup) */
if P2 = P3 then
  do until i=0;
                     /* Ist der Fall, solange DOCCOM.DAT gefunden wird ... */
    '@pstat /m|find "DOCCOM.DAT"|rxqueue'
    i=queued();
    if i>0 then do;                    /* Solange i > 0, luft noch etwas. */
       do i;pull;end;                                       /* clear queue */
       call syssleep 5;                        /* Dann wird noch gewartet. */
    end; /* if */
                      /* Kein "DOCCOM.DAT" mehr gefunden. Tschss und weg. */
  end; /* do until */

return; /* zurck zur Hauptroutine */
