/* Rexx Exit for BkpDemon	

 This routine is called for every file which has been selected for backup
 (unless you have un-checked the appropriate option in the Profile).

 You may execute your personal examinations on that file possibly resulting
 in that the file will not be backup'ed.

 You must set the return-code:

 Return: 0 => File is NOT to be excluded	
         1 => File is to be excluded from current backup
*/

Actual_FileSpec = strip(arg(1),,'"');

SIGNAL ON ERROR   Name AbEx;
SIGNAL ON FAILURE Name AbEx;
SIGNAL ON SYNTAX  Name AbEx;

if(0) then
  say "Entering _Exclude.cmd with Actual_FileSpec='"Actual_FileSpec"'.";

/* 
   Put your personal examinations here
*/


/* This is an example for excluding special files:			*/
/* Don't backup files which are already in a 'backup'-directory:	*/

Path = filespec("path",Actual_FileSpec);
Path = strip(Path,"L","\");	/* '....\....\....\'			*/
Rest = Path;
do while Rest <> ""
  parse value Rest with Dir "\" Rest;
  if translate(Dir) = "BACKUP"  ,
   | translate(Dir) = "_BACKUP" then RETURN 1;	/* exclude this file from backup	*/
end;


return 0;	/* do not exclude this file from backup			*/

/* ---------------------------------------------------------------	*/
AbEx:
say "Abnormal program interruption in _Exclude.cmd on line "SIGL":";
say "'" || sourceline(SIGL) || "'";
return -1;
