/* An example using RXSET with a MENU Group. We create the window with
   an "empty" MENU Group (ie, Set the TotalMenus value to 0). Then, after
   the window is created (with NOCLOSE), we add a menu bar with RXSET.
   If the user selects some menu item, RXDLG returns, and we delete all of
   the menu items */

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE


/* ====================== 'Main Window' ======================= */
/* MENU Group */
RXTYPE.1 = 'MENU'

/* TotalMenus=0 means an "empty" MENU Group */
RXINFO.1 = '0'

/* Default */
RXFLAGS.1 = ' '

/* Default size and position (also gives us sizing and max button) */
RXWINMAIN = ' '

/* Specify NOCLOSE since we want to close the window ourselves.
   No RESULT Flag, so the ESC and ENTER keys do nothing, and we don't have to
   bother checking for those */
RXDLG 1 '"Main Window"' 'RXWINMAIN' 'NOCLOSE'

/* Associate the help file (so that we can use the HELP menu). Note that
   Rexx Dialog automatically displays panels from it when the user
   selects items in the HELP menu */
RXHELP 'CREATE' '""' 'TEST.HLP'

/* Add a menu bar now that the window is open */

/* Menu 1 */
MENU1.0 = 'File'
MENU1.1 = 'Open|2'  /* NOTE: 2 subitems */
MENU1.2 = 'Save'
MENU1.3 = ' '  /* End of Menu 1 */

/* Menu 1, Item 1 subitems */
MENU1.1.1 = 'All'
MENU1.1.2 = 'Excerpt'

/* Menu 2 */
MENU2.0 = 'Edit'
MENU2.1 = 'Cut'
MENU2.2 = 'Copy'
MENU2.3 = 'Paste'
MENU2.4 = ' '  /* End of Menu 2 */

/* NOTE: If you didn't want the Help menu, then the Value arg would be
 '|MENU1|MENU2' */
RXSET '"Main Window"' 1 0 'ADD' 'HELP|MENU1|MENU2'

more:
/* Do user interaction */
RXDLG

/* IF user clicked upon CLOSE ICON, exit */
IF RXID < 0 THEN EXIT

/* Delete all of the menus */
RXSET '"Main Window"' 1 0 'DEL'

SIGNAL more

/* ==================================================== */

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
