/* An example of a Modal Design. It creates a Main Window, and then several
   Child Dialogs. Since all Children are MODAL, and we specify a specific window
   to RXDLG, we can control the order that the user is allowed to interact with
   the windows.
*/

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* ================ Create "Main Window" =============== */
/* First Group is ENTRY */
RXTYPE.1 = 'ENTRY'

/* Use of a control in this group causes RXDLG to return */
RXFLAGS.1 = 'END'

/* Labels for each entry, and Groupbox. Note: 3rd entry has no label */
RXLABEL.1 = 'Range|Second||Fourth|All'

/* Variable name where the text "typed into" the entries is stored */
RXVAL.1 = 'TEXT'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '4 2 45'

/* Position of Group */
RXX.1 = 65
RXY.1 = 70

/* The text for the 4 entries */
TEXT.1 = 'Hello'
TEXT.2 = 'Hi'
TEXT.3 = ' '         /* A blank entry initially */
TEXT.4 = 'More text'

/* Default size and position (also gives us sizing and max button) */
RXWIN1 = ''

RXDLG 1 '"Main Window"' 'RXWIN1' 'RESULT'





/* ================ Create "Pushbuttons"  dialog =============== */
/* First Group is PUSH */
RXTYPE.1 = 'PUSH'

/* Use of a control in this group causes RXDLG to return */
RXFLAGS.1 = 'END'

/* Labels for each button, and Groupbox */
RXLABEL.1 = 'One|Two|Three|Four|Choices'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '4 2 0'

/* Default choice for PushButton is nothing */
RXVAL.1 = ''

/* Position */
RXX.1 = 7
RXY.1 = 6

/* Let Rexx Dialog close the dialog (ie, no NOCLOSE). Because we specified
  MODAL, later when we pass this window title to RXDLG to perform user
  interaction, the user will be able to interact only with this window */
RXWIN2 = '190 108 8 8'
RXDLG 1 '"Pushbuttons"' 'RXWIN2' 'MODAL'




/* ================== Create "Spin Me" dialog ================= */
/* First Group is SPIN */
RXTYPE.1 = 'SPIN'

/* Default */
RXFLAGS.1 = ''

/* Max, Min, Label for each slider, and groupbox */
RXLABEL.1 = '255 0 Range 1:| 20 10 Range 2:|Try us'

/* Values for each slider */
RXVAL.1 = '64 19'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '2 1 70'

/* Position */
RXX.1 = 80
RXY.1 = 18

RXWIN3 = '190 104 30 30'
RXDLG 1 '"Spin Me"' 'RXWIN3' 'MODAL|SIZE|RESULT'




/* ================= Create "List 1" Dialog ================== */
RXTYPE.1 = 'LIST'

/* Default */
RXFLAGS.1 = ''

/* Labels for each listbox, and Groupbox */
RXLABEL.1 = 'Items: | Fruits: | List boxes'

/* Stem variable names to fetch the strings for each dropbox in the group */
RXVAL.1 = 'BLORT|LIST'

/* TotalControls, ControlsPerLine, WidthOfControls, *AND* NumVisibleItems */
RXINFO.1 = '2 1 100 4'

/* Position */
RXX.1 = 10
RXY.1 = 10

/* First List items */
BLORT.1 = 'One'
BLORT.2 = 'Two'
BLORT.3 = 'Three'
BLORT.4 = 'Four'
BLORT.5 = 'Five'
BLORT.6 = ' '  /* Marks the end of the list */

/* Second List items */
LIST.1 = 'Bananas'
LIST.2 = 'Oranges'
LIST.3 = 'Grapes'
LIST.4 = 'Apples'
LIST.5 = ' '  /* Marks the end of the list */

RXWIN4 = '130 234 100 8'
RXDLG 1 '"List 1"' 'RXWIN4' 'MODAL|RESULT'

/* Do user interaction. Because we specify "List 1", and its MODAL,
   the user is limited to interacting with this window */
RXDLG '"List 1"' /* No Operation means Operation 0 */

/* RXWIND now specifies which window woke us up. Because we specified MODAL,
    then it must have been "Child 1" which caused RXDLG to return. The window
    is no longer there because we didn't specify NOCLOSE for Child 1 */
RXSAY '"'RXWIND'" woke us up.'

/* Did user press ESC or click the CLOSE ICON? */
IF RXID < 0 THEN DO
    RXSAY '"'RXWIND'" aborted.'
END

/* Did user press the ENTER key while the window had the focus?
   Note that we haven't setup a timeout, nor set the KEYS flag
   of any window, so we don't need to check RXSUBID. It's always
   going to be 10 (ie, ENTER) here if RXID is 0 */
IF RXID = 0 THEN DO
    RXSAY 'Pressed ENTER on "'RXWIND'".'
END

/* If RXID is greater than 0, then this is the Group #, and RXSUBID is the
   Control # (within that group), of the control that caused RXDLG to
   return. NOTE: The first control within the first group (for this dialog) has a
   Group # and Control # of 1 */
IF RXID > 0 THEN DO
   RXSAY 'Group #'RXID', Control #'RXSUBID' ended "'RXWIND'" dialog.'
END

/* Display the selection for each of the 2 list boxes.
    NOTE: This group is SINGLE SELECT */
RXSAY '"'RXWIND'" Group 1, list 1 choice is "'BLORT.0'"'
RXSAY '"'RXWIND'" Group 1, list 2 choice is "'LIST.0'"'




/* ================ Do "Spin Me" ================ */
/* Do user interaction. Because we specify "Spin Me", and its MODAL,
   the user is limited to interacting with this window */
RXDLG '"Spin Me"'

/* Report which window woke us up. It will be "Spin Me" */
RXSAY '"'RXWIND'" woke us up.'

/* Did user press ESC or click the CLOSE ICON? */
IF RXID < 0 THEN DO
    RXSAY '"'RXWIND'" aborted.'
END

/* Did user press the ENTER key? */
IF RXID = 0 THEN DO
    RXSAY 'Pressed ENTER on "'RXWIND'".'
END

IF RXID > 0 THEN DO
   /* Display the Group #, Control # of the control that caused RXDLG to return */
   RXSAY 'Group #'RXID', Control #'RXSUBID' ended "'RXWIND'" dialog.'
END

/* Display spin values */
DO i = 1 TO 2
    PARSE VAR RXVAL.1 knob RXVAL.1
    RXSAY '"'RXWIND'" Group 1, Knob #'i' = 'knob
END




/* ================ Do "Pushbuttons" ================ */
RXDLG '"Pushbuttons"' 1

/* Report which window woke us up. It will be "Pushbuttons" */
RXSAY '"'RXWIND'" woke us up.'

/* Did user click the CLOSE ICON? ESC won't cause RXDLG to return
   because we didn't set the RESULT Flag for the "Pushbuttons" dialog.
   For the same reason, the ENTER key also does nothing */
IF RXID < 0 THEN DO
    RXSAY '"'RXWIND'" aborted.'
END

IF RXID > 0 THEN DO
   /* Display the Group #, Control # of the control that caused RXDLG to return */
   RXSAY 'Group #'RXID', Control #'RXSUBID' ended "'RXWIND'" dialog.'
END

/* Display chosen button #'s. NOTE: RXVAL could be "" for a PUSH/CHECK/RADIO
    button group if the user didn't use any buttons and we didn't initially
    set any of them (ie, RXVAL was a null string when the group was created),
    or if there are ALL and NONE buttons and the user selected ALL. By setting
    the RXVAL for a PUSH or RADIO BUTTON group to "" before calling RXDLG,
    you can determine whether the user selected any of the buttons */
IF RXVAL.1 > '' THEN RXSAY '"'RXWIND'" Group 1, pushed button #'RXVAL.1
ELSE RXSAY '"'RXWIND'" Group 1, no button pushed.'




/* ================ Do "Main Window" ================ */
RXDLG '"Main Window"'
  /* Operation=PROCESS_AND_END. Note that if we wanted to keep the main window
     around so that we could keep calling RXDLG in a message loop, then we
     wouldn't specify NOCLOSE, and do Operation 0 until such time as we
     detected some condition  that prompted us to do Operation 3 or 4, and end
     this script. For example, we could launch into that if we detect the ESC key
     pressed or user clicked upon CLOSE ICON */

/* Report which window woke us up. It will be "Main Window" */
RXSAY '"'RXWIND'" woke us up.'

/* Did user press ESC or CLOSE the window? */
IF RXID < 0 THEN DO
    RXSAY '"'RXWIND'" aborted.'
END

/* Did user press the ENTER key while the dialog window had the focus? */
IF RXID = 0 THEN DO
    RXSAY 'Pressed ENTER on "'RXWIND'".'
END

IF RXID > 0 THEN DO
   /* Display the Group #, Control # of the control that caused RXDLG to return */
   RXSAY 'Group #'RXID', Control #'RXSUBID' ended "'RXWIND'" dialog.'
END

/* Display each entry's text, one entry at a time */
DO i = 1 TO 4 /* There are 4 entries in this Group */
    RXSAY '"'RXWIND'" Group 1, entry #'i' is "'TEXT.i'"'
END


/* ========================== Done ========================== */
EXIT

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
